/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class TheoremNode
extends LevelNode {
    ModuleNode module;
    LevelNode theoremExprOrAssumeProve;
    private ThmOrAssumpDefNode def;
    boolean suffices = false;
    ProofNode proof;
    int levelChecked = 0;

    public TheoremNode(TreeNode stn, LevelNode theorem, ModuleNode mn, ProofNode pf, ThmOrAssumpDefNode opd) {
        super(12, stn);
        this.theoremExprOrAssumeProve = theorem;
        this.module = mn;
        this.def = opd;
        this.proof = pf;
        if (opd != null) {
            opd.thmOrAssump = this;
        }
    }

    public final LevelNode getTheorem() {
        return this.theoremExprOrAssumeProve;
    }

    public final ThmOrAssumpDefNode getDef() {
        return this.def;
    }

    public final boolean isSuffices() {
        return this.suffices;
    }

    public final ProofNode getProof() {
        return this.proof;
    }

    public final UniqueString getName() {
        if (this.def == null) {
            return null;
        }
        return this.def.getName();
    }

    @Override
    public final boolean levelCheck(int iter) {
        LevelNode[] sub;
        if (this.levelChecked >= iter) {
            return true;
        }
        this.levelChecked = iter;
        if (this.proof != null) {
            sub = new LevelNode[2];
            sub[1] = this.proof;
        } else {
            sub = new LevelNode[]{this.def != null ? this.def : this.theoremExprOrAssumeProve};
        }
        boolean retVal = this.levelCheckSubnodes(iter, sub);
        if (this.theoremExprOrAssumeProve == null) {
            return retVal;
        }
        OpApplNode oan = null;
        SymbolNode oanOp = null;
        if (this.theoremExprOrAssumeProve instanceof OpApplNode) {
            oan = (OpApplNode)this.theoremExprOrAssumeProve;
            oanOp = oan.operator;
        }
        if (oanOp != null && oanOp.getName() == OP_pick && oan.ranges != null && this.theoremExprOrAssumeProve.level == 3) {
            for (int i = 0; i < oan.ranges.length; ++i) {
                if (oan.ranges[i].getLevel() == 0) continue;
                errors.addError(oan.ranges[i].stn.getLocation(), "Non-constant bound of temporal PICK.");
            }
        }
        if (this.theoremExprOrAssumeProve.level == 3) {
            TheoremNode.LevelCheckTemporal(this.proof);
        }
        return retVal;
    }

    private static final void LevelCheckTemporal(ProofNode pn) {
        if (pn == null || pn.getKind() != 34) {
            return;
        }
        NonLeafProofNode pnode = (NonLeafProofNode)pn;
        for (int i = 0; i < pnode.getSteps().length; ++i) {
            LevelNode node = pnode.getSteps()[i];
            OpApplNode oanode = null;
            TheoremNode tnode = null;
            if (node.getKind() == 12) {
                tnode = (TheoremNode)node;
                if (tnode.theoremExprOrAssumeProve instanceof OpApplNode) {
                    oanode = (OpApplNode)tnode.theoremExprOrAssumeProve;
                }
            }
            if (oanode == null) continue;
            UniqueString name = oanode.operator.getName();
            if ((name == OP_take || name == OP_witness || name == OP_have) && oanode.getLevel() != 0) {
                errors.addError(oanode.stn.getLocation(), "Non-constant TAKE, WITNESS, or HAVE for temporal goal.");
                continue;
            }
            if (name == OP_pfcase) {
                if (oanode.getLevel() != 0) {
                    errors.addError(oanode.stn.getLocation(), "Non-constant CASE for temporal goal.");
                }
                TheoremNode.LevelCheckTemporal(tnode.getProof());
                continue;
            }
            if (name != OP_qed) continue;
            TheoremNode.LevelCheckTemporal(tnode.getProof());
        }
    }

    @Override
    public final String levelDataToString() {
        return "Level: " + this.getLevel() + "\n" + "LevelParameters: " + this.getLevelParams() + "\n" + "LevelConstraints: " + this.getLevelConstraints() + "\n" + "ArgLevelConstraints: " + this.getArgLevelConstraints() + "\n" + "ArgLevelParams: " + this.getArgLevelParams() + "\n";
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String res = "\n*TheoremNode " + super.toString(depth) + (this.theoremExprOrAssumeProve != null ? Strings.indent(2, this.theoremExprOrAssumeProve.toString(depth - 1)) : "");
        if (this.def != null) {
            res = res + Strings.indent(2, "\n def: " + Strings.indent(2, this.def.toString(depth - 1)));
        }
        if (this.suffices) {
            res = res + Strings.indent(2, "\n SUFFICES step");
        }
        if (this.proof != null) {
            res = res + Strings.indent(2, "\n proof: " + Strings.indent(2, this.proof.toString(depth - 1)));
        }
        return res;
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.proof == null) {
            return new SemanticNode[]{this.theoremExprOrAssumeProve};
        }
        return new SemanticNode[]{this.theoremExprOrAssumeProve, this.proof};
    }

    @Override
    public final void walkGraph(Hashtable semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        if (this.theoremExprOrAssumeProve != null) {
            this.theoremExprOrAssumeProve.walkGraph(semNodesTable);
        }
        if (this.proof != null) {
            this.proof.walkGraph(semNodesTable);
        }
    }

    @Override
    public Element export(Document doc, SymbolContext context) {
        if (this.getDef() == null) {
            return super.export(doc, context);
        }
        return this.getDef().export(doc, context);
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element e = doc.createElement("TheoremNode");
        e.appendChild(this.getTheorem().export(doc, context));
        if (this.getProof() != null) {
            e.appendChild(this.getProof().export(doc, context));
        }
        if (this.isSuffices()) {
            e.appendChild(doc.createElement("suffices"));
        }
        return e;
    }
}

