/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.prob.annotations.Dangerous;
import de.prob.scripting.ScriptEngineProvider;
import de.prob.web.AbstractSession;
import de.prob.web.WebUtils;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptEngine;
import javax.servlet.AsyncContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dangerous
public class GroovyConsoleSession
extends AbstractSession {
    private final Logger logger = LoggerFactory.getLogger(GroovyConsoleSession.class);
    private final ScriptEngine engine;

    @Inject
    public GroovyConsoleSession(UUID id, ScriptEngineProvider sep) {
        super(id);
        this.engine = sep.get();
    }

    public Object exec(Map<String, String[]> params) {
        this.logger.trace("Exec");
        String line = this.get(params, "line");
        try {
            StringBuffer console = new StringBuffer();
            this.engine.put("__console", console);
            this.logger.trace("Eval {} on {}", (Object)line, (Object)this.engine.toString());
            Object eval = this.engine.eval(line);
            String resultString = eval.toString();
            this.logger.trace("Evaled {} to {}", (Object)line, (Object)resultString);
            return WebUtils.wrap("cmd", "Console.groovyResult", "result", StringEscapeUtils.escapeHtml((String)resultString), "output", console.toString());
        }
        catch (Exception e) {
            return WebUtils.wrap("cmd", "Console.groovyError", "message", e.getMessage(), "trace", this.extractTrace(e.getStackTrace()));
        }
    }

    private String extractTrace(StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            return "";
        }
        if (stackTrace.length == 1) {
            return "at " + stackTrace[0].toString();
        }
        return "at " + stackTrace[0].toString() + System.getProperty("line.separator") + "...";
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/console/index.html");
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
    }
}

