/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.prob.core.sablecc.parser;

import de.prob.core.sablecc.lexer.*;
import de.prob.core.sablecc.node.*;
import de.prob.core.sablecc.analysis.*;
import java.util.*;
import de.hhu.stups.sablecc.patch.*;


import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings({"rawtypes","unchecked"})
public class Parser implements IParser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;
    
    private ArrayList firstPopped = null;
    private ArrayList lastPopped = null;
    private ITokenListContainer lex;

    public Parser(  Lexer lexer)
    {
        this.lexer = lexer;
        this.lex = lexer; 
    }
    
     
    private Map<PositionedNode, SourcecodeRange> mapping = new HashMap<PositionedNode, SourcecodeRange>();    
    public Map<PositionedNode, SourcecodeRange> getMapping() { 	return this.mapping; }

   private void checkResult(Object elementToCheck) {
       checkResult(elementToCheck, false);
   }

	 
	private void checkResult(Object elementToCheck, boolean slurp) {
		// nodes with no tokens or sub nodes at all may exist
		if (this.firstPopped == null) {
			return;
		}

		if (elementToCheck instanceof LinkedList) {
			/*
			 * special case: this is a list of nodes, for example an identifier
			 * list, so we don't want to check the list but the last element
			 * added to it
			 */
			final LinkedList nodeList = (LinkedList) elementToCheck;

			if (nodeList.size() > 0) {
				elementToCheck = nodeList.get(nodeList.size() - 1);
			} else {
				// no positions for empty lists...
				return;
			}
		}

		if (!(elementToCheck instanceof PositionedNode)) {
			throw new Error(
					"Unexpected elementToCheck (not instanceof PositionedNode): "
							+ elementToCheck.getClass().getSimpleName() + "/"
							+ elementToCheck);
		}

		if (!this.getMapping().containsKey(elementToCheck) || slurp ) {
			final PositionedNode node = (PositionedNode) elementToCheck;

			// dealing with a one-token element
			if (this.lastPopped == null) {
				this.lastPopped = this.firstPopped;
			}

			final int begin = findBeginPos(this.lastPopped, node);
			int end = findEndPos(this.firstPopped);
			if (end == -1) end = begin;
			final SourcecodeRange range = new SourcecodeRange(begin, end);

			this.getMapping().put(node, range);

			node.setStartPos(createBeginPos(begin));
			node.setEndPos(createEndPos(end));
		}
	}
	
	 
	private int findBeginPos(final ArrayList list,
			PositionedNode n) {
		Object first = list.get(0);
		if (!(first instanceof PositionedNode) && !(first instanceof IToken)) {
			List list2 = (List) first;

			if (list2.size() > 0) {
				first = list2.get(0);
			} else {
				/*
				 * Sometimes (haven't found out why) we get empty list here. In
				 * the only observed cases we were looking for the source range
				 * of the whole parse unit. Then the index is 0.
				 */
				return 0;
			}
		}

		if (first instanceof IToken) {
			return findIndex((IToken) first);
		}

		final PositionedNode node = (PositionedNode) first;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null){
			System.err.println(n.getClass().getSimpleName() + " / " + node.getClass().getSimpleName() + ": " + node);
		}
		return item.getBeginIndex();
	}

	 
	private int findEndPos(final ArrayList list) {
		Object last = list.get(list.size() - 1);
		if (!(last instanceof PositionedNode) && !(last instanceof IToken)) {
			final List list2 = (List) last;
			last = list2.get(list2.size() - 1);
		}

		if (last instanceof IToken) {
			return findIndex((IToken) last);
		}

		final PositionedNode node = (PositionedNode) last;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null)
			return -1;
		return item.getEndIndex();
	}

	private int findIndex(final IToken token) {
		final List<IToken> list = this.lex.getTokenList();

		for (int i = list.size() - 1; i >= 0; i--) {
			if (list.get(i) == token) {
				return i;
			}
		}

		return -1;
	}

	private SourcePosition createBeginPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos());
	}

	private SourcePosition createEndPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos()
				+ token.getText().length());
	}
	    protected void filter() throws ParserException, LexerException, IOException
    {
        // Empty body
    }

    private void push(int numstate, ArrayList listNode, boolean hidden) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!hidden)
        {
            filter();
        }

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
    	ArrayList list = ((State) this.stack.previous()).nodes; 
		if (this.firstPopped == null) {
			this.firstPopped = list;
		} else {
			this.lastPopped = list;
		}
        return list;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

     
    public Start parse() throws ParserException, LexerException, IOException
    {
    	this.getMapping().clear();
    
        push(0, null, true);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list, false);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce ANoResult */
		    {
			ArrayList list = new0();
			push(goTo(0), list, false);
		    }
		    break;
                    case 1: /* reduce AYesResult */
		    {
			ArrayList list = new1();
			push(goTo(0), list, false);
		    }
		    break;
                    case 2: /* reduce AInterruptedResult */
		    {
			ArrayList list = new2();
			push(goTo(0), list, false);
		    }
		    break;
                    case 3: /* reduce AExceptionResult */
		    {
			ArrayList list = new3();
			push(goTo(0), list, false);
		    }
		    break;
                    case 4: /* reduce ANumberTerm */
		    {
			ArrayList list = new4();
			push(goTo(1), list, false);
		    }
		    break;
                    case 5: /* reduce AAtomTerm */
		    {
			ArrayList list = new5();
			push(goTo(1), list, false);
		    }
		    break;
                    case 6: /* reduce AVariableTerm */
		    {
			ArrayList list = new6();
			push(goTo(1), list, false);
		    }
		    break;
                    case 7: /* reduce ATerm */
		    {
			ArrayList list = new7();
			push(goTo(1), list, false);
		    }
		    break;
                    case 8: /* reduce AParams */
		    {
			ArrayList list = new8();
			push(goTo(2), list, false);
		    }
		    break;
                    case 9: /* reduce AEmptyMoreParams */
		    {
			ArrayList list = new9();
			push(goTo(3), list, false);
		    }
		    break;
                    case 10: /* reduce AMoreParams */
		    {
			ArrayList list = new10();
			push(goTo(3), list, false);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PResult node1 = (PResult) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " ,
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



     
    ArrayList new0() /* reduce ANoResult */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PResult presultNode1;
        {
            // Block
        TNo tnoNode2;
        tnoNode2 = (TNo)nodeArrayList1.get(0);

        presultNode1 = new ANoResult(tnoNode2);
        }
	nodeList.add(presultNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new1() /* reduce AYesResult */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PResult presultNode1;
        {
            // Block
        TYes tyesNode2;
        TLPar tlparNode3;
        PTerm ptermNode4;
        TRPar trparNode5;
        tyesNode2 = (TYes)nodeArrayList1.get(0);
        tlparNode3 = (TLPar)nodeArrayList2.get(0);
        ptermNode4 = (PTerm)nodeArrayList3.get(0);
        trparNode5 = (TRPar)nodeArrayList4.get(0);

        presultNode1 = new AYesResult(tyesNode2, tlparNode3, ptermNode4, trparNode5);
        }
	nodeList.add(presultNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new2() /* reduce AInterruptedResult */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PResult presultNode1;
        {
            // Block
        TInterrupted tinterruptedNode2;
        tinterruptedNode2 = (TInterrupted)nodeArrayList1.get(0);

        presultNode1 = new AInterruptedResult(tinterruptedNode2);
        }
	nodeList.add(presultNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new3() /* reduce AExceptionResult */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PResult presultNode1;
        {
            // Block
        TException texceptionNode2;
        TString tstringNode3;
        texceptionNode2 = (TException)nodeArrayList1.get(0);
        tstringNode3 = (TString)nodeArrayList2.get(0);

        presultNode1 = new AExceptionResult(texceptionNode2, tstringNode3);
        }
	nodeList.add(presultNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new4() /* reduce ANumberTerm */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTerm ptermNode1;
        {
            // Block
        TNumber tnumberNode2;
        tnumberNode2 = (TNumber)nodeArrayList1.get(0);

        ptermNode1 = new ANumberTerm(tnumberNode2);
        }
	nodeList.add(ptermNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new5() /* reduce AAtomTerm */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTerm ptermNode1;
        {
            // Block
        TName tnameNode2;
        tnameNode2 = (TName)nodeArrayList1.get(0);

        ptermNode1 = new AAtomTerm(tnameNode2);
        }
	nodeList.add(ptermNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new6() /* reduce AVariableTerm */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PTerm ptermNode1;
        {
            // Block
        TVariable tvariableNode2;
        tvariableNode2 = (TVariable)nodeArrayList1.get(0);

        ptermNode1 = new AVariableTerm(tvariableNode2);
        }
	nodeList.add(ptermNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new7() /* reduce ATerm */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PTerm ptermNode1;
        {
            // Block
        TName tnameNode2;
        PParams pparamsNode3;
        tnameNode2 = (TName)nodeArrayList1.get(0);
        pparamsNode3 = (PParams)nodeArrayList2.get(0);

        ptermNode1 = new ATerm(tnameNode2, pparamsNode3);
        }
	nodeList.add(ptermNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new8() /* reduce AParams */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PParams pparamsNode1;
        {
            // Block
        TLPar tlparNode2;
        PTerm ptermNode3;
        PMoreParams pmoreparamsNode4;
        TRPar trparNode5;
        tlparNode2 = (TLPar)nodeArrayList1.get(0);
        ptermNode3 = (PTerm)nodeArrayList2.get(0);
        pmoreparamsNode4 = (PMoreParams)nodeArrayList3.get(0);
        trparNode5 = (TRPar)nodeArrayList4.get(0);

        pparamsNode1 = new AParams(tlparNode2, ptermNode3, pmoreparamsNode4, trparNode5);
        }
	nodeList.add(pparamsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new9() /* reduce AEmptyMoreParams */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

        PMoreParams pmoreparamsNode1;
        {
            // Block

        pmoreparamsNode1 = new AEmptyMoreParams();
        }
	nodeList.add(pmoreparamsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new10() /* reduce AMoreParams */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PMoreParams pmoreparamsNode1;
        {
            // Block
        TComma tcommaNode2;
        PTerm ptermNode3;
        PMoreParams pmoreparamsNode4;
        tcommaNode2 = (TComma)nodeArrayList1.get(0);
        ptermNode3 = (PTerm)nodeArrayList2.get(0);
        pmoreparamsNode4 = (PMoreParams)nodeArrayList3.get(0);

        pmoreparamsNode1 = new AMoreParams(tcommaNode2, ptermNode3, pmoreparamsNode4);
        }
	nodeList.add(pmoreparamsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, },
			{{-1, REDUCE, 0}, },
			{{-1, ERROR, 2}, {5, SHIFT, 6}, },
			{{-1, REDUCE, 2}, },
			{{-1, ERROR, 4}, {12, SHIFT, 7}, },
			{{-1, ERROR, 5}, {13, ACCEPT, -1}, },
			{{-1, ERROR, 6}, {9, SHIFT, 8}, {10, SHIFT, 9}, {11, SHIFT, 10}, },
			{{-1, REDUCE, 3}, },
			{{-1, REDUCE, 4}, },
			{{-1, REDUCE, 5}, {5, SHIFT, 12}, },
			{{-1, REDUCE, 6}, },
			{{-1, ERROR, 11}, {6, SHIFT, 14}, },
			{{-1, ERROR, 12}, {9, SHIFT, 8}, {10, SHIFT, 9}, {11, SHIFT, 10}, },
			{{-1, REDUCE, 7}, },
			{{-1, REDUCE, 1}, },
			{{-1, REDUCE, 9}, {4, SHIFT, 16}, },
			{{-1, ERROR, 16}, {9, SHIFT, 8}, {10, SHIFT, 9}, {11, SHIFT, 10}, },
			{{-1, ERROR, 17}, {6, SHIFT, 19}, },
			{{-1, REDUCE, 9}, {4, SHIFT, 16}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 10}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 5}, },
			{{-1, 11}, {12, 15}, {16, 18}, },
			{{-1, 13}, },
			{{-1, 17}, {18, 20}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: 'no', 'yes', 'interrupted', 'exception'",
			"expecting: EOF",
			"expecting: l par",
			"expecting: string",
			"expecting: number, name, variable",
			"expecting: comma, r par",
			"expecting: comma, l par, r par",
			"expecting: r par",
        };*/
    private static int[] errors;
/*      {
			0, 1, 2, 1, 3, 1, 4, 1, 5, 6, 5, 7, 4, 5, 1, 5, 4, 7, 5, 5, 7, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
