/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.ComputationNotCompletedResult;
import de.prob.animator.domainobjects.EvalResult;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.util.Tuple2;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.AsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueOverTime
extends AbstractAnimationBasedView {
    List<FormulaElement> testedFormulas = new CopyOnWriteArrayList<FormulaElement>();
    IEvalElement time = null;
    Map<String, IEvalElement> formulas = new ConcurrentHashMap<String, IEvalElement>();
    Logger logger = LoggerFactory.getLogger(ValueOverTime.class);
    private Trace currentTrace;
    private final StateSpace stateSpace;
    private String mode = "over";

    @Inject
    public ValueOverTime(AnimationSelector animations) {
        super(animations);
        this.incrementalUpdate = false;
        this.currentTrace = animations.getCurrentTrace();
        if (this.currentTrace == null) {
            this.stateSpace = null;
        } else {
            this.stateSpace = this.currentTrace.getStateSpace();
            animations.registerAnimationChangeListener((IAnimationChangeListener)this);
        }
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        if (this.stateSpace == null) {
            return "<html><head><title>Value Over Time</title></head></html>";
        }
        Map<String, String> scope = WebUtils.wrap("clientid", clientid, "id", UUID.randomUUID().toString());
        return WebUtils.render("ui/valueOverTime/index.html", scope);
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        if (this.stateSpace != null) {
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            for (FormulaElement formula : this.testedFormulas) {
                result.add(WebUtils.wrap("id", formula.id, "formula", formula.formula.getCode()));
            }
            List<Object> data = this.calculateData();
            IEvalElement time = this.formulas.get("time");
            Map<String, String> wrap = WebUtils.wrap("cmd", "ValueOverTime.restorePage", "formulas", WebUtils.toJson(result), "time", time == null ? "" : time.getCode(), "data", WebUtils.toJson(data), "xLabel", time == null ? "Number of Animation Steps" : time.getCode(), "drawMode", this.mode);
            this.submit(wrap);
        }
    }

    @Override
    public void performTraceChange(Trace trace) {
        if (this.stateSpace != null && trace != null && trace.getStateSpace().equals(this.stateSpace)) {
            this.currentTrace = trace;
            List<Object> result = this.calculateData();
            IEvalElement time = this.formulas.get("time");
            Map<String, String> wrap = WebUtils.wrap("cmd", "ValueOverTime.draw", "data", WebUtils.toJson(result), "xLabel", time == null ? "Number of Animation Steps" : time.getCode(), "drawMode", this.mode);
            this.submit(wrap);
        }
    }

    private List<Object> calculateData() {
        ArrayList<Object> result = new ArrayList<Object>();
        List timeRes = new ArrayList();
        if (this.time != null) {
            timeRes = this.currentTrace.eval((Object)this.time);
        }
        for (FormulaElement pair : this.testedFormulas) {
            String val;
            String id = pair.id;
            IEvalElement formula = pair.formula;
            if (id.equals("time")) continue;
            List results = this.currentTrace.eval((Object)formula);
            ArrayList<Map<String, Object>> points = new ArrayList<Map<String, Object>>();
            if (timeRes.isEmpty()) {
                int c = 0;
                for (Tuple2 it : results) {
                    if (it.getSecond() instanceof EvalResult) {
                        val = ((EvalResult)it.getSecond()).getValue();
                        points.add(this.wrapPoints((String)it.getFirst(), this.extractValue(val), c, this.extractType(val)));
                        points.add(this.wrapPoints((String)it.getFirst(), this.extractValue(val), c + 1, this.extractType(val)));
                    }
                    ++c;
                }
            } else if (timeRes.size() == results.size()) {
                for (Tuple2 it : results) {
                    int index = results.indexOf(it);
                    if (!(it.getSecond() instanceof EvalResult)) continue;
                    val = ((EvalResult)it.getSecond()).getValue();
                    String time = ((EvalResult)((Tuple2)timeRes.get(index)).getSecond()).getValue();
                    String timePlus = ((EvalResult)((Tuple2)timeRes.get(index)).getSecond()).getValue();
                    points.add(this.wrapPoints((String)it.getFirst(), this.extractValue(val), this.extractValue(time), this.extractType(val)));
                    if (index >= results.size() - 1) continue;
                    points.add(this.wrapPoints((String)it.getFirst(), this.extractValue(val), this.extractValue(timePlus), this.extractType(val)));
                }
            }
            HashMap<String, Object> datum = new HashMap<String, Object>();
            datum.put("name", formula.getCode());
            datum.put("dataset", points);
            datum.put("id", pair.id);
            result.add(datum);
        }
        return result;
    }

    private Map<String, Object> wrapPoints(String stateid, Integer value, Integer t, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stateid", stateid);
        map.put("value", value);
        map.put("t", t);
        map.put("type", type);
        return map;
    }

    private String extractType(String value) {
        if (value.equals("TRUE") || value.equals("FALSE")) {
            return "BOOL";
        }
        return "INT";
    }

    private Integer extractValue(String value) {
        if (value.equals("TRUE")) {
            return 1;
        }
        if (value.equals("FALSE")) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public Object changeMode(Map<String, String[]> params) {
        this.mode = params.get("varMode")[0];
        return null;
    }

    public Object addFormula(Map<String, String[]> params) {
        String id = params.get("id")[0];
        Boolean newFormula = Boolean.valueOf(params.get("newFormula")[0]);
        IEvalElement formula = this.formulas.get(id);
        if (formula == null) {
            if ("time".equals(id)) {
                this.time = null;
                List<Object> data = this.calculateData();
                return WebUtils.wrap("cmd", "ValueOverTime.timeSet", "formula", "", "data", WebUtils.toJson(data), "xLabel", "Number of Animation Steps", "drawMode", this.mode);
            }
            return this.sendError(id, "Whoops!", "Could not add formula because it is invalid for this model", "alert-danger");
        }
        try {
            AbstractEvalResult res = this.currentTrace.evalCurrent((Object)formula);
            if (res == null) {
                return this.sendError(id, "Warning!", "Could not add formula because it is not possible to assert the validity of the formula at this state in the animation", "");
            }
            if (res instanceof ComputationNotCompletedResult) {
                return this.sendError(id, "Sorry!", "The specified formula cannot be evaluated for this model!", "alert-danger");
            }
            if (!this.correctType(id, res)) {
                return this.sendError(id, "Sorry!", "The specified formula must be of the correct type (Integer for time expression, Integer or boolean for other formula)", "alert-danger");
            }
            if ("time".equals(id)) {
                this.time = formula;
                List<Object> data = this.calculateData();
                return WebUtils.wrap("cmd", "ValueOverTime.timeSet", "formula", this.time.getCode(), "data", WebUtils.toJson(data), "xLabel", this.time.getCode(), "drawMode", this.mode);
            }
            if (newFormula.booleanValue()) {
                this.testedFormulas.add(new FormulaElement(id, formula));
                List<Object> data = this.calculateData();
                return WebUtils.wrap("cmd", "ValueOverTime.formulaAdded", "id", id, "formula", formula.getCode(), "nextId", UUID.randomUUID().toString(), "data", WebUtils.toJson(data), "xLabel", this.time == null ? "Number of Animation Steps" : this.time.getCode(), "drawMode", this.mode);
            }
            for (FormulaElement f : this.testedFormulas) {
                if (!f.id.equals(id)) continue;
                f.formula = formula;
            }
            List<Object> data = this.calculateData();
            return WebUtils.wrap("cmd", "ValueOverTime.formulaRestored", "id", id, "formula", formula.getCode(), "data", WebUtils.toJson(data), "xLabel", this.time == null ? "Number of Animation Steps" : this.time.getCode(), "drawMode", this.mode);
        }
        catch (Exception e) {
            return this.sendError(id, "Whoops!", "Could not add formula because evaluation of the formula threw an exception of type " + e.getClass().getSimpleName(), "alert-danger");
        }
    }

    private boolean correctType(String id, AbstractEvalResult res) {
        String value = ((EvalResult)res).getValue();
        if ((value.equals("TRUE") || value.equals("FALSE")) && !"time".equals(id)) {
            return true;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Map<String, String> sendError(String id, String emphasized, String msg, String level) {
        return WebUtils.wrap("cmd", "ValueOverTime.error", "id", id, "msg", msg, "strong", emphasized, "alertLevel", level);
    }

    public Object parse(Map<String, String[]> params) {
        String f = params.get("formula")[0];
        String id = params.get("id")[0];
        if ("time".equals(id) && "".equals(f)) {
            this.formulas.remove(id);
            return WebUtils.wrap("cmd", "ValueOverTime.parseOk", "id", id);
        }
        try {
            IEvalElement e = this.stateSpace.getModel().parseFormula(f);
            this.formulas.put(id, e);
            return WebUtils.wrap("cmd", "ValueOverTime.parseOk", "id", id);
        }
        catch (Exception e) {
            this.formulas.put(id, null);
            return WebUtils.wrap("cmd", "ValueOverTime.parseError", "id", id);
        }
    }

    public Object removeFormula(Map<String, String[]> params) {
        String id = params.get("id")[0];
        this.formulas.remove(id);
        if ("time".equals(id)) {
            this.time = null;
        } else {
            for (FormulaElement element : this.testedFormulas) {
                if (!element.id.equals(id)) continue;
                this.testedFormulas.remove(element);
            }
        }
        List<Object> data = this.calculateData();
        return WebUtils.wrap("cmd", "ValueOverTime.formulaRemoved", "id", id, "data", WebUtils.toJson(data), "xLabel", this.time == null ? "Number of Animation Steps" : this.time.getCode(), "drawMode", this.mode);
    }

    public void animatorStatus(boolean busy) {
        if (busy) {
            this.submit(WebUtils.wrap("cmd", "ValueOverTime.disable"));
        } else {
            this.submit(WebUtils.wrap("cmd", "ValueOverTime.enable"));
        }
    }

    private class FormulaElement {
        public final String id;
        public IEvalElement formula;

        public FormulaElement(String id, IEvalElement formula) {
            this.id = id;
            this.formula = formula;
        }
    }
}

