/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.prob.animator.domainobjects.FormulaExpand;
import de.prob.annotations.OneToOne;
import de.prob.annotations.PublicSession;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSession
@OneToOne
public class CurrentTrace
extends AbstractAnimationBasedView {
    private final Logger logger = LoggerFactory.getLogger(CurrentTrace.class);
    List<Map<String, String>> ops = new ArrayList<Map<String, String>>();
    private boolean sortDown = true;

    @Inject
    public CurrentTrace(AnimationSelector animations) {
        super(animations);
        this.incrementalUpdate = false;
        animations.registerAnimationChangeListener((IAnimationChangeListener)this);
    }

    @Override
    public void performTraceChange(Trace trace) {
        int endpos;
        this.logger.trace("Trace has changed. Submitting");
        this.ops = new ArrayList<Map<String, String>>();
        if (trace == null) {
            Map<String, String> wrap = WebUtils.wrap("cmd", "CurrentTrace.setTrace", "trace", WebUtils.toJson(this.ops));
            this.submit(wrap);
            return;
        }
        int currentPos = trace.getCurrent().getIndex();
        List opList = trace.getTransitionList();
        int startpos = currentPos > 50 ? currentPos - 50 : 0;
        int n = endpos = opList.size() > currentPos + 20 ? currentPos + 20 : opList.size();
        if (startpos == 0) {
            this.ops.add(WebUtils.wrap("id", -1, "rep", "-- root --", "group", "start"));
        }
        trace.getStateSpace().evaluateTransitions(opList.subList(startpos, endpos), FormulaExpand.truncate);
        String group = "past";
        for (int i = startpos; i < endpos; ++i) {
            String rep = ((Transition)opList.get(i)).getPrettyRep();
            if (currentPos == i) {
                group = "current";
                this.ops.add(WebUtils.wrap("id", i, "rep", rep, "group", group));
                group = "future";
                continue;
            }
            this.ops.add(WebUtils.wrap("id", i, "rep", rep, "group", group));
        }
        if (this.sortDown) {
            Collections.reverse(this.ops);
        }
        Map<String, String> wrap = WebUtils.wrap("cmd", "CurrentTrace.setTrace", "trace", WebUtils.toJson(this.ops));
        this.submit(wrap);
    }

    public Object gotoPos(Map<String, String[]> params) {
        this.logger.trace("Goto Position in Trace");
        int id = Integer.parseInt(params.get("id")[0]);
        Trace trace = this.getCurrentTrace().gotoPosition(id);
        this.animationsRegistry.traceChange(trace);
        return null;
    }

    public Object changeSort(Map<String, String[]> params) {
        this.sortDown = Boolean.valueOf(params.get("sortDown")[0]);
        Collections.reverse(this.ops);
        return WebUtils.wrap("cmd", "CurrentTrace.setTrace", "trace", WebUtils.toJson(this.ops));
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/currenttrace/index.html");
    }

    public List<Transition> getElements(Trace trace) {
        return trace.getTransitionList();
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        Map<String, String> wrap = WebUtils.wrap("cmd", "CurrentTrace.setTrace", "trace", WebUtils.toJson(this.ops));
        this.submit(wrap);
    }

    public void animatorStatus(boolean busy) {
        if (busy) {
            this.submit(WebUtils.wrap("cmd", "CurrentTrace.disable"));
        } else {
            this.submit(WebUtils.wrap("cmd", "CurrentTrace.enable"));
        }
    }
}

