/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.value.Enumerable;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import tlc2.value.ValueVec;
import util.Assert;

public class UnionValue
extends Value
implements Enumerable {
    public Value set;
    protected SetEnumValue realSet;

    public UnionValue(Value set) {
        this.set = set;
        this.realSet = null;
    }

    @Override
    public byte getKind() {
        return 20;
    }

    @Override
    public final int compareTo(Object obj) {
        this.convertAndCache();
        return this.realSet.compareTo(obj);
    }

    public final boolean equals(Object obj) {
        this.convertAndCache();
        return this.realSet.equals(obj);
    }

    @Override
    public final boolean member(Value elem) {
        Value val;
        if (!(this.set instanceof Enumerable)) {
            Assert.fail("Attempted to check if:\n " + UnionValue.ppr(elem.toString()) + "\nis an element of the non-enumerable set:\n " + UnionValue.ppr(this.toString()));
        }
        ValueEnumeration Enum2 = ((Enumerable)((Object)this.set)).elements();
        while ((val = Enum2.nextElement()) != null) {
            if (!val.member(elem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isFinite() {
        Value val;
        if (!(this.set instanceof Enumerable)) {
            Assert.fail("Attempted to check if the nonenumerable set:\n" + UnionValue.ppr(this.toString()) + "\nis a finite set.");
        }
        ValueEnumeration Enum2 = ((Enumerable)((Object)this.set)).elements();
        while ((val = Enum2.nextElement()) != null) {
            if (val.isFinite()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        if (ex.idx < ex.path.length) {
            Assert.fail("Attempted to apply EXCEPT to the set:\n" + UnionValue.ppr(this.toString()));
        }
        return ex.value;
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        if (exs.length != 0) {
            Assert.fail("Attempted to apply EXCEPT to the set:\n " + UnionValue.ppr(this.toString()) + ".");
        }
        return this;
    }

    @Override
    public final int size() {
        this.convertAndCache();
        return this.realSet.size();
    }

    @Override
    public final boolean isNormalized() {
        return this.realSet != null && this.realSet != DummyEnum && this.realSet.isNormalized();
    }

    @Override
    public final void normalize() {
        if (this.realSet != null && this.realSet != DummyEnum) {
            this.realSet.normalize();
        }
    }

    @Override
    public final boolean isDefined() {
        return this.set.isDefined();
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        return this.equals(val);
    }

    public static Value union(Value val) {
        boolean canCombine = val instanceof SetEnumValue;
        if (canCombine) {
            ValueVec elems = ((SetEnumValue)val).elems;
            for (int i = 0; i < elems.size(); ++i) {
                canCombine = canCombine && elems.elementAt(i) instanceof SetEnumValue;
            }
            if (canCombine) {
                ValueVec resElems = new ValueVec();
                SetEnumValue result = new SetEnumValue(resElems, false);
                for (int i = 0; i < elems.size(); ++i) {
                    ValueVec elems1 = ((SetEnumValue)elems.elementAt((int)i)).elems;
                    for (int j = 0; j < elems1.size(); ++j) {
                        Value elem = elems1.elementAt(j);
                        if (((Value)result).member(elem)) continue;
                        resElems.addElement(elem);
                    }
                }
                return result;
            }
        }
        return new UnionValue(val);
    }

    @Override
    public final long fingerPrint(long fp) {
        this.convertAndCache();
        return this.realSet.fingerPrint(fp);
    }

    @Override
    public final Value permute(MVPerm perm) {
        this.convertAndCache();
        return this.realSet.permute(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.realSet == null) {
            this.realSet = SetEnumValue.convert(this);
        } else if (this.realSet == DummyEnum) {
            SetEnumValue val = null;
            UnionValue unionValue = this;
            synchronized (unionValue) {
                if (this.realSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            unionValue = this;
            synchronized (unionValue) {
                if (this.realSet == DummyEnum) {
                    this.realSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        if (expand) {
            SetEnumValue val = SetEnumValue.convert(this);
            return ((Value)val).toString(sb, offset);
        }
        sb = sb.append("UNION(");
        sb = this.set.toString(sb, offset);
        sb.append(")");
        return sb;
    }

    @Override
    public final ValueEnumeration elements() {
        if (this.realSet == null || this.realSet == DummyEnum) {
            return new Enumerator();
        }
        return this.realSet.elements();
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration Enum;
        Value elemSet;
        ValueEnumeration elemSetEnum;

        public Enumerator() {
            if (!(UnionValue.this.set instanceof Enumerable)) {
                Assert.fail("Attempted to enumerate the nonenumerable set:\n" + Value.ppr(this.toString()));
            }
            this.Enum = ((Enumerable)((Object)UnionValue.this.set)).elements();
            this.elemSet = this.Enum.nextElement();
            if (this.elemSet != null) {
                if (!(this.elemSet instanceof Enumerable)) {
                    Assert.fail("Attempted to enumerate UNION(s), but some element of s is nonenumerable.");
                }
                this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
            }
        }

        @Override
        public final void reset() {
            this.Enum.reset();
            this.elemSet = this.Enum.nextElement();
            this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
        }

        @Override
        public final Value nextElement() {
            if (this.elemSet == null) {
                return null;
            }
            Value val = this.elemSetEnum.nextElement();
            if (val == null) {
                this.elemSet = this.Enum.nextElement();
                if (this.elemSet == null) {
                    return null;
                }
                if (!(this.elemSet instanceof Enumerable)) {
                    Assert.fail("Attempted to enumerate the nonenumerable set:\n" + Value.ppr(this.elemSet.toString()) + "\nwhen enumerating:\n" + Value.ppr(this.toString()));
                }
                this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
                val = this.nextElement();
            }
            return val;
        }
    }
}

