/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import tlc2.output.MP;
import tlc2.output.OutputCollector;
import tlc2.output.StatePrinter;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TraceApp;
import tlc2.tool.WorkerException;
import tlc2.util.BufferedRandomAccessFile;
import tlc2.util.LongVec;
import util.FileUtil;

public class TLCTrace {
    private static String filename;
    private BufferedRandomAccessFile raf;
    private long lastPtr;
    private TraceApp tool;
    private int previousLevel;

    public TLCTrace(String metadir, String specFile, TraceApp tool) throws IOException {
        filename = metadir + FileUtil.separator + specFile + ".st";
        this.raf = new BufferedRandomAccessFile(filename, "rw");
        this.lastPtr = 1L;
        this.tool = tool;
    }

    public final synchronized long writeState(long aFingerprint) throws IOException {
        return this.writeState(1L, aFingerprint);
    }

    public final synchronized long writeState(TLCState predecessor, long aFingerprint) throws IOException {
        return this.writeState(predecessor.uid, aFingerprint);
    }

    private final synchronized long writeState(long predecessorLoc, long fp) throws IOException {
        this.lastPtr = this.raf.getFilePointer();
        this.raf.writeLongNat(predecessorLoc);
        this.raf.writeLong(fp);
        return this.lastPtr;
    }

    public final void close() throws IOException {
        this.raf.close();
    }

    private synchronized long getPrev(long loc) throws IOException {
        this.raf.seek(loc);
        return this.raf.readLongNat();
    }

    private synchronized long getFP(long loc) throws IOException {
        this.raf.seek(loc);
        this.raf.readLongNat();
        return this.raf.readLong();
    }

    public final int getLevelForReporting() throws IOException {
        int calculatedLevel = this.getLevel(this.lastPtr);
        if (calculatedLevel > this.previousLevel) {
            this.previousLevel = calculatedLevel;
        }
        return this.previousLevel;
    }

    public final int getLevel() throws IOException {
        return this.getLevel(this.lastPtr);
    }

    public final synchronized int getLevel(long startLoc) throws IOException {
        long currentFilePointer = this.raf.getFilePointer();
        int level = 0;
        long predecessorLoc = startLoc;
        while (predecessorLoc != 1L) {
            ++level;
            predecessorLoc = this.getPrev(predecessorLoc);
        }
        this.raf.seek(currentFilePointer);
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TLCStateInfo[] getTrace() throws IOException {
        HashMap<Long, TLCStateInfo> locToState = new HashMap<Long, TLCStateInfo>();
        TLCTrace tLCTrace = this;
        synchronized (tLCTrace) {
            long curLoc = this.raf.getFilePointer();
            try {
                long length = this.raf.length();
                this.raf.seek(0L);
                this.raf.readLongNat();
                TLCStateInfo state = this.tool.getState(this.raf.readLong());
                locToState.put(0L, state);
                for (long location = 12L; location < length; location += 12L) {
                    long predecessorLocation = this.raf.readLongNat();
                    long fp = this.raf.readLong();
                    TLCStateInfo predecessor = (TLCStateInfo)locToState.get(predecessorLocation);
                    state = this.tool.getState(fp, predecessor.state);
                    state.predecessorState = predecessor;
                    state.stateNumber = location / 12L;
                    locToState.put(location, state);
                }
            }
            finally {
                this.raf.seek(curLoc);
            }
        }
        return locToState.values().toArray(new TLCStateInfo[locToState.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TLCStateInfo[] getTrace(long loc, boolean included) throws IOException {
        LongVec fps = new LongVec();
        TLCTrace tLCTrace = this;
        synchronized (tLCTrace) {
            long loc1;
            long curLoc = this.raf.getFilePointer();
            long ploc = loc1 = included ? loc : this.getPrev(loc);
            while (ploc != 1L) {
                fps.addElement(this.getFP(ploc));
                ploc = this.getPrev(ploc);
            }
            this.raf.seek(curLoc);
        }
        int stateNum = 0;
        int len = fps.size();
        TLCStateInfo[] res = new TLCStateInfo[len];
        if (len > 0) {
            long fp = fps.elementAt(len - 1);
            TLCStateInfo sinfo = this.tool.getState(fp);
            if (sinfo == null) {
                MP.printError(2123);
                MP.printError(2128, "1");
                System.exit(1);
            }
            res[stateNum++] = sinfo;
            for (int i = len - 2; i >= 0; --i) {
                fp = fps.elementAt(i);
                sinfo = this.tool.getState(fp, sinfo.state);
                if (sinfo == null) {
                    MP.printError(2123);
                    MP.printError(2128, "2");
                    System.exit(1);
                }
                res[stateNum++] = sinfo;
            }
        }
        return res;
    }

    public final synchronized void printTrace(TLCState s1, TLCState s2) throws IOException, WorkerException {
        TLCStateInfo sinfo;
        int idx;
        ArrayList<TLCStateInfo> trace = new ArrayList<TLCStateInfo>();
        MP.printError(2121);
        long loc1 = s1.uid;
        TLCState lastState = null;
        TLCStateInfo[] prefix = this.getTrace(loc1, false);
        for (idx = 0; idx < prefix.length; ++idx) {
            StatePrinter.printState(prefix[idx], lastState, idx + 1);
            lastState = prefix[idx].state;
            trace.add(prefix[idx]);
        }
        if (prefix.length == 0) {
            sinfo = this.tool.getState(s1.fingerPrint());
            if (sinfo == null) {
                MP.printError(2123);
                MP.printError(2128, "3");
                System.exit(1);
            }
        } else {
            TLCState s0 = prefix[prefix.length - 1].state;
            sinfo = this.tool.getState(s1.fingerPrint(), s0);
            if (sinfo == null) {
                MP.printError(2123);
                MP.printError(2128, "4");
                StatePrinter.printState(s1);
                System.exit(1);
            }
        }
        if (s2 == null) {
            lastState = null;
        }
        StatePrinter.printState(sinfo, lastState, ++idx);
        lastState = sinfo.state;
        trace.add(sinfo);
        if (s2 != null) {
            sinfo = this.tool.getState(s2, s1);
            if (sinfo == null) {
                MP.printError(2123);
                MP.printError(2128, "5");
                StatePrinter.printState(s2);
                System.exit(1);
            }
            StatePrinter.printState(sinfo, null, ++idx);
            trace.add(sinfo);
        }
        OutputCollector.setTrace(trace);
    }

    private final TLCStateInfo[] printPrefix(long fp) throws IOException {
        this.raf.seek(0L);
        this.raf.readLongNat();
        while (this.raf.readLong() != fp) {
            this.raf.readLongNat();
        }
        TLCState lastState = null;
        TLCStateInfo[] prefix = this.getTrace(this.lastPtr, false);
        for (int idx = 0; idx < prefix.length; ++idx) {
            StatePrinter.printState(prefix[idx], lastState, idx + 1);
            lastState = prefix[idx].state;
        }
        return prefix;
    }

    public final synchronized void beginChkpt() throws IOException {
        this.raf.flush();
        DataOutputStream dos = FileUtil.newDFOS(filename + ".tmp");
        dos.writeLong(this.raf.getFilePointer());
        dos.writeLong(this.lastPtr);
        dos.close();
    }

    public final void commitChkpt() throws IOException {
        File oldChkpt = new File(filename + ".chkpt");
        File newChkpt = new File(filename + ".tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("Trace.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    public final void recover() throws IOException {
        DataInputStream dis = FileUtil.newDFIS(filename + ".chkpt");
        long filePos = dis.readLong();
        this.lastPtr = dis.readLong();
        dis.close();
        this.raf.seek(filePos);
    }

    public static String getFilename() {
        return filename;
    }

    public static long getRecoverPtr() throws IOException {
        DataInputStream dis = FileUtil.newDFIS(filename + ".chkpt");
        long res = dis.readLong();
        dis.close();
        return res;
    }

    private long[] addBlock(long[] fp, long[] prev) throws IOException {
        for (int i = 0; i < fp.length; ++i) {
            prev[i] = this.writeState(prev[i], fp[i]);
        }
        return prev;
    }

    public final synchronized Enumerator elements() throws IOException {
        return new Enumerator();
    }

    final class Enumerator {
        long len;
        BufferedRandomAccessFile enumRaf;

        Enumerator() throws IOException {
            this.len = TLCTrace.this.raf.length();
            this.enumRaf = new BufferedRandomAccessFile(filename, "r");
        }

        final void reset(long pos) throws IOException {
            this.len = TLCTrace.this.raf.length();
            if (pos == -1L) {
                pos = this.enumRaf.getFilePointer();
            }
            this.enumRaf = new BufferedRandomAccessFile(filename, "r");
            this.enumRaf.seek(pos);
        }

        final long nextPos() {
            long fpos = this.enumRaf.getFilePointer();
            if (fpos < this.len) {
                return fpos;
            }
            return -1L;
        }

        final long nextFP() throws IOException {
            this.enumRaf.readLongNat();
            return this.enumRaf.readLong();
        }
    }
}

