/*
 * Decompiled with CFR 0.152.
 */
package de.prob.scripting;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.IDefinitions;
import de.be4.classicalb.core.parser.analysis.prolog.RecursiveMachineLoader;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.node.Start;
import de.prob.model.classicalb.ClassicalBModel;
import de.prob.scripting.ClassicalBFactory;
import de.prob.scripting.ExtractedModel;
import de.prob.scripting.ModelFactory;
import de.prob.scripting.ModelTranslationError;
import de.tla2b.exceptions.TLA2BException;
import de.tla2bAst.Translator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLAFactory
implements ModelFactory<ClassicalBModel> {
    Logger logger = LoggerFactory.getLogger(ClassicalBFactory.class);
    private final Provider<ClassicalBModel> modelCreator;

    @Inject
    public TLAFactory(Provider<ClassicalBModel> modelCreator) {
        this.modelCreator = modelCreator;
    }

    @Override
    public ExtractedModel<ClassicalBModel> extract(String fileName) throws IOException, ModelTranslationError {
        Start ast;
        Translator translator;
        ClassicalBModel classicalBModel = (ClassicalBModel)this.modelCreator.get();
        File f = new File(fileName);
        if (!f.exists()) {
            throw new FileNotFoundException("The TLA Model" + fileName + " was not found.");
        }
        try {
            translator = new Translator(f.getAbsolutePath());
            ast = translator.translate();
        }
        catch (TLA2BException e) {
            throw new ModelTranslationError("Translation Error: " + e.getMessage(), e);
        }
        BParser bparser = new BParser();
        bparser.getDefinitions().addAll((IDefinitions)translator.getBDefinitions());
        try {
            RecursiveMachineLoader rml = this.parseAllMachines(ast, f, bparser);
            classicalBModel = classicalBModel.create(ast, rml, f, bparser);
        }
        catch (BException e) {
            throw new ModelTranslationError(e.getMessage(), e);
        }
        return new ExtractedModel<ClassicalBModel>(classicalBModel, classicalBModel.getMainMachine());
    }

    public RecursiveMachineLoader parseAllMachines(Start ast, File f, BParser bparser) throws BException {
        RecursiveMachineLoader rml = new RecursiveMachineLoader(f.getParent(), bparser.getContentProvider());
        rml.loadAllMachines(f, ast, null, bparser.getDefinitions());
        this.logger.trace("Done parsing '{}'", (Object)f.getAbsolutePath());
        return rml;
    }

    public Start parseFile(File model, BParser bparser) throws IOException, BException {
        this.logger.trace("Parsing main file '{}'", (Object)model.getAbsolutePath());
        Start ast = null;
        ast = bparser.parseFile(model, false);
        return ast;
    }
}

