/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.wd.FormulaBuilder;
import org.eventb.internal.core.ast.wd.Lemma;
import org.eventb.internal.core.ast.wd.Node;

public class NodeForAll
extends Node {
    private final BoundIdentDecl[] decls;
    private Node child;

    public NodeForAll(BoundIdentDecl[] decls, Node child) {
        this.decls = decls;
        this.child = child;
    }

    @Override
    protected int maxBindingDepth() {
        return this.child.maxBindingDepth() + this.decls.length;
    }

    @Override
    protected void boundIdentifiersEqualizer(int offset) {
        assert (offset >= 0);
        this.child.boundIdentifiersEqualizer(offset - this.decls.length);
    }

    @Override
    protected Predicate internalAsPredicate(FormulaBuilder fb, boolean original) {
        if (original) {
            return fb.forall(this.decls, this.child.asPredicate(fb, original));
        }
        return this.child.asPredicate(fb, original);
    }

    @Override
    protected void collectAntecedents(Set<Predicate> antecedents, FormulaBuilder fb) {
        this.child.collectAntecedents(antecedents, fb);
    }

    @Override
    protected void internalSimplify(Set<Lemma> knownLemmas, Set<Predicate> antecedents, FormulaBuilder fb) {
        this.child.simplify(knownLemmas, antecedents, fb);
    }

    @Override
    protected void internalToString(StringBuilder sb, String indent) {
        sb.append("FORALL\n");
        this.child.toString(sb, indent + "  ");
    }
}

