/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.AssociativeHelper;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtensionHelper;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.extension.ArityCoverage;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.ast.extension.OperatorCoverage;
import org.eventb.internal.core.ast.extension.TypeCheckMediator;
import org.eventb.internal.core.ast.extension.TypeMediator;
import org.eventb.internal.core.parser.ExtendedGrammar;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.IPropertyParserInfo;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class ExtendedExpression
extends Expression
implements IExtendedFormula {
    private final Expression[] childExpressions;
    private final Predicate[] childPredicates;
    private final IExpressionExtension extension;

    public static void init(ExtendedGrammar grammar) {
        try {
            for (ExtendedExpressionParsers parserInfo : ExtendedExpressionParsers.values()) {
                grammar.addParser(parserInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected ExtendedExpression(int tag, Expression[] expressions, Predicate[] predicates, SourceLocation location, FormulaFactory ff, IExpressionExtension extension, Type type) {
        super(tag, ff, location, ExtendedExpression.combineHashCodes(expressions, predicates));
        this.childExpressions = expressions;
        this.childPredicates = predicates;
        this.extension = extension;
        this.checkPreconditions();
        this.ensureSameFactory(this.childExpressions);
        this.ensureSameFactory(this.childPredicates);
        this.ensureSameFactory(type);
        this.setPredicateVariableCache(this.getChildren());
        this.synthesizeType(type);
        FormulaChecks.ensureHasType(this, type);
    }

    private void checkPreconditions() {
        IExtensionKind kind = this.extension.getKind();
        assert (kind.getProperties().getFormulaType() == IOperatorProperties.FormulaType.EXPRESSION);
        if (!kind.checkPreconditions(this.childExpressions, this.childPredicates)) {
            throw new IllegalArgumentException("Incorrect kind of children");
        }
    }

    private Formula<?>[] getChildren() {
        return ExtensionHelper.concat(this.childExpressions, this.childPredicates);
    }

    private boolean isFirstChildTypechecked() {
        if (this.childExpressions.length > 0) {
            return this.childExpressions[0].isTypeChecked();
        }
        if (this.childPredicates.length > 0) {
            return this.childPredicates[0].isTypeChecked();
        }
        return true;
    }

    @Override
    protected void synthesizeType(Type givenType) {
        IdentListMerger freeIdentMerger = ExtendedExpression.mergeFreeIdentifiers((Formula[])this.getChildren());
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = ExtendedExpression.mergeBoundIdentifiers((Formula[])this.getChildren());
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        if (!this.isFirstChildTypechecked()) {
            return;
        }
        Type resultType = givenType == null ? this.extension.synthesizeType(this.childExpressions, this.childPredicates, new TypeMediator(this.getFactory())) : (!this.isValidType(givenType) ? null : givenType);
        if (resultType == null) {
            return;
        }
        if (!this.mergeGivenTypes(resultType)) {
            return;
        }
        this.setFinalType(resultType, givenType);
    }

    public boolean isValidType(Type proposedType) {
        return this.extension.verifyType(proposedType, this.childExpressions, this.childPredicates);
    }

    @Override
    public Expression[] getChildExpressions() {
        return (Expression[])this.childExpressions.clone();
    }

    @Override
    public Predicate[] getChildPredicates() {
        return (Predicate[])this.childPredicates.clone();
    }

    @Override
    public IExpressionExtension getExtension() {
        return this.extension;
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        ExtendedExpression other = (ExtendedExpression)expr;
        return Arrays.equals(this.childExpressions, other.childExpressions) && Arrays.equals(this.childPredicates, other.childPredicates);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        for (Formula<?> child : this.getChildren()) {
            child.typeCheck(result, quantifiedIdentifiers);
        }
        TypeCheckMediator mediator = new TypeCheckMediator(result, this, this.isAtomic());
        Type resultType = this.extension.typeCheck(this, mediator);
        this.setTemporaryType(resultType, result);
        result.analyzeExpression(this);
    }

    public boolean isAtomic() {
        return this.childExpressions.length == 0 && this.childPredicates.length == 0;
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        ExtensionHelper.solveTypes(unifier, this.childExpressions, this.childPredicates);
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        ExtensionHelper.isLegible((Formula[])this.childExpressions, (Formula[])this.childPredicates, (LegibilityResult)result);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        IParserPrinter<Formula<?>> parser;
        IParserPrinter<Formula<?>> extParser = parser = ExtensionHelper.makeParserPrinter(this, this.extension, mediator);
        extParser.toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.extension.getSyntaxSymbol());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return AssociativeHelper.getSyntaxTreeHelper(boundNames, tabs, this.getChildren(), this.extension.getSyntaxSymbol(), this.getTypeName(), this.getClass().getSimpleName());
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        ExtensionHelper.collectFreeIdentifiers(freeIdentSet, this.childExpressions, this.childPredicates);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        ExtensionHelper.collectNamesAbove(names, boundNames, offset, this.childExpressions, this.childPredicates);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        int i;
        boolean goOn = visitor.enterExtendedExpression(this);
        for (i = 0; goOn && i < this.childExpressions.length; ++i) {
            if (i != 0) {
                goOn = visitor.continueExtendedExpression(this);
            }
            if (!goOn) continue;
            goOn = this.childExpressions[i].accept(visitor);
        }
        for (i = 0; goOn && i < this.childPredicates.length; ++i) {
            goOn = visitor.continueExtendedExpression(this);
            if (!goOn) continue;
            goOn = this.childPredicates[i].accept(visitor);
        }
        return visitor.exitExtendedExpression(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitExtendedExpression(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        Predicate[] newChildPreds;
        Expression[] newChildExprs;
        boolean flatten = rewriter.autoFlatteningMode() && this.extension.getKind().getProperties().isAssociative();
        ArrayList<Expression> newChildExpressions = new ArrayList<Expression>(this.childExpressions.length + 11);
        boolean changed = false;
        for (Expression child : this.childExpressions) {
            Expression newChild = (Expression)child.rewrite(rewriter);
            if (flatten && this.getTag() == newChild.getTag()) {
                Expression[] grandChildren = ((ExtendedExpression)newChild).childExpressions;
                newChildExpressions.addAll(Arrays.asList(grandChildren));
                changed = true;
                continue;
            }
            newChildExpressions.add(newChild);
            changed |= newChild != child;
        }
        ArrayList<Predicate> newChildPredicates = new ArrayList<Predicate>(this.childPredicates.length);
        for (Predicate child : this.childPredicates) {
            Predicate newChild = (Predicate)child.rewrite(rewriter);
            newChildPredicates.add(newChild);
            changed |= newChild != child;
        }
        if (!changed) {
            newChildExprs = this.childExpressions;
            newChildPreds = this.childPredicates;
        } else {
            newChildExprs = newChildExpressions.toArray(new Expression[newChildExpressions.size()]);
            newChildPreds = newChildPredicates.toArray(new Predicate[newChildPredicates.size()]);
        }
        return rewriter.rewrite(this, changed, newChildExprs, newChildPreds);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        ExtensionHelper.inspectChildren(acc, this.childExpressions, this.childPredicates);
    }

    @Override
    public Formula<?> getChild(int index) {
        this.checkChildIndex(index);
        return ExtensionHelper.getChild(this.childExpressions, this.childPredicates, index);
    }

    @Override
    public int getChildCount() {
        return ExtensionHelper.getChildCount(this.childExpressions, this.childPredicates);
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        return ExtensionHelper.getDescendantPos((Formula[])this.childExpressions, (Formula[])this.childPredicates, (SourceLocation)sloc, (IntStack)indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        FormulaFactory factory = this.getFactory();
        if (index < 0 || this.childExpressions.length + this.childPredicates.length <= index) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        if (index < this.childExpressions.length) {
            Expression[] newChildExpressions = (Expression[])this.childExpressions.clone();
            newChildExpressions[index] = rewriter.rewrite(this.childExpressions[index]);
            return factory.makeExtendedExpression(this.extension, newChildExpressions, (Predicate[])this.childPredicates.clone(), this.getSourceLocation(), this.getType());
        }
        Predicate[] newChildPredicates = (Predicate[])this.childPredicates.clone();
        newChildPredicates[index -= this.childExpressions.length] = rewriter.rewrite(this.childPredicates[index]);
        return factory.makeExtendedExpression(this.extension, (Expression[])this.childExpressions.clone(), newChildPredicates, this.getSourceLocation(), this.getType());
    }

    @Override
    public boolean isATypeExpression() {
        if (!this.extension.isATypeConstructor()) {
            return false;
        }
        if (this.childPredicates.length != 0) {
            return false;
        }
        for (Expression child : this.childExpressions) {
            if (child.isATypeExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type toType() {
        if (!this.isATypeExpression()) {
            return super.toType();
        }
        ArrayList<Type> typeParams = new ArrayList<Type>();
        for (Expression child : this.childExpressions) {
            typeParams.add(child.toType());
        }
        return this.getFactory().makeParametricType(this.extension, typeParams);
    }

    @Override
    public boolean isWDStrict() {
        return this.extension.conjoinChildrenWD();
    }

    private static enum ExtendedExpressionParsers implements IPropertyParserInfo<ExtendedExpression>
    {
        EXTENDED_ATOMIC_EXPRESSION(IOperatorProperties.Notation.PREFIX, IOperatorProperties.FormulaType.EXPRESSION, ArityCoverage.NONE, ArityCoverage.NONE, ArityCoverage.NONE, false){

            @Override
            public IParserPrinter<ExtendedExpression> makeParser(int kind, int tag) {
                return new SubParsers.ExtendedAtomicExpressionParser(kind, tag);
            }
        }
        ,
        EXTENDED_BINARY_EXPRESSION(IOperatorProperties.Notation.INFIX, IOperatorProperties.FormulaType.EXPRESSION, ArityCoverage.TWO, ArityCoverage.NONE, ArityCoverage.TWO, false){

            @Override
            public IParserPrinter<ExtendedExpression> makeParser(int kind, int tag) {
                return new SubParsers.ExtendedBinaryExpressionInfix(kind, tag);
            }
        }
        ,
        EXTENDED_ASSOCIATIVE_EXPRESSION(IOperatorProperties.Notation.INFIX, IOperatorProperties.FormulaType.EXPRESSION, ArityCoverage.TWO_OR_MORE, ArityCoverage.NONE, ArityCoverage.TWO_OR_MORE, true){

            @Override
            public IParserPrinter<ExtendedExpression> makeParser(int kind, int tag) {
                return new SubParsers.ExtendedAssociativeExpressionInfix(kind, tag);
            }
        }
        ,
        PARENTHESIZED_EXPRESSION(IOperatorProperties.Notation.PREFIX, IOperatorProperties.FormulaType.EXPRESSION, ArityCoverage.ANY, ArityCoverage.ANY, ArityCoverage.ONE_OR_MORE, false){

            @Override
            public IParserPrinter<ExtendedExpression> makeParser(int kind, int tag) {
                return new SubParsers.ExtendedExprParen(kind, tag);
            }
        };

        private final OperatorCoverage operCover;

        private ExtendedExpressionParsers(IOperatorProperties.Notation notation, IOperatorProperties.FormulaType formulaType, ArityCoverage exprArity, ArityCoverage predArity, ArityCoverage globalArity, boolean isAssociative) {
            this.operCover = new OperatorCoverage(notation, formulaType, exprArity, predArity, globalArity, isAssociative);
        }

        @Override
        public OperatorCoverage getOperatorCoverage() {
            return this.operCover;
        }

        protected abstract IParserPrinter<ExtendedExpression> makeParser(int var1, int var2);

        @Override
        public IOperatorInfo<ExtendedExpression> makeOpInfo(final String image, final int tag, final String opId, final String groupId) {
            return new IOperatorInfo<ExtendedExpression>(){

                @Override
                public IParserPrinter<ExtendedExpression> makeParser(int kind) {
                    return ExtendedExpressionParsers.this.makeParser(kind, tag);
                }

                @Override
                public boolean isSpaced() {
                    return ExtendedExpressionParsers.this.getOperatorCoverage().getNotation() == IOperatorProperties.Notation.INFIX;
                }

                @Override
                public String getImage() {
                    return image;
                }

                @Override
                public String getId() {
                    return opId;
                }

                @Override
                public String getGroupId() {
                    return groupId;
                }
            };
        }
    }
}

