/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.AssociativeHelper;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class AssociativePredicate
extends Predicate {
    private final Predicate[] children;
    private static int FIRST_TAG = 351;
    public static final String LOR_ID = "lor";
    public static final String LAND_ID = "land";
    public static final int TAGS_LENGTH = Operators.values().length;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected AssociativePredicate(Predicate[] children, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, AssociativePredicate.combineHashCodes(children));
        this.children = children;
        FormulaChecks.ensureTagInRange(tag, FIRST_TAG, TAGS_LENGTH);
        FormulaChecks.ensureMinLength(children, 2);
        this.ensureSameFactory(this.children);
        this.setPredicateVariableCache(this.children);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        IdentListMerger freeIdentMerger = AssociativePredicate.mergeFreeIdentifiers((Formula[])this.children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = AssociativePredicate.mergeBoundIdentifiers((Formula[])this.children);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        for (Predicate child : this.children) {
            if (child.isTypeChecked()) continue;
            return;
        }
        this.typeChecked = true;
    }

    public Predicate[] getChildren() {
        return (Predicate[])this.children.clone();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - FIRST_TAG];
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        AssociativePredicate other = (AssociativePredicate)formula;
        return Arrays.equals(this.children, other.children);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        for (Predicate child : this.children) {
            child.typeCheck(result, quantifiedIdentifiers);
        }
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (Predicate child : this.children) {
            child.solveType(unifier);
        }
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return AssociativeHelper.getSyntaxTreeHelper(boundNames, tabs, this.children, this.getOperatorImage(), "", this.getClass().getSimpleName());
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        AssociativeHelper.isLegibleList((Formula[])this.children, (LegibilityResult)result);
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        for (Predicate child : this.children) {
            child.collectFreeIdentifiers(freeIdentSet);
        }
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        for (Predicate child : this.children) {
            child.collectNamesAbove(names, boundNames, offset);
        }
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 351: {
                goOn = visitor.enterLAND(this);
                break;
            }
            case 352: {
                goOn = visitor.enterLOR(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        for (int i = 0; goOn && i < this.children.length; ++i) {
            if (i != 0) {
                switch (this.getTag()) {
                    case 351: {
                        goOn = visitor.continueLAND(this);
                        break;
                    }
                    case 352: {
                        goOn = visitor.continueLOR(this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (!goOn) continue;
            goOn = this.children[i].accept(visitor);
        }
        switch (this.getTag()) {
            case 351: {
                return visitor.exitLAND(this);
            }
            case 352: {
                return visitor.exitLOR(this);
            }
        }
        assert (false);
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitAssociativePredicate(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        boolean flatten = rewriter.autoFlatteningMode();
        ArrayList<Predicate> newChildren = new ArrayList<Predicate>(this.children.length + 11);
        boolean changed = false;
        for (Predicate child : this.children) {
            Predicate newChild = (Predicate)child.rewrite(rewriter);
            if (flatten && this.getTag() == newChild.getTag()) {
                Predicate[] grandChildren = ((AssociativePredicate)newChild).children;
                newChildren.addAll(Arrays.asList(grandChildren));
                changed = true;
                continue;
            }
            newChildren.add(newChild);
            changed |= newChild != child;
        }
        AssociativePredicate before = !changed ? this : rewriter.getFactory().makeAssociativePredicate(this.getTag(), newChildren, this.getSourceLocation());
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        for (Predicate child : this.children) {
            child.inspect(acc);
            if (acc.allSkipped()) break;
            acc.nextChild();
        }
        acc.leaveChildren();
    }

    public Predicate getChild(int index) {
        this.checkChildIndex(index);
        return this.children[index];
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        for (Predicate child : this.children) {
            IPosition pos = child.getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        if (index < 0 || this.children.length <= index) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        Predicate[] newChildren = (Predicate[])this.children.clone();
        newChildren[index] = rewriter.rewrite(this.children[index]);
        return this.getFactory().makeAssociativePredicate(this.getTag(), newChildren, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return false;
    }

    private static enum Operators implements IOperatorInfo<AssociativePredicate>
    {
        OP_LAND("\u2227", "land", StandardGroup.LOGIC_PRED, 351),
        OP_LOR("\u2228", "lor", StandardGroup.LOGIC_PRED, 352);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<AssociativePredicate> makeParser(int kind) {
            return new SubParsers.AssociativePredicateInfix(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

