/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import org.eventb.core.ast.extension.CycleError;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.parser.operators.AllInOnceMap;
import org.eventb.internal.core.parser.operators.Closure;
import org.eventb.internal.core.parser.operators.OperatorGroup;

public class OperatorRegistry {
    private final OperatorGroup group0 = new OperatorGroup(StandardGroup.GROUP_0.getId());
    private final AllInOnceMap<String, OperatorGroup> idOpGroup = new AllInOnceMap();
    private final AllInOnceMap<Integer, OperatorGroup> kindOpGroup = new AllInOnceMap();
    private final AllInOnceMap<String, Integer> idKind = new AllInOnceMap();
    private final Closure<OperatorGroup> groupPriority = new Closure();

    public OperatorRegistry() {
        this.idOpGroup.put(StandardGroup.GROUP_0.getId(), this.group0);
    }

    public OperatorGroup getGroup0() {
        return this.group0;
    }

    public AllInOnceMap<String, OperatorGroup> getIdOpGroup() {
        return this.idOpGroup;
    }

    public AllInOnceMap<Integer, OperatorGroup> getKindOpGroup() {
        return this.kindOpGroup;
    }

    public AllInOnceMap<String, Integer> getIdKind() {
        return this.idKind;
    }

    public Closure<OperatorGroup> getGroupPriority() {
        return this.groupPriority;
    }

    public void addOperator(Integer kind, String operatorId, String groupId, boolean isSpaced) {
        this.idKind.put(operatorId, kind);
        OperatorGroup operatorGroup = this.idOpGroup.getNoCheck(groupId);
        if (operatorGroup == null) {
            operatorGroup = new OperatorGroup(groupId);
            this.idOpGroup.put(groupId, operatorGroup);
        }
        operatorGroup.add(kind);
        this.kindOpGroup.put(kind, operatorGroup);
        if (isSpaced) {
            operatorGroup.setSpaced(kind);
        }
    }

    public void addCompatibility(String leftOpId, String rightOpId) {
        Integer leftKind = this.idKind.get(leftOpId);
        Integer rightKind = this.idKind.get(rightOpId);
        OperatorGroup group = this.getAndCheckSameGroup(leftKind, rightKind);
        group.addCompatibility(leftKind, rightKind);
    }

    public void addAssociativity(String opId) {
        Integer opKind = this.idKind.get(opId);
        OperatorGroup group = this.kindOpGroup.get(opKind);
        group.addAssociativity(opKind);
    }

    public void addPriority(String lowOpId, String highOpId) throws CycleError {
        Integer leftKind = this.idKind.get(lowOpId);
        Integer rightKind = this.idKind.get(highOpId);
        OperatorGroup group = this.getAndCheckSameGroup(leftKind, rightKind);
        group.addPriority(leftKind, rightKind);
    }

    private OperatorGroup getAndCheckSameGroup(Integer leftKind, Integer rightKind) {
        OperatorGroup rightGroup;
        OperatorGroup leftGroup = this.kindOpGroup.get(leftKind);
        if (leftGroup != (rightGroup = this.kindOpGroup.get(rightKind))) {
            throw new IllegalArgumentException("Operators " + leftKind + " and " + rightKind + " do not belong to the same group");
        }
        return leftGroup;
    }

    public void addGroupPriority(String lowGroupId, String highGroupId) throws CycleError {
        OperatorGroup lowGroup = this.idOpGroup.get(lowGroupId);
        OperatorGroup highGroup = this.idOpGroup.get(highGroupId);
        this.groupPriority.add(lowGroup, highGroup);
    }

    public boolean hasGroup(int kind) {
        return this.kindOpGroup.containsKey(kind);
    }
}

