/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BecomesMemberOf;
import org.eventb.core.ast.BecomesSuchThat;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISimpleVisitor2;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.internal.core.ast.wd.FormulaBuilder;
import org.eventb.internal.core.ast.wd.Node;
import org.eventb.internal.core.ast.wd.NodeForAll;
import org.eventb.internal.core.ast.wd.NodeLand;
import org.eventb.internal.core.ast.wd.NodeLimp;
import org.eventb.internal.core.ast.wd.NodePred;

public class WDImprover
implements ISimpleVisitor2 {
    private final FormulaBuilder fb;
    private Node node;

    public WDImprover(FormulaFactory formulaFactory) {
        this.fb = new FormulaBuilder(formulaFactory);
    }

    public Predicate improve(Predicate formula) {
        Node root = this.nodeFor(formula);
        return root.simplifyTree(this.fb);
    }

    private Node nodeFor(Predicate pred) {
        pred.accept(this);
        return this.node;
    }

    private Node[] nodesFor(Predicate[] preds) {
        int length = preds.length;
        Node[] result = new Node[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.nodeFor(preds[i]);
        }
        return result;
    }

    @Override
    public void visitAssociativeExpression(AssociativeExpression expression) {
        assert (false);
    }

    @Override
    public void visitAssociativePredicate(AssociativePredicate predicate) {
        this.node = predicate.getTag() == 351 ? new NodeLand(this.nodesFor(predicate.getChildren())) : new NodePred(predicate);
    }

    @Override
    public void visitAtomicExpression(AtomicExpression expression) {
        assert (false);
    }

    @Override
    public void visitBecomesEqualTo(BecomesEqualTo assignment) {
        assert (false);
    }

    @Override
    public void visitBecomesMemberOf(BecomesMemberOf assignment) {
        assert (false);
    }

    @Override
    public void visitBecomesSuchThat(BecomesSuchThat assignment) {
        assert (false);
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        assert (false);
    }

    @Override
    public void visitBinaryPredicate(BinaryPredicate predicate) {
        if (predicate.getTag() == 251) {
            Node left = this.nodeFor(predicate.getLeft());
            Node right = this.nodeFor(predicate.getRight());
            this.node = new NodeLimp(left, right);
        } else {
            this.node = new NodePred(predicate);
        }
    }

    @Override
    public void visitBoolExpression(BoolExpression expression) {
        assert (false);
    }

    @Override
    public void visitBoundIdentDecl(BoundIdentDecl boundIdentDecl) {
        assert (false);
    }

    @Override
    public void visitBoundIdentifier(BoundIdentifier identifierExpression) {
        assert (false);
    }

    @Override
    public void visitFreeIdentifier(FreeIdentifier identifierExpression) {
        assert (false);
    }

    @Override
    public void visitIntegerLiteral(IntegerLiteral expression) {
        assert (false);
    }

    @Override
    public void visitLiteralPredicate(LiteralPredicate predicate) {
        this.node = new NodePred(predicate);
    }

    @Override
    public void visitMultiplePredicate(MultiplePredicate predicate) {
        this.node = new NodePred(predicate);
    }

    @Override
    public void visitPredicateVariable(PredicateVariable predVar) {
        assert (false);
    }

    @Override
    public void visitQuantifiedExpression(QuantifiedExpression expression) {
        assert (false);
    }

    @Override
    public void visitQuantifiedPredicate(QuantifiedPredicate predicate) {
        if (predicate.getTag() == 851) {
            BoundIdentDecl[] decls = predicate.getBoundIdentDecls();
            Predicate child = predicate.getPredicate();
            this.node = new NodeForAll(decls, this.nodeFor(child));
        } else {
            this.node = new NodePred(predicate);
        }
    }

    @Override
    public void visitRelationalPredicate(RelationalPredicate predicate) {
        this.node = new NodePred(predicate);
    }

    @Override
    public void visitSetExtension(SetExtension expression) {
        assert (false);
    }

    @Override
    public void visitSimplePredicate(SimplePredicate predicate) {
        this.node = new NodePred(predicate);
    }

    @Override
    public void visitUnaryExpression(UnaryExpression expression) {
        assert (false);
    }

    @Override
    public void visitUnaryPredicate(UnaryPredicate predicate) {
        this.node = new NodePred(predicate);
    }

    @Override
    public void visitExtendedPredicate(ExtendedPredicate predicate) {
        this.node = new NodePred(predicate);
    }

    @Override
    public void visitExtendedExpression(ExtendedExpression expression) {
        assert (false);
    }
}

