/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import java.util.Set;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.wd.FormulaBuilder;
import org.eventb.internal.core.ast.wd.Lemma;
import org.eventb.internal.core.ast.wd.Node;

public class NodePred
extends Node {
    private final Predicate predicate;
    private Predicate normalized;

    public NodePred(Predicate pred) {
        this.predicate = pred;
    }

    @Override
    protected int maxBindingDepth() {
        return 0;
    }

    @Override
    protected void boundIdentifiersEqualizer(int offset) {
        this.normalized = (Predicate)this.predicate.shiftBoundIdentifiers(offset);
    }

    @Override
    protected Predicate internalAsPredicate(FormulaBuilder fb, boolean original) {
        return original ? this.predicate : this.normalized;
    }

    @Override
    protected void collectAntecedents(Set<Predicate> antecedents, FormulaBuilder fb) {
        this.addPredicateToSet(antecedents, fb);
    }

    @Override
    protected void internalSimplify(Set<Lemma> knownLemmas, Set<Predicate> antecedents, FormulaBuilder fb) {
        if (antecedents.contains(this.normalized)) {
            this.setNodeSubsumed();
            return;
        }
        Lemma lemma = new Lemma(antecedents, this.normalized, this);
        lemma.addToSet(knownLemmas);
    }

    @Override
    protected void internalToString(StringBuilder sb, String indent) {
        sb.append(this.normalized);
        sb.append('\n');
    }
}

