/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorArgument;
import org.eventb.core.ast.datatype.ISetInstantiation;
import org.eventb.core.ast.datatype.ITypeInstantiation;
import org.eventb.internal.core.ast.datatype.ConstructorExtension;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DestructorExtension;
import org.eventb.internal.core.ast.datatype.SetSubstitution;
import org.eventb.internal.core.ast.datatype.TypeSubstitution;

public class ConstructorArgument
implements IConstructorArgument {
    protected final ConstructorExtension constructor;
    protected final Type formalType;

    public ConstructorArgument(ConstructorExtension constructor, Type formalType) {
        this.constructor = constructor;
        this.formalType = formalType;
    }

    @Override
    public Datatype getOrigin() {
        return this.constructor.getOrigin();
    }

    @Override
    public ConstructorExtension getConstructor() {
        return this.constructor;
    }

    public Type getFormalType() {
        return this.formalType;
    }

    @Override
    public boolean isDestructor() {
        return false;
    }

    @Override
    public DestructorExtension asDestructor() {
        if (this.isDestructor()) {
            return (DestructorExtension)this;
        }
        return null;
    }

    public int hashCode() {
        return this.formalType.hashCode();
    }

    public boolean isSimilarTo(ConstructorArgument other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.formalType.equals(other.formalType);
    }

    @Override
    public Type getType(ITypeInstantiation instantiation) {
        if (this.getOrigin() != instantiation.getOrigin()) {
            throw new IllegalArgumentException("Instantiation built for " + instantiation.getOrigin() + " but used with " + this.getOrigin());
        }
        return ((TypeSubstitution)instantiation).rewrite(this.formalType);
    }

    @Override
    public Expression getSet(ISetInstantiation instantiation) {
        if (this.getOrigin() != instantiation.getOrigin()) {
            throw new IllegalArgumentException("Instantiation built for " + instantiation.getOrigin() + " but used with " + this.getOrigin());
        }
        return ((SetSubstitution)instantiation).substitute(this.formalType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.formalType);
    }
}

