/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.internal.core.ast.Substitute;
import org.eventb.internal.core.ast.Substitution;

public class BoundIdentDeclRemover
extends Substitution {
    protected final List<BoundIdentDecl> newDecls;
    protected final Substitute[] substitutes;

    public BoundIdentDeclRemover(BoundIdentDecl[] decls, boolean[] keep, FormulaFactory ff) {
        super(ff);
        assert (decls.length == keep.length);
        int lastIndex = decls.length - 1;
        this.substitutes = new Substitute[keep.length];
        this.newDecls = new ArrayList<BoundIdentDecl>(decls.length);
        int newIndex = 0;
        for (int i = 0; i <= lastIndex; ++i) {
            if (!keep[lastIndex - i]) continue;
            this.substitutes[i] = Substitute.makeSubstitute(newIndex++);
            this.newDecls.add(decls[lastIndex - i]);
        }
        assert (newIndex == this.newDecls.size());
        Collections.reverse(this.newDecls);
    }

    @Override
    public Expression rewrite(BoundIdentifier ident) {
        assert (this.ff == ident.getFactory());
        int nbOfInternallyBound = this.getBindingDepth();
        int index = ident.getBoundIndex();
        if (index < nbOfInternallyBound) {
            return super.rewrite(ident);
        }
        int rootIndex = index - nbOfInternallyBound;
        if (rootIndex < this.substitutes.length) {
            assert (this.substitutes[rootIndex] != null) : "Should not substitute a removed identifier";
            return this.substitutes[rootIndex].getSubstitute(ident, nbOfInternallyBound);
        }
        int newIndex = index - this.substitutes.length + this.newDecls.size();
        if (newIndex == index) {
            return super.rewrite(ident);
        }
        return this.ff.makeBoundIdentifier(newIndex, ident.getSourceLocation(), ident.getType());
    }

    public List<BoundIdentDecl> getNewDeclarations() {
        return this.newDecls;
    }
}

