/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Arrays;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IFormulaRewriter;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.typecheck.TypeUnifier;

public abstract class Assignment
extends Formula<Assignment> {
    protected final FreeIdentifier[] assignedIdents;

    protected Assignment(int tag, FormulaFactory ff, SourceLocation location, int hashCode, FreeIdentifier[] assignedIdents) {
        super(tag, ff, location, Assignment.combineHashCodes(Assignment.combineHashCodes(assignedIdents), hashCode));
        FormulaChecks.ensureMinLength(assignedIdents, 1);
        this.assignedIdents = assignedIdents;
        this.ensureSameFactory(this.assignedIdents);
    }

    protected final void appendAssignedIdents(StringBuilder result) {
        boolean comma = false;
        for (FreeIdentifier ident : this.assignedIdents) {
            if (comma) {
                result.append(',');
            }
            comma = true;
            result.append(ident.getName());
        }
    }

    @Override
    protected final void solveType(TypeUnifier unifier) {
        if (this.isTypeChecked()) {
            return;
        }
        this.solveChildrenTypes(unifier);
        for (FreeIdentifier ident : this.assignedIdents) {
            ident.solveType(unifier);
        }
        this.synthesizeType();
    }

    protected abstract void solveChildrenTypes(TypeUnifier var1);

    public final FreeIdentifier[] getAssignedIdentifiers() {
        return (FreeIdentifier[])this.assignedIdents.clone();
    }

    protected final String getSyntaxTreeLHS(String[] boundNames, String tabs) {
        StringBuilder builder = new StringBuilder();
        for (FreeIdentifier ident : this.assignedIdents) {
            builder.append(ident.getSyntaxTree(boundNames, tabs));
        }
        return builder.toString();
    }

    @Override
    protected final Assignment getTypedThis() {
        return this;
    }

    protected final boolean hasSameAssignedIdentifiers(Assignment other) {
        return Arrays.equals(this.assignedIdents, other.assignedIdents);
    }

    @Override
    public final Assignment rewrite(IFormulaRewriter rewriter) {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }

    @Override
    protected final Assignment rewrite(ITypeCheckingRewriter rewriter) {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }

    public final Predicate getFISPredicate() {
        assert (this.isTypeChecked());
        return (Predicate)this.getFISPredicateRaw().flatten();
    }

    protected abstract Predicate getFISPredicateRaw();

    public final Predicate getBAPredicate() {
        assert (this.isTypeChecked());
        return (Predicate)this.getBAPredicateRaw().flatten();
    }

    protected abstract Predicate getBAPredicateRaw();

    public abstract FreeIdentifier[] getUsedIdentifiers();

    protected abstract void synthesizeType();

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }

    @Override
    public final Formula<?> getChild(int index) {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }

    @Override
    public final int getChildCount() {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }

    @Override
    protected final IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }

    @Override
    protected final Assignment rewriteChild(int index, SingleRewriter rewriter) {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }

    @Override
    protected final Assignment getCheckedReplacement(SingleRewriter rewriter) {
        throw new UnsupportedOperationException("Assignments cannot be rewritten");
    }
}

