/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_ds.PersistentSet;
import com.github.krukow.clj_ds.TransientSet;
import com.github.krukow.clj_lang.APersistentSet;
import com.github.krukow.clj_lang.ATransientSet;
import com.github.krukow.clj_lang.IEditableCollection;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IPersistentSet;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.ITransientMap;
import com.github.krukow.clj_lang.PersistentHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentHashSet<T>
extends APersistentSet<T>
implements IObj,
IEditableCollection<T>,
PersistentSet<T> {
    public static final PersistentHashSet EMPTY = new PersistentHashSet(null, PersistentHashMap.EMPTY);
    final IPersistentMap _meta;

    public static final <T> PersistentHashSet<T> emptySet() {
        return EMPTY;
    }

    public static <T> PersistentHashSet<T> create(T ... init) {
        IPersistentCollection<T> ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            ret = ret.cons((Object)init[i]);
        }
        return ret;
    }

    public static <T> PersistentHashSet<T> create(Iterable<? extends T> init) {
        IPersistentCollection<T> ret = EMPTY;
        for (T key : init) {
            ret = ret.cons((Object)key);
        }
        return ret;
    }

    public static <T> PersistentHashSet<T> create(ISeq<? extends T> items) {
        IPersistentCollection<T> ret = EMPTY;
        while (items != null) {
            ret = ret.cons((Object)items.first());
            items = items.next();
        }
        return ret;
    }

    public static <T> PersistentHashSet<T> createWithCheck(T ... init) {
        IPersistentCollection<T> ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            if (((APersistentSet)(ret = ((PersistentHashSet)ret).cons((Object)init[i]))).count() == i + 1) continue;
            throw new IllegalArgumentException("Duplicate key: " + init[i]);
        }
        return ret;
    }

    public static <T> PersistentHashSet<T> createWithCheck(List<? extends T> init) {
        IPersistentCollection<T> ret = EMPTY;
        int i = 0;
        for (T key : init) {
            if (((APersistentSet)(ret = ((PersistentHashSet)ret).cons((Object)key))).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + key);
            }
            ++i;
        }
        return ret;
    }

    public static <T> PersistentHashSet<T> createWithCheck(ISeq<? extends T> items) {
        IPersistentCollection<T> ret = EMPTY;
        int i = 0;
        while (items != null) {
            if (((APersistentSet)(ret = ((PersistentHashSet)ret).cons((Object)items.first()))).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + items.first());
            }
            items = items.next();
            ++i;
        }
        return ret;
    }

    PersistentHashSet(IPersistentMap meta, IPersistentMap impl) {
        super(impl);
        this._meta = meta;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<Map.Entry> iterator;
            {
                this.iterator = PersistentHashSet.this.impl.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                Map.Entry n = this.iterator.next();
                return n.getKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public PersistentHashSet<T> disjoin(T key) {
        if (this.contains((Object)key)) {
            return new PersistentHashSet<T>(this.meta(), this.impl.without(key));
        }
        return this;
    }

    @Override
    public PersistentHashSet<T> cons(T o) {
        if (this.contains((Object)o)) {
            return this;
        }
        return new PersistentHashSet<T>(this.meta(), this.impl.assoc(o, o));
    }

    @Override
    public IPersistentSet<T> empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentHashSet<T> withMeta(IPersistentMap meta) {
        return new PersistentHashSet<T>(meta, this.impl);
    }

    @Override
    public TransientHashSet<T> asTransient() {
        return new TransientHashSet(((PersistentHashMap)this.impl).asTransient());
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public PersistentSet<T> zero() {
        return (PersistentSet)((Object)this.empty());
    }

    @Override
    public PersistentSet<T> plus(T val) {
        return this.cons((Object)val);
    }

    @Override
    public PersistentSet<T> minus(T val) {
        return this.disjoin((Object)val);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TransientHashSet<T>
    extends ATransientSet<T>
    implements TransientSet<T> {
        TransientHashSet(ITransientMap impl) {
            super(impl);
        }

        @Override
        public PersistentHashSet<T> persistent() {
            return new PersistentHashSet(null, this.impl.persistentMap());
        }

        @Override
        public PersistentSet<T> persist() {
            return this.persistent();
        }

        @Override
        public TransientSet<T> plus(T val) {
            return (TransientSet)((Object)this.conj((Object)val));
        }

        @Override
        public TransientSet<T> minus(T val) {
            return (TransientSet)((Object)this.disjoin(val));
        }
    }
}

