/*
 * Decompiled with CFR 0.152.
 */
package de.prob.statespace;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.FormulaExpand;
import de.prob.model.classicalb.ClassicalBMachine;
import de.prob.model.classicalb.Operation;
import de.prob.model.eventb.Event;
import de.prob.model.eventb.EventBMachine;
import de.prob.model.eventb.EventParameter;
import de.prob.model.representation.AbstractElement;
import de.prob.parser.BindingGenerator;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.IntegerPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.FormalismType;
import de.prob.statespace.GetOpFromId;
import de.prob.statespace.State;
import de.prob.statespace.StateSpace;
import de.prob.translator.Translator;
import de.prob.translator.types.BObject;
import de.prob.util.StringUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transition {
    public StateSpace stateSpace;
    private final String id;
    private final String name;
    private final State src;
    private final State dest;
    private List<String> params;
    private List<String> returnValues;
    private List<BObject> translatedParams;
    private List<BObject> translatedRetV;
    private String rep;
    private boolean evaluated;
    private FormulaExpand formulaExpansion;
    private final FormalismType formalismType;
    private String predicateString;
    Logger logger = LoggerFactory.getLogger(Transition.class);

    private Transition(StateSpace stateSpace, String id, String name, State src, State dest) {
        this.stateSpace = stateSpace;
        this.id = id;
        this.name = name;
        this.src = src;
        this.dest = dest;
        this.evaluated = false;
        this.rep = name;
        this.formalismType = stateSpace.getModel().getFormalismType();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public State getSource() {
        return this.src;
    }

    public State getDestination() {
        return this.dest;
    }

    public List<String> getParams() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.params;
    }

    public List<BObject> getTranslatedParams() throws BException {
        if (this.translatedParams != null) {
            return this.translatedParams;
        }
        this.translateParamsAndRetVals();
        return this.translatedParams;
    }

    private void translateParamsAndRetVals() throws BException {
        if (!this.evaluated || this.formulaExpansion != FormulaExpand.expand) {
            this.evaluate(FormulaExpand.expand);
        }
        this.translatedParams = new ArrayList<BObject>();
        for (String str : this.params) {
            this.translatedParams.add(Translator.translate((String)str));
        }
        this.translatedRetV = new ArrayList<BObject>();
        for (String str : this.returnValues) {
            this.translatedRetV.add(Translator.translate((String)str));
        }
    }

    public List<String> getReturnValues() {
        if (!this.evaluated) {
            this.evaluate();
        }
        return this.returnValues;
    }

    public List<BObject> getTranslatedReturnValues() throws BException {
        if (this.translatedRetV != null) {
            return this.translatedRetV;
        }
        this.translateParamsAndRetVals();
        return this.translatedRetV;
    }

    public String toString() {
        return this.name;
    }

    public String getRep() {
        return this.rep;
    }

    public String getParameterPredicate() {
        if (this.predicateString != null) {
            return this.predicateString;
        }
        List<String> params = this.getParameterPredicates();
        this.predicateString = params.isEmpty() ? "TRUE=TRUE" : Joiner.on((String)" & ").join(params);
        return this.predicateString;
    }

    public List<String> getParameterPredicates() {
        if (this.isArtificialTransition()) {
            return Collections.emptyList();
        }
        this.evaluate();
        ArrayList<String> predicates = new ArrayList<String>();
        AbstractElement mainComponent = this.stateSpace.getMainComponent();
        List<Object> params = new ArrayList();
        if (mainComponent instanceof ClassicalBMachine) {
            Operation op = ((ClassicalBMachine)mainComponent).getOperation(this.getName());
            params = op.getParameters();
        } else if (mainComponent instanceof EventBMachine) {
            Event event = ((EventBMachine)mainComponent).getEvent(this.getName());
            for (EventParameter eventParameter : event.getParameters()) {
                params.add(eventParameter.getName());
            }
        }
        if (params.size() == this.params.size()) {
            for (int i = 0; i < params.size(); ++i) {
                predicates.add((String)params.get(i) + " = " + this.params.get(i));
            }
        }
        return predicates;
    }

    private String createRep(String name, List<String> params, List<String> returnVals) {
        if (this.formalismType.equals((Object)FormalismType.CSP)) {
            if (params.isEmpty()) {
                return name;
            }
            return name + "." + Joiner.on((String)".").join(params);
        }
        String retVals = returnVals.isEmpty() ? "" : Joiner.on((String)",").join(returnVals) + " <-- ";
        return retVals + name + "(" + Joiner.on((String)",").join(params) + ")";
    }

    public String getPrettyRep() {
        String rep = this.getRep();
        if (this.name.equals("$initialise_machine")) {
            rep = rep.replaceAll("\\$initialise_machine", "INITIALISATION");
        }
        if (this.name.equals("$setup_constants")) {
            rep = rep.replaceAll("\\$setup_constants", "SETUP_CONSTANTS");
        }
        return rep;
    }

    public boolean isArtificialTransition() {
        return this.name.equals("$initialise_machine") || this.name.equals("$setup_constants");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Transition) {
            Transition that = (Transition)obj;
            return this.getId().equals(that.getId()) && this.getSource().equals(that.getSource()) && this.getDestination().equals(that.getDestination());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getSource().getId(), this.getDestination().getId()});
    }

    public boolean isSame(Transition that) {
        this.evaluate();
        that.evaluate();
        return that.getName().equals(this.name) && that.getParams().equals(this.params);
    }

    public Transition evaluate() {
        return this.evaluate(FormulaExpand.truncate);
    }

    public boolean canBeEvaluated(FormulaExpand expansion) {
        if (!this.evaluated) {
            return true;
        }
        return this.formulaExpansion == FormulaExpand.truncate && expansion == FormulaExpand.expand;
    }

    public Transition evaluate(FormulaExpand expansion) {
        if (this.canBeEvaluated(expansion)) {
            GetOpFromId command = new GetOpFromId(this, expansion);
            this.stateSpace.execute((AbstractCommand)command);
            return this;
        }
        return this;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public boolean isTruncated() {
        return this.formulaExpansion == FormulaExpand.truncate;
    }

    public String sha() throws NoSuchAlgorithmException {
        this.evaluate();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(this.getDestination().getStateRep().getBytes());
        return new BigInteger(1, md.digest()).toString(36);
    }

    void setInfo(FormulaExpand expansion, List<String> params, List<String> returnValues) {
        this.formulaExpansion = expansion;
        this.params = params;
        this.returnValues = returnValues;
        this.rep = this.createRep(this.name, params, returnValues);
        this.evaluated = true;
    }

    public static Transition generateArtificialTransition(StateSpace s, String transId, String description, String srcId, String destId) {
        return new Transition(s, transId, description, s.addState(srcId), s.addState(destId));
    }

    public static Transition createTransitionFromCompoundPrologTerm(StateSpace s, CompoundPrologTerm cpt) {
        String opId = Transition.getIdFromPrologTerm(cpt.getArgument(1));
        String name = StringUtil.generateString(BindingGenerator.getCompoundTerm((PrologTerm)cpt.getArgument(2), (int)0).getFunctor());
        String srcId = Transition.getIdFromPrologTerm(cpt.getArgument(3));
        String destId = Transition.getIdFromPrologTerm(cpt.getArgument(4));
        return new Transition(s, opId, name, s.addState(srcId), s.addState(destId));
    }

    public static String getIdFromPrologTerm(PrologTerm destTerm) {
        if (destTerm instanceof IntegerPrologTerm) {
            return BindingGenerator.getInteger((PrologTerm)destTerm).getValue().toString();
        }
        return destTerm.getFunctor();
    }
}

