/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.domainobjects;

import com.google.gson.Gson;
import com.google.inject.Singleton;
import de.prob.animator.domainobjects.CSP;
import de.prob.animator.domainobjects.ClassicalB;
import de.prob.animator.domainobjects.EventB;
import de.prob.animator.domainobjects.IEvalElement;

@Singleton
public class EvalElementFactory {
    public IEvalElement deserialize(String content) {
        if (content.startsWith("#ClassicalB:")) {
            return this.toClassicalB(content);
        }
        if (content.startsWith("#EventB:")) {
            return this.toEventB(content);
        }
        if (content.startsWith("#CSP:")) {
            return this.toCSP(content);
        }
        throw new IllegalArgumentException("String with format " + content + " cannot be deserialized to an IEvalElement");
    }

    private EventB toEventB(String content) {
        return new EventB(content.substring(content.indexOf(":") + 1));
    }

    private ClassicalB toClassicalB(String content) {
        return new ClassicalB(content.substring(content.indexOf(":") + 1));
    }

    private CSP toCSP(String content) {
        String objects = content.substring(content.indexOf(":") + 1);
        Gson g = new Gson();
        CSP fromJson = (CSP)g.fromJson(objects, CSP.class);
        return fromJson;
    }
}

