/*
 * Decompiled with CFR 0.152.
 */
package de.prob.webconsole.servlets;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.prob.animator.IAnimator;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.GetVersionCommand;
import de.prob.cli.CliVersionNumber;
import de.prob.cli.ProBInstanceProvider;
import de.prob.scripting.Downloader;
import de.prob.servlet.Main;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class VersionServlet
extends HttpServlet {
    private final ProBInstanceProvider instanceProvider;
    private final Object versions;
    private CliVersionNumber installed;

    @Inject
    public VersionServlet(Downloader downloader, ProBInstanceProvider instanceProvider) {
        this.versions = downloader.availableVersions();
        this.instanceProvider = instanceProvider;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PrintWriter out = res.getWriter();
        boolean binaryPresent = false;
        try {
            this.instanceProvider.get();
            binaryPresent = true;
        }
        catch (Exception e) {
            binaryPresent = false;
        }
        if (binaryPresent && this.installed == null) {
            GetVersionCommand versionCommand = new GetVersionCommand();
            IAnimator animator = (IAnimator)Main.getInjector().getInstance(IAnimator.class);
            animator.execute((AbstractCommand)versionCommand);
            this.installed = versionCommand.getVersion();
        }
        result.put("installed", this.installed);
        result.put("available", this.versions);
        Gson g = new Gson();
        String json = g.toJson(result);
        out.println(json);
        out.close();
    }
}

