/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import de.be4.classicalb.core.parser.ClassicalBParser;
import de.prob.animator.command.ComputeCoverageCommand;
import de.prob.animator.domainobjects.EventB;
import de.prob.animator.domainobjects.EventBParserBase;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.animator.domainobjects.LTL;
import de.prob.annotations.OneToOne;
import de.prob.annotations.PublicSession;
import de.prob.check.CBCDeadlockChecker;
import de.prob.check.CBCInvariantChecker;
import de.prob.check.ConsistencyChecker;
import de.prob.check.IModelCheckJob;
import de.prob.check.IModelCheckListener;
import de.prob.check.IModelCheckingResult;
import de.prob.check.LTLChecker;
import de.prob.check.LTLOk;
import de.prob.check.ModelCheckOk;
import de.prob.check.ModelChecker;
import de.prob.check.ModelCheckingOptions;
import de.prob.check.StateSpaceStats;
import de.prob.model.classicalb.ClassicalBModel;
import de.prob.model.eventb.EventBModel;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.BEvent;
import de.prob.model.representation.ModelElementList;
import de.prob.parserbase.ProBParserBase;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.FormalismType;
import de.prob.statespace.IModelChangedListener;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import org.eclipse.jetty.util.ajax.JSON;

@PublicSession
@OneToOne
public class ModelCheckingUI
extends AbstractAnimationBasedView
implements IModelChangedListener,
IModelCheckListener {
    private ModelCheckingOptions options;
    private final AnimationSelector animations;
    Map<String, ModelChecker> jobs = new HashMap<String, ModelChecker>();
    Map<String, IModelCheckingResult> results = new HashMap<String, IModelCheckingResult>();
    IEvalElement cbcFormula = null;
    List<String> selectedEvents = new ArrayList<String>();
    private StateSpace currentStateSpace;
    private LTL ltlFormula;

    @Inject
    public ModelCheckingUI(AnimationSelector animations) {
        super(animations);
        this.animations = animations;
        this.incrementalUpdate = false;
        animations.registerModelChangedListener((IModelChangedListener)this);
        this.options = ModelCheckingOptions.DEFAULT;
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/modelchecking/index.html");
    }

    public void updateStats(String id, long timeElapsed, IModelCheckingResult result, StateSpaceStats stats) {
        boolean hasStats;
        this.results.put(id, result);
        boolean bl = hasStats = stats != null;
        if (hasStats) {
            int nrProcessedNodes = stats.getNrProcessedNodes();
            int nrTotalNodes = stats.getNrTotalNodes();
            int percent = nrProcessedNodes * 100 / nrTotalNodes;
            this.submit(WebUtils.wrap("cmd", "ModelChecking.updateJob", "id", id, "stats", hasStats, "processedNodes", nrProcessedNodes, "totalNodes", nrTotalNodes, "totalTransitions", stats.getNrTotalTransitions(), "percent", percent, "time", timeElapsed));
        } else {
            this.submit(WebUtils.wrap("cmd", "ModelChecking.updateJob", "id", id, "stats", hasStats, "percent", 100, "time", timeElapsed));
        }
    }

    public void isFinished(String id, long timeElapsed, IModelCheckingResult result, StateSpaceStats stats) {
        this.results.put(id, result);
        String res = result instanceof ModelCheckOk || result instanceof LTLOk ? "success" : (result instanceof ITraceDescription ? "danger" : "warning");
        boolean hasTrace = result instanceof ITraceDescription;
        ModelChecker modelChecker = this.jobs.get(id);
        ComputeCoverageCommand.ComputeCoverageResult coverage = null;
        if (modelChecker != null) {
            coverage = modelChecker.getCoverage();
        }
        this.jobs.remove(id);
        if (coverage != null) {
            BigInteger numNodes = coverage.getTotalNumberOfNodes();
            BigInteger numTrans = coverage.getTotalNumberOfTransitions();
            String nodeStats = WebUtils.toJson(this.extractNodeStats(coverage.getNodes()));
            List<Map<String, String>> transStats = this.extractNodeStats(coverage.getOps());
            List uncovered = coverage.getUncovered();
            for (String transition : uncovered) {
                transStats.add(WebUtils.wrap("name", transition, "value", "0"));
            }
            String transitionStats = WebUtils.toJson(transStats);
            this.submit(WebUtils.wrap("cmd", "ModelChecking.finishJob", "id", id, "time", timeElapsed, "stats", true, "processedNodes", numNodes, "totalNodes", numNodes, "totalTransitions", numTrans, "result", res, "hasTrace", hasTrace, "message", result.getMessage(), "nodeStats", nodeStats, "transStats", transitionStats));
        } else {
            Map<String, String> wrap = WebUtils.wrap("cmd", "ModelChecking.finishJob", "id", id, "time", timeElapsed, "stats", false, "result", res, "hasTrace", hasTrace, "message", result.getMessage());
            this.submit(wrap);
        }
    }

    private List<Map<String, String>> extractNodeStats(List<String> stats) {
        ArrayList<Map<String, String>> extracted = new ArrayList<Map<String, String>>();
        for (String stat : stats) {
            String woPre = stat.startsWith("'") ? stat.substring(1) : stat;
            String woSuf = woPre.endsWith("'") ? woPre.substring(0, woPre.length() - 1) : woPre;
            String[] split = woSuf.split(":");
            if (split.length == 2) {
                extracted.add(WebUtils.wrap("name", split[0], "value", split[1]));
                continue;
            }
            if (split.length != 1) continue;
            extracted.add(WebUtils.wrap("name", split[0]));
        }
        return extracted;
    }

    public Object startJob(Map<String, String[]> params) {
        if (this.currentStateSpace != null) {
            String mode = params.get("check-mode")[0];
            if (mode.equals("cc-check")) {
                return this.startConsistencyChecking();
            }
            if (mode.equals("cbc-inv")) {
                return this.startCBCInvariant();
            }
            if (mode.equals("cbc-deadlock")) {
                return this.startDBCDeadlock();
            }
            if (mode.equals("ltl-check") && this.ltlFormula != null) {
                return this.startLTLCheck();
            }
        }
        return null;
    }

    private Object startConsistencyChecking() {
        ModelChecker checker = new ModelChecker((IModelCheckJob)new ConsistencyChecker(this.currentStateSpace, this.options, null, (IModelCheckListener)this));
        this.jobs.put(checker.getJobId(), checker);
        checker.start();
        AbstractElement main = this.currentStateSpace.getMainComponent();
        String name = main == null ? "Model Check" : main.toString();
        ArrayList<String> ss = new ArrayList<String>();
        for (ModelCheckingOptions.Options opts : this.options.getPrologOptions()) {
            ss.add(opts.getDescription());
        }
        if (!ss.isEmpty()) {
            name = name + " with " + Joiner.on((String)", ").join(ss);
        }
        return WebUtils.wrap("cmd", "ModelChecking.jobStarted", "name", name, "id", checker.getJobId(), "ssId", this.currentStateSpace.getId());
    }

    private Object startCBCInvariant() {
        ModelChecker checker = new ModelChecker((IModelCheckJob)new CBCInvariantChecker(this.currentStateSpace, this.selectedEvents.isEmpty() ? null : this.selectedEvents, (IModelCheckListener)this));
        this.jobs.put(checker.getJobId(), checker);
        checker.start();
        String name = "CBC invariant check with ";
        name = this.selectedEvents.isEmpty() ? name + "all events" : name + Joiner.on((String)", ").join(this.selectedEvents);
        return WebUtils.wrap("cmd", "ModelChecking.jobStarted", "name", name, "id", checker.getJobId(), "ssId", this.currentStateSpace.getId());
    }

    private Object startDBCDeadlock() {
        ModelChecker checker = new ModelChecker((IModelCheckJob)new CBCDeadlockChecker(this.currentStateSpace, this.cbcFormula, (IModelCheckListener)this));
        this.jobs.put(checker.getJobId(), checker);
        checker.start();
        String name = "CBC deadlock check ";
        if (this.cbcFormula != null) {
            name = name + "with constraint " + this.cbcFormula.getCode();
        }
        return WebUtils.wrap("cmd", "ModelChecking.jobStarted", "name", name, "id", checker.getJobId(), "ssId", this.currentStateSpace.getId());
    }

    private Object startLTLCheck() {
        ModelChecker checker = new ModelChecker((IModelCheckJob)new LTLChecker(this.currentStateSpace, this.ltlFormula, (IModelCheckListener)this));
        this.jobs.put(checker.getJobId(), checker);
        checker.start();
        String name = "LTL check " + this.ltlFormula.getCode();
        return WebUtils.wrap("cmd", "ModelChecking.jobStarted", "name", name, "id", checker.getJobId(), "ssId", this.currentStateSpace.getId());
    }

    public Object cancel(Map<String, String[]> params) {
        String jobId = params.get("jobId")[0];
        ModelChecker modelChecker = this.jobs.get(jobId);
        if (modelChecker != null) {
            modelChecker.cancel();
            return WebUtils.wrap("cmd", "ModelChecking.cancelJob", "id", jobId);
        }
        return null;
    }

    public Object openTrace(Map<String, String[]> params) {
        Trace trace;
        String jobId = params.get("jobId")[0];
        IModelCheckingResult result = this.results.get(jobId);
        if (result instanceof ITraceDescription && (trace = this.currentStateSpace.getTrace((ITraceDescription)result)) != null) {
            this.animations.addNewAnimation(trace, false);
        }
        return null;
    }

    public Object breadthFirst(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.breadthFirst(isSet);
        return null;
    }

    public Object checkDeadlocks(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.checkDeadlocks(isSet);
        return null;
    }

    public Object checkInvariantViolations(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.checkInvariantViolations(isSet);
        return null;
    }

    public Object checkAssertions(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.checkAssertions(isSet);
        return null;
    }

    public Object recheckExisting(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.recheckExisting(isSet);
        return null;
    }

    public Object stopAtFullCoverage(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.stopAtFullCoverage(isSet);
        return null;
    }

    public Object partialOrderReduction(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.partialOrderReduction(isSet);
        return null;
    }

    public Object partialGuardEvaluation(Map<String, String[]> params) {
        boolean isSet = Boolean.valueOf(params.get("set")[0]);
        this.options = this.options.partialGuardEvaluation(isSet);
        return null;
    }

    public Object removeEvent(Map<String, String[]> params) {
        String eventName = params.get("event")[0];
        this.selectedEvents.remove(eventName);
        return null;
    }

    public Object selectEvent(Map<String, String[]> params) {
        String eventName = params.get("event")[0];
        this.selectedEvents.add(eventName);
        return null;
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        Trace ofInterest;
        this.sendInitMessage(context);
        Trace trace = ofInterest = this.animationOfInterest == null ? this.animationsRegistry.getCurrentTrace() : this.animationsRegistry.getTrace(this.animationOfInterest);
        if (ofInterest != null) {
            this.modelChanged(ofInterest.getStateSpace());
        }
    }

    public void modelChanged(StateSpace stateSpace) {
        boolean changed = false;
        if (this.animationOfInterest != null) {
            Trace t = this.animationsRegistry.getTrace(this.animationOfInterest);
            if (t == null) {
                changed = this.currentStateSpace == null;
                this.currentStateSpace = null;
            } else {
                StateSpace old = this.currentStateSpace;
                this.currentStateSpace = t.getStateSpace();
                changed = !this.currentStateSpace.equals(old);
            }
        } else {
            this.currentStateSpace = stateSpace;
            changed = true;
        }
        if (changed) {
            this.currentStateSpace = stateSpace;
            String sId = this.currentStateSpace == null ? "none" : this.currentStateSpace.getId();
            boolean b_model = this.currentStateSpace == null ? false : this.currentStateSpace.getModel().getFormalismType().equals((Object)FormalismType.B);
            List<Object> eventNames = b_model ? this.extractEventNames(this.currentStateSpace) : new ArrayList();
            this.selectedEvents = new ArrayList<String>();
            this.submit(WebUtils.wrap("cmd", "ModelChecking.changeStateSpaces", "ssId", sId, "events", JSON.toString(eventNames), "bType", b_model));
        }
    }

    private List<String> extractEventNames(StateSpace s) {
        ArrayList<String> sts = new ArrayList<String>();
        if (s == null || s.getMainComponent() == null) {
            return sts;
        }
        ModelElementList events = s.getMainComponent().getChildrenOfType(BEvent.class);
        for (BEvent bEvent : events) {
            sts.add(bEvent.getName());
        }
        return sts;
    }

    public Object parse(Map<String, String[]> params) {
        String f = params.get("formula")[0];
        String id = params.get("id")[0];
        if ("cbc-deadlock-input-parent".equals(id)) {
            return this.parseCBC(f, id);
        }
        if ("ltl-check-input-parent".equals(id)) {
            return this.parseLTL(f, id);
        }
        return null;
    }

    public Object parseCBC(String formula, String id) {
        try {
            IEvalElement e = this.currentStateSpace.getModel().parseFormula(formula);
            if (e instanceof EventB) {
                ((EventB)e).getAst();
            }
            this.cbcFormula = e;
            return WebUtils.wrap("cmd", "ModelChecking.parseOk", "id", id);
        }
        catch (Exception e) {
            this.cbcFormula = null;
            if ("".equals(formula)) {
                return WebUtils.wrap("cmd", "ModelChecking.parseOk", "id", id);
            }
            return WebUtils.wrap("cmd", "ModelChecking.parseError", "id", id);
        }
    }

    public Object parseLTL(String formula, String id) {
        try {
            this.ltlFormula = new LTL(formula, this.getLtlLangPart());
            return WebUtils.wrap("cmd", "ModelChecking.parseOk", "id", id);
        }
        catch (Exception e) {
            this.ltlFormula = null;
            return WebUtils.wrap("cmd", "ModelChecking.parseError", "id", id);
        }
    }

    private ProBParserBase getLtlLangPart() {
        if (this.currentStateSpace != null && this.currentStateSpace.getModel() instanceof EventBModel) {
            return new EventBParserBase();
        }
        if (this.currentStateSpace != null && this.currentStateSpace.getModel() instanceof ClassicalBModel) {
            return new ClassicalBParser();
        }
        throw new IllegalArgumentException("An Event-B or Classical-B model must be animated to parse an LTL formula");
    }

    public void animatorStatus(boolean busy) {
    }

    @Override
    public void performTraceChange(Trace trace) {
    }
}

