/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import tlc2.output.MP;
import tlc2.tool.liveness.AbstractDiskGraph;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.TableauNodePtrTable;
import tlc2.util.LongVec;
import tlc2.util.MemIntQueue;
import tlc2.util.statistics.IBucketStatistics;

public class TableauDiskGraph
extends AbstractDiskGraph {
    private static final long INIT_STATE = 0x4000000000000001L;
    private TableauNodePtrTable nodePtrTbl = new TableauNodePtrTable(255);

    public TableauDiskGraph(String metadir, int soln, IBucketStatistics graphStats) throws IOException {
        super(metadir, soln, graphStats);
    }

    @Override
    public final long getPtr(long fp, int tidx) {
        return this.nodePtrTbl.get(fp, tidx);
    }

    public int getElemLength() {
        return this.nodePtrTbl.getElemLength();
    }

    public final boolean isDone(long fp) {
        return this.nodePtrTbl.isDone(fp);
    }

    public final int setDone(long fp) {
        return this.nodePtrTbl.setDone(fp);
    }

    public final void recordNode(long fp, int tidx) {
        this.nodePtrTbl.put(fp, tidx, -8589934592L);
    }

    public final int[] getNodesByLoc(int loc) {
        return this.nodePtrTbl.getNodesByLoc(loc);
    }

    @Override
    protected void putNode(GraphNode node, long ptr) {
        this.nodePtrTbl.put(node.stateFP, node.tindex, ptr);
    }

    @Override
    public final GraphNode getNode(long fp, int tidx) throws IOException {
        long ptr = this.nodePtrTbl.get(fp, tidx);
        if (ptr < 0L) {
            return new GraphNode(fp, tidx);
        }
        if (this.gnodes == null) {
            return this.getNodeFromDisk(fp, tidx, ptr);
        }
        return this.getNode(fp, tidx, ptr);
    }

    @Override
    public long getLink(long state, int tidx) {
        return this.nodePtrTbl.get(state, tidx);
    }

    @Override
    public long putLink(long state, int tidx, long link) {
        int cloc;
        int[] node = this.nodePtrTbl.getNodes(state);
        long oldLink = TableauNodePtrTable.getElem(node, cloc = this.nodePtrTbl.getIdx(node, tidx));
        if (!TableauDiskGraph.isFilePointer(oldLink)) {
            return oldLink;
        }
        TableauNodePtrTable.putElem(node, link, cloc);
        return -1L;
    }

    @Override
    public void setMaxLink(long state, int tidx) {
        this.nodePtrTbl.put(state, tidx, Long.MAX_VALUE);
    }

    @Override
    public final void reset() throws IOException {
        this.nodePtrRAF.setLength(0L);
        this.nodeRAF.setLength(0L);
        this.nodePtrTbl = new TableauNodePtrTable(255);
    }

    @Override
    public long size() {
        return this.nodePtrTbl.size();
    }

    @Override
    protected void makeNodePtrTbl(long ptr) throws IOException {
        this.makeNodePtrTbl(ptr, this.nodePtrTbl);
    }

    protected void makeNodePtrTbl(long ptr, TableauNodePtrTable aTable) throws IOException {
        this.nodePtrRAF.seek(0L);
        while (this.nodePtrRAF.getFilePointer() < ptr) {
            long fp = this.nodePtrRAF.readLong();
            int tidx = this.nodePtrRAF.readInt();
            long loc = this.nodePtrRAF.readLongNat();
            aTable.put(fp, tidx, loc);
        }
    }

    public final String toString() {
        if (this.gnodes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            long nodePtr = this.nodeRAF.getFilePointer();
            long nodePtrPtr = this.nodePtrRAF.getFilePointer();
            long len = this.nodePtrRAF.length();
            this.nodePtrRAF.seek(0L);
            while (this.nodePtrRAF.getFilePointer() < len) {
                long fp = this.nodePtrRAF.readLong();
                int tidx = this.nodePtrRAF.readInt();
                long loc = this.nodePtrRAF.readLongNat();
                sb.append("<" + fp + "," + tidx + "> -> ");
                GraphNode gnode = this.getNode(fp, tidx, loc);
                int sz = gnode.succSize();
                for (int i = 0; i < sz; ++i) {
                    sb.append("<" + gnode.getStateFP(i) + "," + gnode.getTidx(i) + "> ");
                }
                sb.append("\n");
            }
            this.nodeRAF.seek(nodePtr);
            this.nodePtrRAF.seek(nodePtrPtr);
        }
        catch (IOException e) {
            MP.printError(2129, e);
            System.exit(1);
        }
        return sb.toString();
    }

    @Override
    public final String toDotViz() {
        if (this.gnodes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("digraph DiskGraph {\n");
            sb.append("nodesep = 0.7\n");
            sb.append("rankdir=LR;\n");
            long nodePtr = this.nodeRAF.getFilePointer();
            long nodePtrPtr = this.nodePtrRAF.getFilePointer();
            long len = this.nodePtrRAF.length();
            this.nodePtrRAF.seek(0L);
            while (this.nodePtrRAF.getFilePointer() < len) {
                long fp = this.nodePtrRAF.readLong();
                int tidx = this.nodePtrRAF.readInt();
                long loc = this.nodePtrRAF.readLongNat();
                GraphNode gnode = this.getNode(fp, tidx, loc);
                sb.append(gnode.toDotViz(this.isInitState(gnode), true));
            }
            sb.append("}");
            this.nodeRAF.seek(nodePtr);
            this.nodePtrRAF.seek(nodePtrPtr);
        }
        catch (IOException e) {
            MP.printError(2129, e);
            System.exit(1);
        }
        return sb.toString();
    }

    @Override
    public final LongVec getPath(long state, int tidx) throws IOException {
        int numOfInits = this.initNodes.size();
        for (int i = 0; i < numOfInits; i += 2) {
            long state0 = this.initNodes.elementAt(i);
            int tidx0 = (int)this.initNodes.elementAt(i + 1);
            if (state0 != state || tidx0 != tidx) continue;
            LongVec res = new LongVec(1);
            res.addElement(state0);
            return res;
        }
        ReverseTraversableTableauNodePtrTable reversablePtrTable = new ReverseTraversableTableauNodePtrTable(255);
        this.makeNodePtrTbl(this.nodePtrRAF.length(), reversablePtrTable);
        MemIntQueue queue = new MemIntQueue(this.metadir, null);
        for (int i = 0; i < numOfInits; i += 2) {
            int tidx0;
            long state0 = this.initNodes.elementAt(i);
            long ptr = reversablePtrTable.get(state0, tidx0 = (int)this.initNodes.elementAt(i + 1));
            if (ptr == -1L) continue;
            queue.enqueueLong(state0);
            queue.enqueueInt(tidx0);
            queue.enqueueLong(ptr);
            reversablePtrTable.put(state0, tidx0, 0x4000000000000000L);
        }
        while (queue.hasElements()) {
            long curState = queue.dequeueLong();
            int curTidx = queue.dequeueInt();
            long curPtr = queue.dequeueLong();
            GraphNode curNode = this.getNode(curState, curTidx, curPtr);
            int succCnt = curNode.succSize();
            for (int i = 0; i < succCnt; ++i) {
                int cloc;
                int[] nextNodes;
                long nextPtr;
                long nextState = curNode.getStateFP(i);
                int nextTidx = curNode.getTidx(i);
                if (nextState == curState && nextTidx == curTidx) continue;
                if (nextState == state && nextTidx == tidx) {
                    return this.reconstructReversePath(reversablePtrTable, curState, curTidx, nextState, nextTidx);
                }
                int nextLoc = reversablePtrTable.getNodesLoc(nextState);
                if (nextLoc == -1 || !TableauDiskGraph.isFilePointer(nextPtr = TableauNodePtrTable.getElem(nextNodes = reversablePtrTable.getNodesByLoc(nextLoc), cloc = reversablePtrTable.getIdx(nextNodes, nextTidx)))) continue;
                queue.enqueueLong(nextState);
                queue.enqueueInt(nextTidx);
                queue.enqueueLong(nextPtr);
                int curLoc = reversablePtrTable.getNodesLoc(curState);
                ((TableauNodePtrTable)reversablePtrTable).putElem(nextNodes, 0x4000000000000001L + (long)curLoc, curTidx, cloc);
            }
        }
        return super.getPath(state, tidx);
    }

    private LongVec reconstructReversePath(TableauNodePtrTable reversablePtrTable, long startState, int startTidx, long finalState, int finalTidx) {
        LongVec res = new LongVec(2);
        res.addElement(finalState);
        int lastTidx = finalTidx;
        long currentState = startState;
        int currentTidx = startTidx;
        int currentLoc = reversablePtrTable.getNodesLoc(currentState);
        int[] nodes = reversablePtrTable.getNodesByLoc(currentLoc);
        while (true) {
            if (res.lastElement() == currentState && lastTidx == currentTidx) {
                throw new RuntimeException("Self loop in trace path reconstruction");
            }
            res.addElement(currentState);
            lastTidx = currentTidx;
            long predecessorLocation = -1L;
            int predecessorTidx = -1;
            for (int j = 2; j < nodes.length; j += reversablePtrTable.getElemLength()) {
                long candidateLocation = TableauNodePtrTable.getElem(nodes, j);
                int candidateTidx = TableauNodePtrTable.getTidx(nodes, j);
                if (currentTidx != candidateTidx || TableauDiskGraph.isFilePointer(candidateLocation)) continue;
                predecessorLocation = candidateLocation;
                predecessorTidx = reversablePtrTable.getElemTidx(nodes, j);
                if (candidateLocation == 0x4000000000000000L) break;
            }
            if (predecessorLocation == 0x4000000000000000L) break;
            currentLoc = (int)(predecessorLocation - 0x4000000000000001L);
            nodes = reversablePtrTable.getNodesByLoc(currentLoc);
            currentState = TableauNodePtrTable.getKey(nodes);
            currentTidx = predecessorTidx;
        }
        return res;
    }

    private class ReverseTraversableTableauNodePtrTable
    extends TableauNodePtrTable {
        public ReverseTraversableTableauNodePtrTable(int size) {
            super(size);
        }

        @Override
        public int getElemTidx(int[] node, int loc) {
            return node[loc + 3];
        }

        @Override
        public void putElem(int[] node, long elem, int tableauIdx, int loc) {
            super.putElem(node, elem, tableauIdx, loc);
            node[loc + 3] = tableauIdx;
        }

        @Override
        public int getElemLength() {
            return super.getElemLength() + 1;
        }

        @Override
        protected int[] addElem(long key, int tidx, long elem) {
            int[] node = super.addElem(key, tidx, elem);
            node[5] = -1;
            return node;
        }

        @Override
        protected int[] addElem(int[] node, int tidx, long elem) {
            int len = node.length;
            int[] newNode = new int[len + this.getElemLength()];
            System.arraycopy(node, 0, newNode, 0, len);
            newNode[len] = tidx;
            newNode[len + 1] = (int)(elem >>> 32);
            newNode[len + 2] = (int)(elem & 0xFFFFFFFFL);
            newNode[len + 3] = -1;
            return newNode;
        }
    }
}

