/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import tla2sany.semantic.AbortException;
import tla2sany.st.Location;
import tla2sany.utilities.Vector;

public class Errors {
    private boolean succeed = true;
    private int numAborts = 0;
    private int numErrors = 0;
    private int numWarnings = 0;
    private Vector warnings = new Vector();
    private Vector errors = new Vector();
    private Vector aborts = new Vector();

    public String[] getAborts() {
        return this.StringVectortoStringArray(this.aborts);
    }

    public String[] getErrors() {
        return this.StringVectortoStringArray(this.errors);
    }

    public String[] getWarnings() {
        return this.StringVectortoStringArray(this.warnings);
    }

    private String[] StringVectortoStringArray(Vector vec) {
        String[] retVal = new String[vec.size()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = (String)vec.elementAt(i);
        }
        return retVal;
    }

    public final void addWarning(Location loc, String str) {
        int i;
        if (loc == null) {
            loc = Location.nullLoc;
        }
        for (i = this.warnings.size() - 1; i >= 0 && !(loc.toString() + "\n\n" + str).equals(this.warnings.elementAt(i)); --i) {
        }
        if (i < 0) {
            this.warnings.addElement(loc.toString() + "\n\n" + str);
            ++this.numWarnings;
        }
    }

    public final void addError(Location loc, String str) {
        int i;
        if (loc == null) {
            loc = Location.nullLoc;
        }
        for (i = this.errors.size() - 1; i >= 0 && !(loc.toString() + "\n\n" + str).equals(this.errors.elementAt(i)); --i) {
        }
        if (i < 0) {
            this.errors.addElement(loc.toString() + "\n\n" + str);
            ++this.numErrors;
        }
        this.succeed = false;
    }

    public final void addAbort(Location loc, String str, boolean abort) throws AbortException {
        int i;
        String errMsg = loc.toString() + "\n\n" + str;
        for (i = this.aborts.size() - 1; i >= 0 && !errMsg.equals(this.aborts.elementAt(i)); --i) {
        }
        if (i < 0) {
            this.aborts.addElement(errMsg);
            ++this.numAborts;
        }
        this.succeed = false;
        if (abort) {
            throw new AbortException();
        }
    }

    public final void addAbort(Location loc, String str) throws AbortException {
        this.addAbort(loc, str, true);
    }

    public final void addAbort(String str, boolean abort) throws AbortException {
        this.addAbort(Location.nullLoc, str, abort);
    }

    public final void addAbort(String str) throws AbortException {
        this.addAbort(Location.nullLoc, str, true);
    }

    public final boolean isSuccess() {
        return this.succeed;
    }

    public final boolean isFailure() {
        return !this.succeed;
    }

    public final int getNumErrors() {
        return this.numErrors;
    }

    public final int getNumAbortsAndErrors() {
        return this.numAborts + this.numErrors;
    }

    public final int getNumMessages() {
        return this.numAborts + this.numErrors + this.numWarnings;
    }

    public final String toString() {
        int i;
        StringBuffer ret = new StringBuffer("");
        ret.append(this.numAborts > 0 ? "*** Abort messages: " + this.numAborts + "\n\n" : "");
        for (i = 0; i < this.aborts.size(); ++i) {
            ret.append(this.aborts.elementAt(i) + "\n\n\n");
        }
        ret.append(this.numErrors > 0 ? "*** Errors: " + this.numErrors + "\n\n" : "");
        for (i = 0; i < this.errors.size(); ++i) {
            ret.append(this.errors.elementAt(i) + "\n\n\n");
        }
        ret.append(this.numWarnings > 0 ? "*** Warnings: " + this.numWarnings + "\n\n" : "");
        for (i = 0; i < this.warnings.size(); ++i) {
            ret.append(this.warnings.elementAt(i) + "\n\n\n");
        }
        return ret.toString();
    }
}

