/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import tla2sany.parser.SimpleCharStream;
import tla2sany.parser.TLAplusParserTokenManager;
import tla2sany.parser.Token;
import tla2sany.parser.TokenMgrError;
import tlc2.tool.ConfigFileException;
import tlc2.util.Vect;
import tlc2.value.IntValue;
import tlc2.value.ModelValue;
import tlc2.value.SetEnumValue;
import tlc2.value.StringValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;
import tlc2.value.ValueVec;
import util.FileUtil;
import util.FilenameToStream;
import util.SimpleFilenameToStream;

public class ModelConfig
implements ValueConstants,
Serializable {
    private static final String Constant = "CONSTANT";
    private static final String Constants = "CONSTANTS";
    private static final String Constraint = "CONSTRAINT";
    private static final String Constraints = "CONSTRAINTS";
    private static final String ActionConstraint = "ACTION_CONSTRAINT";
    private static final String ActionConstraints = "ACTION_CONSTRAINTS";
    private static final String Invariant = "INVARIANT";
    private static final String Invariants = "INVARIANTS";
    private static final String Init = "INIT";
    private static final String Next = "NEXT";
    private static final String View = "VIEW";
    private static final String Symmetry = "SYMMETRY";
    private static final String Spec = "SPECIFICATION";
    private static final String Prop = "PROPERTY";
    private static final String Props = "PROPERTIES";
    private static final String Type = "TYPE";
    private static final String TypeConstraint = "TYPE_CONSTRAINT";
    public static final String[] ALL_KEYWORDS = new String[]{"CONSTANT", "CONSTANTS", "CONSTRAINT", "CONSTRAINTS", "ACTION_CONSTRAINT", "ACTION_CONSTRAINTS", "INVARIANT", "INVARIANTS", "INIT", "NEXT", "VIEW", "SYMMETRY", "SPECIFICATION", "PROPERTY", "PROPERTIES", "TYPE", "TYPE_CONSTRAINT"};
    private Hashtable configTbl;
    private Hashtable overrides;
    private Hashtable modConstants;
    private Hashtable modOverrides;
    private String configFileName;
    private FilenameToStream resolver;

    public ModelConfig(String configFileName, FilenameToStream resolver) {
        this.resolver = resolver != null ? resolver : new SimpleFilenameToStream();
        ModelValue.init();
        this.configFileName = configFileName;
        this.configTbl = new Hashtable();
        Vect temp = new Vect();
        this.configTbl.put(Constant, temp);
        this.configTbl.put(Constants, temp);
        temp = new Vect();
        this.configTbl.put(Constraint, temp);
        this.configTbl.put(Constraints, temp);
        temp = new Vect();
        this.configTbl.put(ActionConstraint, temp);
        this.configTbl.put(ActionConstraints, temp);
        temp = new Vect();
        this.configTbl.put(Invariant, temp);
        this.configTbl.put(Invariants, temp);
        this.configTbl.put(Init, "");
        this.configTbl.put(Next, "");
        this.configTbl.put(View, "");
        this.configTbl.put(Symmetry, "");
        this.configTbl.put(Spec, "");
        temp = new Vect();
        this.configTbl.put(Prop, temp);
        this.configTbl.put(Props, temp);
        this.configTbl.put(Type, "");
        this.configTbl.put(TypeConstraint, "");
        this.modConstants = new Hashtable();
        this.modOverrides = new Hashtable();
        this.overrides = new Hashtable();
    }

    public final void parse() {
        Vect constants = (Vect)this.configTbl.get(Constant);
        Vect constraints = (Vect)this.configTbl.get(Constraint);
        Vect actionConstraints = (Vect)this.configTbl.get(ActionConstraint);
        Vect invariants = (Vect)this.configTbl.get(Invariant);
        Vect props = (Vect)this.configTbl.get(Prop);
        try {
            FileInputStream fis = FileUtil.newFIS(this.resolver.resolve(this.configFileName, false));
            if (fis == null) {
                throw new ConfigFileException(5001, new String[]{this.configFileName, "File not found."});
            }
            SimpleCharStream scs = new SimpleCharStream(fis, 1, 1);
            TLAplusParserTokenManager tmgr = new TLAplusParserTokenManager(scs, 2);
            Token tt = ModelConfig.getNextToken(tmgr);
            block2: while (tt.kind != 0) {
                String old;
                String tval = tt.image;
                int loc = scs.getBeginLine();
                if (tval.equals(Init)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Init});
                    }
                    old = this.configTbl.put(Init, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Spec});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Next)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Next});
                    }
                    old = this.configTbl.put(Next, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Next});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Spec)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Spec});
                    }
                    old = this.configTbl.put(Spec, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Spec});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(View)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), View});
                    }
                    old = this.configTbl.put(View, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), View});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Symmetry)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Symmetry});
                    }
                    old = this.configTbl.put(Symmetry, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Symmetry});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Type)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Type});
                    }
                    old = this.configTbl.put(Type, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Type});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(TypeConstraint)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), TypeConstraint});
                    }
                    old = this.configTbl.put(TypeConstraint, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), TypeConstraint});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Constant) || tval.equals(Constants)) {
                    while (true) {
                        String modName;
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        String lhs = tt.image;
                        tt = ModelConfig.getNextToken(tmgr);
                        while (tt.image.equals("!")) {
                            tt = ModelConfig.getNextToken(tmgr);
                            lhs = lhs + "!" + tt.image;
                            tt = ModelConfig.getNextToken(tmgr);
                        }
                        Vect line = new Vect();
                        line.addElement(lhs);
                        if (tt.image.equals("<-")) {
                            tt = ModelConfig.getNextToken(tmgr);
                            if (tt.image.equals("[")) {
                                tt = ModelConfig.getNextToken(tmgr);
                                if (tt.kind == 0) {
                                    throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "<-["});
                                }
                                modName = tt.image;
                                tt = ModelConfig.getNextToken(tmgr);
                                if (!tt.image.equals("]")) {
                                    throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "]"});
                                }
                                tt = ModelConfig.getNextToken(tmgr);
                                if (tt.kind == 0) {
                                    throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "<-[mod]"});
                                }
                                Hashtable<Object, String> defs = (Hashtable<Object, String>)this.modOverrides.get(modName);
                                if (defs == null) {
                                    defs = new Hashtable<Object, String>();
                                    this.modOverrides.put(modName, defs);
                                }
                                defs.put(line.elementAt(0), tt.image);
                                continue;
                            }
                            if (tt.kind == 0) {
                                throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "<-"});
                            }
                            this.overrides.put(line.elementAt(0), tt.image);
                            continue;
                        }
                        if (tt.image.equals("(")) {
                            do {
                                tt = ModelConfig.getNextToken(tmgr);
                                Value arg = this.parseValue(tt, scs, tmgr);
                                line.addElement(arg);
                                tt = ModelConfig.getNextToken(tmgr);
                            } while (tt.image.equals(","));
                            if (!tt.image.equals(")")) {
                                throw new ConfigFileException(5002, new String[]{String.valueOf(loc)});
                            }
                            tt = ModelConfig.getNextToken(tmgr);
                        }
                        if (!tt.image.equals("=")) {
                            throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "= or <-"});
                        }
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.image.equals("[")) {
                            tt = ModelConfig.getNextToken(tmgr);
                            if (tt.kind == 0) {
                                throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "=["});
                            }
                            modName = tt.image;
                            tt = ModelConfig.getNextToken(tmgr);
                            if (!tt.image.equals("]")) {
                                throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "]"});
                            }
                            tt = ModelConfig.getNextToken(tmgr);
                            line.addElement(this.parseValue(tt, scs, tmgr));
                            Vect mConsts = (Vect)this.modConstants.get(modName);
                            if (mConsts == null) {
                                mConsts = new Vect();
                                this.modConstants.put(modName, mConsts);
                            }
                            mConsts.addElement(line);
                            continue;
                        }
                        line.addElement(this.parseValue(tt, scs, tmgr));
                        constants.addElement(line);
                    }
                }
                if (tval.equals(Invariant) || tval.equals(Invariants)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        invariants.addElement(tt.image);
                    }
                }
                if (tval.equals(Prop) || tval.equals(Props)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        props.addElement(tt.image);
                    }
                }
                if (tval.equals(Constraint) || tval.equals(Constraints)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        constraints.addElement(tt.image);
                    }
                }
                if (tval.equals(ActionConstraint) || tval.equals(ActionConstraints)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        actionConstraints.addElement(tt.image);
                    }
                }
                throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "a keyword"});
            }
        }
        catch (IOException e) {
            throw new ConfigFileException(5001, new String[]{this.configFileName, e.getMessage()}, e);
        }
    }

    private Value parseValue(Token tt, SimpleCharStream scs, TLAplusParserTokenManager tmgr) throws IOException {
        if (tt.kind == 110) {
            int val = Integer.parseInt(tt.image);
            return IntValue.gen(val);
        }
        if (tt.kind == 111) {
            String tval = tt.image;
            return new StringValue(tval.substring(1, tval.length() - 1));
        }
        if (tt.image.equals("TRUE")) {
            return ValTrue;
        }
        if (tt.image.equals("FALSE")) {
            return ValFalse;
        }
        if (tt.image.equals("{")) {
            ValueVec elems = new ValueVec();
            tt = ModelConfig.getNextToken(tmgr);
            if (!tt.image.equals("}")) {
                while (true) {
                    Value elem = this.parseValue(tt, scs, tmgr);
                    elems.addElement(elem);
                    tt = ModelConfig.getNextToken(tmgr);
                    if (!tt.image.equals(",")) break;
                    tt = ModelConfig.getNextToken(tmgr);
                }
            }
            if (!tt.image.equals("}")) {
                throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "}"});
            }
            return new SetEnumValue(elems, false);
        }
        if (tt.kind != 0) {
            return ModelValue.make(tt.image);
        }
        throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "a value"});
    }

    public static Token getNextToken(TLAplusParserTokenManager tmgr) {
        try {
            return tmgr.getNextToken();
        }
        catch (TokenMgrError e) {
            Token tt = new Token();
            tt.kind = 0;
            return tt;
        }
    }

    public final synchronized Vect getConstants() {
        return (Vect)this.configTbl.get(Constant);
    }

    public final synchronized Hashtable getModConstants() {
        return this.modConstants;
    }

    public final synchronized Hashtable getOverrides() {
        return this.overrides;
    }

    public final synchronized Hashtable getModOverrides() {
        return this.modOverrides;
    }

    public final synchronized Vect getConstraints() {
        return (Vect)this.configTbl.get(Constraint);
    }

    public final synchronized Vect getActionConstraints() {
        return (Vect)this.configTbl.get(ActionConstraint);
    }

    public final synchronized String getInit() {
        return (String)this.configTbl.get(Init);
    }

    public final synchronized String getNext() {
        return (String)this.configTbl.get(Next);
    }

    public final synchronized String getView() {
        return (String)this.configTbl.get(View);
    }

    public final synchronized String getSymmetry() {
        return (String)this.configTbl.get(Symmetry);
    }

    public final synchronized Vect getInvariants() {
        return (Vect)this.configTbl.get(Invariant);
    }

    public final synchronized String getSpec() {
        return (String)this.configTbl.get(Spec);
    }

    public final synchronized Vect getProperties() {
        return (Vect)this.configTbl.get(Prop);
    }

    public final synchronized String getType() {
        return (String)this.configTbl.get(Type);
    }

    public final synchronized String getTypeConstraint() {
        return (String)this.configTbl.get(TypeConstraint);
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream(args[0]);
            SimpleCharStream scs = new SimpleCharStream(fis, 1, 1);
            TLAplusParserTokenManager tmgr = new TLAplusParserTokenManager(scs, 2);
            Token t = ModelConfig.getNextToken(tmgr);
            while (t.kind != 0) {
                System.err.println(t);
                t = ModelConfig.getNextToken(tmgr);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

