/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Context;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class SubstInNode
extends ExprNode {
    private Subst[] substs;
    private ExprNode body;
    private ModuleNode instantiatingModule;
    private ModuleNode instantiatedModule;

    public SubstInNode(TreeNode treeNode, Subst[] subs, ExprNode expr, ModuleNode ingmn, ModuleNode edmn) {
        super(13, treeNode);
        this.substs = subs;
        this.body = expr;
        this.instantiatingModule = ingmn;
        this.instantiatedModule = edmn;
        if (this.body == null) {
            errors.addError(treeNode.getLocation(), "Substitution error, probably due to error \nin module being instantiated.");
        }
    }

    public SubstInNode(TreeNode treeNode, SymbolTable instancerST, Vector instanceeDecls, ModuleNode ingmn, ModuleNode edmn) throws AbortException {
        super(13, treeNode);
        this.instantiatingModule = ingmn;
        this.instantiatedModule = edmn;
        this.constructSubst(instanceeDecls, instancerST, treeNode);
        this.body = null;
    }

    public final Subst[] getSubsts() {
        return this.substs;
    }

    public final ExprNode getBody() {
        return this.body;
    }

    public final void setBody(ExprNode expr) {
        this.body = expr;
    }

    public final ModuleNode getInstantiatingModule() {
        return this.instantiatingModule;
    }

    public final ModuleNode getInstantiatedModule() {
        return this.instantiatedModule;
    }

    public final OpDeclNode getSubFor(int i) {
        return this.substs[i].getOp();
    }

    public final ExprOrOpArgNode getSubWith(int i) {
        return this.substs[i].getExpr();
    }

    final void constructSubst(Vector instanceeDecls, SymbolTable instancerST, TreeNode treeNode) throws AbortException {
        int i;
        Vector vtemp = new Vector();
        for (i = 0; i < instanceeDecls.size(); ++i) {
            OpDeclNode decl = (OpDeclNode)instanceeDecls.elementAt(i);
            SymbolNode symb = instancerST.resolveSymbol(decl.getName());
            if (symb == null) continue;
            if (decl.getKind() == 3 || decl.getKind() == 2 && decl.getArity() == 0) {
                vtemp.addElement(new Subst(decl, new OpApplNode(symb, new ExprOrOpArgNode[0], treeNode, this.instantiatingModule), null, true));
                continue;
            }
            vtemp.addElement(new Subst(decl, new OpArgNode(symb, treeNode, this.instantiatingModule), null, true));
        }
        this.substs = new Subst[vtemp.size()];
        for (i = 0; i < vtemp.size(); ++i) {
            this.substs[i] = (Subst)vtemp.elementAt(i);
        }
    }

    final void addExplicitSubstitute(Context instanceeCtxt, UniqueString lhs, TreeNode stn, ExprOrOpArgNode sub) {
        int index;
        for (index = 0; index < this.substs.length && lhs != this.substs[index].getOp().getName(); ++index) {
        }
        if (index < this.substs.length) {
            if (!this.substs[index].isImplicit()) {
                errors.addError(stn.getLocation(), "Multiple substitutions for symbol '" + lhs.toString() + "' in substitution.");
            } else {
                this.substs[index].setExpr(sub, false);
                this.substs[index].setExprSTN(stn);
            }
        } else {
            SymbolNode lhsSymbol = instanceeCtxt.getSymbol(lhs);
            if (!(lhsSymbol instanceof OpDeclNode)) {
                return;
            }
            if (lhsSymbol != null) {
                int newlength = this.substs.length + 1;
                Subst[] newSubsts = new Subst[newlength];
                Subst newSubst = new Subst((OpDeclNode)lhsSymbol, sub, stn, false);
                System.arraycopy(this.substs, 0, newSubsts, 0, newlength - 1);
                newSubsts[newlength - 1] = newSubst;
                this.substs = newSubsts;
            } else {
                errors.addError(stn.getLocation(), "Illegal identifier '" + lhs + "' in LHS of substitution.");
            }
        }
    }

    final void matchAll(Vector decls) {
        for (int i = 0; i < decls.size(); ++i) {
            int j;
            UniqueString opName = ((OpDeclNode)decls.elementAt(i)).getName();
            for (j = 0; j < this.substs.length && this.substs[j].getOp().getName() != opName; ++j) {
            }
            if (j < this.substs.length) continue;
            errors.addError(this.stn.getLocation(), "Substitution missing for symbol " + opName + " declared at " + ((OpDeclNode)decls.elementAt(i)).getTreeNode().getLocation() + " \nand instantiated in module " + this.instantiatingModule.getName() + ".");
        }
    }

    @Override
    public final boolean levelCheck(int itr) {
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.levelCorrect = true;
        if (!this.body.levelCheck(itr)) {
            this.levelCorrect = false;
        }
        for (int i = 0; i < this.substs.length; ++i) {
            if (this.getSubWith(i).levelCheck(itr)) continue;
            this.levelCorrect = false;
        }
        this.level = this.body.getLevel();
        HashSet lpSet = this.body.getLevelParams();
        for (int i = 0; i < this.substs.length; ++i) {
            if (!lpSet.contains(this.getSubFor(i))) continue;
            this.level = Math.max(this.level, this.getSubWith(i).getLevel());
        }
        for (Object param : lpSet) {
            this.levelParams.addAll(Subst.paramSet(param, this.substs));
        }
        this.allParams = (HashSet)this.body.getAllParams().clone();
        this.nonLeibnizParams = (HashSet)this.body.getNonLeibnizParams().clone();
        for (int i = 0; i < this.substs.length; ++i) {
            OpDeclNode param = this.substs[i].getOp();
            if (!this.allParams.contains(param)) continue;
            this.allParams.remove(param);
            this.allParams.addAll(this.substs[i].getExpr().getAllParams());
            this.nonLeibnizParams.addAll(this.substs[i].getExpr().getNonLeibnizParams());
            if (!this.nonLeibnizParams.contains(param)) continue;
            this.nonLeibnizParams.remove(param);
            this.nonLeibnizParams.addAll(this.substs[i].getExpr().getAllParams());
        }
        boolean isConstant = this.instantiatedModule.isConstant();
        this.levelConstraints = Subst.getSubLCSet(this.body, this.substs, isConstant, itr);
        this.argLevelConstraints = Subst.getSubALCSet(this.body, this.substs, itr);
        this.argLevelParams = Subst.getSubALPSet(this.body, this.substs);
        return this.levelCorrect;
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*SubstInNode: " + super.toString(depth) + "\n  instantiating module: " + this.instantiatingModule.getName() + ", instantiated module: " + this.instantiatedModule.getName() + Strings.indent(2, "\nSubstitutions:");
        if (this.substs != null) {
            for (int i = 0; i < this.substs.length; ++i) {
                ret = ret + Strings.indent(2, Strings.indent(2, "\nSubst:" + (this.substs[i] != null ? Strings.indent(2, this.substs[i].toString(depth - 1)) : "<null>")));
            }
        } else {
            ret = ret + Strings.indent(2, "<null>");
        }
        ret = ret + Strings.indent(2, "\nBody:" + Strings.indent(2, this.body == null ? "<null>" : this.body.toString(depth - 1)));
        return ret;
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.substs.length + 1];
        res[0] = this.body;
        for (int i = 0; i < this.substs.length; ++i) {
            res[i + 1] = this.substs[i].getExpr();
        }
        return res;
    }

    @Override
    public final void walkGraph(Hashtable semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(new Integer(this.myUID), this);
        if (this.substs != null) {
            for (int i = 0; i < this.substs.length; ++i) {
                if (this.substs[i] == null) continue;
                this.substs[i].walkGraph(semNodesTable);
            }
        }
        if (this.body != null) {
            this.body.walkGraph(semNodesTable);
        }
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element sbts = doc.createElement("substs");
        for (int i = 0; i < this.substs.length; ++i) {
            sbts.appendChild(this.substs[i].export(doc, context));
        }
        Element bdy = doc.createElement("body");
        bdy.appendChild(this.body.export(doc, context));
        Element ret = doc.createElement("SubstInNode");
        ret.appendChild(sbts);
        ret.appendChild(bdy);
        return ret;
    }
}

