/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_ds.PersistentMap;
import com.github.krukow.clj_ds.TransientMap;
import com.github.krukow.clj_lang.APersistentMap;
import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.ATransientMap;
import com.github.krukow.clj_lang.Counted;
import com.github.krukow.clj_lang.IDeref;
import com.github.krukow.clj_lang.IEditableCollection;
import com.github.krukow.clj_lang.IFn;
import com.github.krukow.clj_lang.IMapEntry;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.ITransientMap;
import com.github.krukow.clj_lang.MapEntry;
import com.github.krukow.clj_lang.Obj;
import com.github.krukow.clj_lang.PersistentHashMap;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.Util;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentArrayMap<K, V>
extends APersistentMap<K, V>
implements IObj,
IEditableCollection<MapEntry<K, V>>,
PersistentMap<K, V> {
    final Object[] array;
    static final int HASHTABLE_THRESHOLD = 16;
    public static final PersistentArrayMap EMPTY = new PersistentArrayMap();
    private final IPersistentMap _meta;

    public static <K, V> PersistentMap<K, V> create(Map<? extends K, ? extends V> other) {
        ITransientMap ret = EMPTY.asTransient();
        for (Map.Entry<K, V> e : other.entrySet()) {
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return (PersistentMap)((Object)ret.persistentMap());
    }

    protected PersistentArrayMap() {
        this.array = new Object[0];
        this._meta = null;
    }

    @Override
    public PersistentArrayMap<K, V> withMeta(IPersistentMap meta) {
        return new PersistentArrayMap<K, V>(meta, this.array);
    }

    PersistentArrayMap<K, V> create(Object ... init) {
        return new PersistentArrayMap<K, V>(this.meta(), init);
    }

    PersistentHashMap<K, V> createHT(Object[] init) {
        return PersistentHashMap.create(this.meta(), init);
    }

    public static <K, V> PersistentArrayMap<K, V> createWithCheck(Object[] init) {
        for (int i = 0; i < init.length; i += 2) {
            Object k = init[i];
            if (i + 1 >= init.length) {
                throw new IllegalArgumentException("Must provide an even number of params...");
            }
            Object v = init[i + 1];
            for (int j = i + 2; j < init.length; j += 2) {
                if (!PersistentArrayMap.equalKey(init[i], init[j])) continue;
                throw new IllegalArgumentException("Duplicate key: " + init[i]);
            }
        }
        return new PersistentArrayMap<K, V>(init);
    }

    public static <K, V> PersistentArrayMap<K, V> createAsIfByAssoc(Object[] init) {
        int n = 0;
        for (int i = 0; i < init.length; i += 2) {
            boolean duplicateKey = false;
            for (int j = 0; j < i; j += 2) {
                if (!PersistentArrayMap.equalKey(init[i], init[j])) continue;
                duplicateKey = true;
                break;
            }
            if (duplicateKey) continue;
            n += 2;
        }
        if (n < init.length) {
            Object[] nodups = new Object[n];
            int m = 0;
            for (int i = 0; i < init.length; i += 2) {
                int j;
                boolean duplicateKey = false;
                for (j = 0; j < m; j += 2) {
                    if (!PersistentArrayMap.equalKey(init[i], nodups[j])) continue;
                    duplicateKey = true;
                    break;
                }
                if (duplicateKey) continue;
                for (j = init.length - 2; j >= i && !PersistentArrayMap.equalKey(init[i], init[j]); j -= 2) {
                }
                nodups[m] = init[i];
                nodups[m + 1] = init[j + 1];
                m += 2;
            }
            if (m != n) {
                throw new IllegalArgumentException("Internal error: m=" + m);
            }
            init = nodups;
        }
        return new PersistentArrayMap<K, V>(init);
    }

    public PersistentArrayMap(Object[] init) {
        this.array = init;
        this._meta = null;
    }

    public PersistentArrayMap(IPersistentMap meta, Object[] init) {
        this._meta = meta;
        this.array = init;
    }

    @Override
    public int count() {
        return this.array.length / 2;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key) >= 0;
    }

    @Override
    public IMapEntry<K, V> entryAt(K key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return new MapEntry<Object, Object>(this.array[i], this.array[i + 1]);
        }
        return null;
    }

    @Override
    public IPersistentMap<K, V> assocEx(K key, V val) {
        int i = this.indexOf(key);
        if (i >= 0) {
            throw Util.runtimeException("Key already present");
        }
        if (this.array.length > 16) {
            return this.createHT(this.array).assocEx(key, val);
        }
        Object[] newArray = new Object[this.array.length + 2];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, newArray, 2, this.array.length);
        }
        newArray[0] = key;
        newArray[1] = val;
        return this.create(newArray);
    }

    @Override
    public IPersistentMap<K, V> assoc(K key, V val) {
        Object[] newArray;
        int i = this.indexOf(key);
        if (i >= 0) {
            if (this.array[i + 1] == val) {
                return this;
            }
            newArray = (Object[])this.array.clone();
            newArray[i + 1] = val;
        } else {
            if (this.array.length > 16) {
                return this.createHT(this.array).assoc((Object)key, (Object)val);
            }
            newArray = new Object[this.array.length + 2];
            if (this.array.length > 0) {
                System.arraycopy(this.array, 0, newArray, 2, this.array.length);
            }
            newArray[0] = key;
            newArray[1] = val;
        }
        return this.create(newArray);
    }

    @Override
    public PersistentArrayMap<K, V> without(K key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            int newlen = this.array.length - 2;
            if (newlen == 0) {
                return this.empty();
            }
            Object[] newArray = new Object[newlen];
            int d = 0;
            for (int s = 0; s < this.array.length; s += 2) {
                if (PersistentArrayMap.equalKey(this.array[s], key)) continue;
                newArray[d] = this.array[s];
                newArray[d + 1] = this.array[s + 1];
                d += 2;
            }
            return this.create(newArray);
        }
        return this;
    }

    public PersistentArrayMap<K, V> empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public final V valAt(K key, V notFound) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return (V)this.array[i + 1];
        }
        return notFound;
    }

    @Override
    public V valAt(K key) {
        return this.valAt(key, null);
    }

    public int capacity() {
        return this.count();
    }

    private int indexOfObject(Object key) {
        Util.EquivPred ep = Util.equivPred(key);
        for (int i = 0; i < this.array.length; i += 2) {
            if (!ep.equiv(key, this.array[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(Object key) {
        return this.indexOfObject(key);
    }

    static boolean equalKey(Object k1, Object k2) {
        return Util.equiv(k1, k2);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iter(this.array);
    }

    @Override
    public Iterator<Map.Entry<K, V>> reverseIterator() {
        return new RevIter(this.array);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iteratorFrom(K key) {
        int i = this.indexOf(key);
        return new Iter(this.array, i);
    }

    @Override
    public ISeq seq() {
        if (this.array.length > 0) {
            return new Seq(this.array, 0);
        }
        return null;
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    public Object kvreduce(IFn f, Object init) {
        for (int i = 0; i < this.array.length; i += 2) {
            if (!RT.isReduced(init = f.invoke(init, this.array[i], this.array[i + 1]))) continue;
            return ((IDeref)init).deref();
        }
        return init;
    }

    public TransientArrayMap asTransient() {
        return new TransientArrayMap(this.array);
    }

    @Override
    public PersistentMap<K, V> zero() {
        return this.empty();
    }

    @Override
    public PersistentMap<K, V> plus(K key, V val) {
        return (PersistentMap)((Object)this.assoc((Object)key, (Object)val));
    }

    @Override
    public PersistentMap<K, V> plusEx(K key, V val) {
        return (PersistentMap)((Object)this.assocEx(key, val));
    }

    @Override
    public PersistentMap<K, V> minus(K key) {
        return this.without((Object)key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TransientArrayMap<K, V>
    extends ATransientMap<K, V>
    implements TransientMap<K, V> {
        int len;
        final Object[] array;
        Thread owner = Thread.currentThread();

        public TransientArrayMap(Object[] array) {
            this.array = new Object[Math.max(16, array.length)];
            System.arraycopy(array, 0, this.array, 0, array.length);
            this.len = array.length;
        }

        private int indexOf(Object key) {
            for (int i = 0; i < this.len; i += 2) {
                if (!PersistentArrayMap.equalKey(this.array[i], key)) continue;
                return i;
            }
            return -1;
        }

        @Override
        ITransientMap<K, V> doAssoc(K key, V val) {
            int i = this.indexOf(key);
            if (i >= 0) {
                if (this.array[i + 1] != val) {
                    this.array[i + 1] = val;
                }
            } else {
                if (this.len >= this.array.length) {
                    return PersistentHashMap.create(this.array).asTransient().assoc((Object)key, (Object)val);
                }
                this.array[this.len++] = key;
                this.array[this.len++] = val;
            }
            return this;
        }

        @Override
        TransientArrayMap<K, V> doWithout(K key) {
            int i = this.indexOf(key);
            if (i >= 0) {
                if (this.len >= 2) {
                    this.array[i] = this.array[this.len - 2];
                    this.array[i + 1] = this.array[this.len - 1];
                }
                this.len -= 2;
            }
            return this;
        }

        @Override
        V doValAt(K key, V notFound) {
            int i = this.indexOf(key);
            if (i >= 0) {
                return (V)this.array[i + 1];
            }
            return notFound;
        }

        @Override
        int doCount() {
            return this.len / 2;
        }

        @Override
        PersistentArrayMap<K, V> doPersistent() {
            this.ensureEditable();
            this.owner = null;
            Object[] a = new Object[this.len];
            System.arraycopy(this.array, 0, a, 0, this.len);
            return new PersistentArrayMap(a);
        }

        @Override
        void ensureEditable() {
            if (this.owner == Thread.currentThread()) {
                return;
            }
            if (this.owner != null) {
                throw new IllegalAccessError("Transient used by non-owner thread");
            }
            throw new IllegalAccessError("Transient used after persistent! call");
        }

        @Override
        public IPersistentCollection persistent() {
            return this.persistentMap();
        }

        @Override
        public PersistentMap<K, V> persist() {
            return (PersistentMap)((Object)this.persistent());
        }

        @Override
        public TransientMap<K, V> plus(K key, V val) {
            return (TransientMap)((Object)this.assoc((Object)key, (Object)val));
        }

        @Override
        public TransientMap<K, V> minus(K key) {
            return (TransientMap)((Object)this.without(key));
        }
    }

    static class RevIter
    implements Iterator {
        Object[] array;
        int i;

        RevIter(Object[] array) {
            this(array, array.length);
        }

        RevIter(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        public boolean hasNext() {
            return this.i > 0;
        }

        public Object next() {
            this.i -= 2;
            return new MapEntry<Object, Object>(this.array[this.i], this.array[this.i + 1]);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Iter
    implements Iterator {
        Object[] array;
        int i;

        Iter(Object[] array) {
            this(array, -2);
        }

        Iter(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        public boolean hasNext() {
            return this.i < this.array.length - 2;
        }

        public Object next() {
            this.i += 2;
            return new MapEntry<Object, Object>(this.array[this.i], this.array[this.i + 1]);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Seq
    extends ASeq
    implements Counted {
        final Object[] array;
        final int i;

        Seq(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        public Seq(IPersistentMap meta, Object[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return new MapEntry<Object, Object>(this.array[this.i], this.array[this.i + 1]);
        }

        public ISeq next() {
            if (this.i + 2 < this.array.length) {
                return new Seq(this.array, this.i + 2);
            }
            return null;
        }

        public int count() {
            return (this.array.length - this.i) / 2;
        }

        public Obj withMeta(IPersistentMap meta) {
            return new Seq(meta, this.array, this.i);
        }
    }
}

