/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import java.util.Set;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.wd.FormulaBuilder;
import org.eventb.internal.core.ast.wd.Lemma;
import org.eventb.internal.core.ast.wd.Node;

public class NodeLand
extends Node {
    private final Node[] children;

    public NodeLand(Node[] children) {
        this.children = children;
    }

    @Override
    protected int maxBindingDepth() {
        int depth = 0;
        for (Node child : this.children) {
            depth = Math.max(depth, child.maxBindingDepth());
        }
        return depth;
    }

    @Override
    protected void boundIdentifiersEqualizer(int offset) {
        for (Node child : this.children) {
            child.boundIdentifiersEqualizer(offset);
        }
    }

    @Override
    protected Predicate internalAsPredicate(FormulaBuilder fb, boolean original) {
        int length = this.children.length;
        Predicate[] childPreds = new Predicate[length];
        for (int i = 0; i < length; ++i) {
            childPreds[i] = this.children[i].asPredicate(fb, original);
        }
        return fb.land(childPreds);
    }

    @Override
    protected void collectAntecedents(Set<Predicate> antecedents, FormulaBuilder fb) {
        for (Node child : this.children) {
            child.collectAntecedents(antecedents, fb);
        }
    }

    @Override
    protected void internalSimplify(Set<Lemma> knownLemmas, Set<Predicate> antecedents, FormulaBuilder fb) {
        for (Node child : this.children) {
            child.simplify(knownLemmas, antecedents, fb);
        }
    }

    @Override
    protected void internalToString(StringBuilder sb, String indent) {
        sb.append("LAND\n");
        for (Node child : this.children) {
            child.toString(sb, indent + "  ");
        }
    }
}

