/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import java.util.ArrayList;
import java.util.Set;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.internal.core.ast.ASTPlugin;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.TokenSet;

public class ExtnUnicityChecker {
    private final AbstractGrammar standardGrammar;

    public ExtnUnicityChecker(AbstractGrammar standardGrammar) {
        this.standardGrammar = standardGrammar;
    }

    public void checkUnicity(Set<IFormulaExtension> extns) {
        this.checkSymbolUnicity(extns);
        this.checkIdUnicity(extns);
    }

    private void checkSymbolUnicity(Set<IFormulaExtension> extns) {
        TokenSet standardSymbols = this.standardGrammar.getTokens();
        ArrayList<String> symbols = new ArrayList<String>();
        for (IFormulaExtension extn : extns) {
            String symbol = extn.getSyntaxSymbol();
            if (standardSymbols.contains(symbol) || symbols.contains(symbol)) {
                ExtnUnicityChecker.processInvalid(extn, "overrides existing symbol: " + symbol);
            }
            symbols.add(symbol);
        }
    }

    private void checkIdUnicity(Set<IFormulaExtension> extns) {
        ArrayList<String> ids = new ArrayList<String>();
        for (IFormulaExtension extn : extns) {
            String id = extn.getId();
            if (ids.contains(id) || !this.hasGloballyUnicId(extn)) {
                ExtnUnicityChecker.processInvalid(extn, "overrides existing id: " + id);
            }
            ids.add(id);
        }
    }

    private boolean hasGloballyUnicId(IFormulaExtension newExtn) {
        String newId = newExtn.getId();
        return !this.standardGrammar.isDeclared(newId);
    }

    private static void processInvalid(IFormulaExtension newExtn, String reason) {
        String message = ExtnUnicityChecker.makeInvalidMessage(newExtn, reason);
        ASTPlugin.log(null, message);
        throw new IllegalArgumentException(message);
    }

    private static String makeInvalidMessage(IFormulaExtension newExtn, String reason) {
        return "invalid extension " + newExtn.getId() + ": " + reason;
    }
}

