/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.internal.core.ast.AbstractResult;

public class LegibilityResult
extends AbstractResult {
    private final Map<String, FreeIdentifier> freeIdents;
    private final Map<String, BoundIdentDecl> boundIdentDecls;

    public LegibilityResult(Collection<FreeIdentifier> context) {
        this.boundIdentDecls = new HashMap<String, BoundIdentDecl>();
        if (context == null) {
            this.freeIdents = new HashMap<String, FreeIdentifier>();
        } else {
            this.freeIdents = new HashMap<String, FreeIdentifier>(context.size());
            for (FreeIdentifier ident : context) {
                this.freeIdents.put(ident.getName(), ident);
            }
        }
    }

    public LegibilityResult(LegibilityResult other) {
        this.freeIdents = new HashMap<String, FreeIdentifier>(other.freeIdents);
        this.boundIdentDecls = new HashMap<String, BoundIdentDecl>(other.boundIdentDecls);
        for (ASTProblem problem : other.getProblems()) {
            this.addProblem(problem);
        }
    }

    public boolean hasFreeIdent(String name) {
        return this.freeIdents.containsKey(name);
    }

    public boolean hasBoundIdentDecl(String name) {
        return this.boundIdentDecls.containsKey(name);
    }

    public FreeIdentifier getExistingFreeIdentifier(String name) {
        return this.freeIdents.get(name);
    }

    public BoundIdentDecl getExistingBoundIdentDecl(String name) {
        return this.boundIdentDecls.get(name);
    }

    public void addFreeIdent(FreeIdentifier ident) {
        this.freeIdents.put(ident.getName(), ident);
    }

    public void addBoundIdentDecl(BoundIdentDecl ident) {
        this.boundIdentDecls.put(ident.getName(), ident);
    }
}

