/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class BoundIdentifier
extends Identifier {
    private final int boundIndex;

    protected BoundIdentifier(int boundIndex, SourceLocation location, Type type, FormulaFactory ff) {
        super(3, ff, location, boundIndex);
        if (boundIndex < 0) {
            throw new IllegalArgumentException("Negative de Bruijn index: " + boundIndex);
        }
        this.boundIndex = boundIndex;
        this.ensureSameFactory(type);
        this.setPredicateVariableCache(new Formula[0]);
        this.synthesizeType(type);
        FormulaChecks.ensureHasType(this, type);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        this.freeIdents = NO_FREE_IDENT;
        this.boundIdents = new BoundIdentifier[]{this};
        if (givenType == null) {
            return;
        }
        this.freeIdents = GivenTypeHelper.getGivenTypeIdentifiers(givenType);
        this.setFinalType(givenType, givenType);
    }

    public int getBoundIndex() {
        return this.boundIndex;
    }

    public BoundIdentDecl getDeclaration(BoundIdentDecl[] boundIdentDecls) {
        return boundIdentDecls[boundIdentDecls.length - this.boundIndex - 1];
    }

    private static String resolveIndex(int index, String[] boundIdents) {
        if (index < boundIdents.length) {
            return boundIdents[boundIdents.length - index - 1];
        }
        return null;
    }

    private void toStringFullyParenthesized(StringBuilder builder, String[] boundNames) {
        String image = BoundIdentifier.resolveIndex(this.boundIndex, boundNames);
        if (image == null) {
            builder.append("[[");
            builder.append(this.boundIndex);
            builder.append("]]");
        } else {
            builder.append(image);
        }
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        StringBuilder builder = new StringBuilder();
        builder.append(tabs);
        builder.append(this.getClass().getSimpleName());
        builder.append(" [name: ");
        this.toStringFullyParenthesized(builder, boundNames);
        builder.append("] [index: ");
        builder.append(this.boundIndex);
        if (this.getType() != null) {
            builder.append("] [type: ");
            builder.append(this.getType().toString());
        }
        builder.append("]\n");
        return builder.toString();
    }

    @Override
    protected void isLegible(LegibilityResult result) {
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        BoundIdentifier other = (BoundIdentifier)expr;
        return this.boundIndex == other.boundIndex;
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        BoundIdentDecl decl = this.getDeclaration(quantifiedIdentifiers);
        assert (decl != null) : "Bound variable without a declaration";
        this.setTemporaryType(decl.getType(), result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        if (this.boundIndex >= offset) {
            names.add(BoundIdentifier.resolveIndex(this.boundIndex - offset, boundNames));
        }
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visitBOUND_IDENT(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBoundIdentifier(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        return rewriter.rewrite(this);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

