/*
 * Decompiled with CFR 0.152.
 */
package de.prob.statespace;

import de.prob.statespace.State;
import de.prob.statespace.Transition;

public class TraceElement {
    private final int index;
    private final State currentState;
    private final Transition transition;
    private final TraceElement previous;

    public TraceElement(State stateId) {
        this.currentState = stateId;
        this.transition = null;
        this.previous = null;
        this.index = -1;
    }

    public TraceElement(Transition edge, TraceElement previous) {
        this.currentState = edge.getDestination();
        this.transition = edge;
        this.previous = previous;
        this.index = previous.getIndex() + 1;
    }

    public State getSrc() {
        if (this.transition != null) {
            return this.transition.getSource();
        }
        return this.currentState;
    }

    public State getDest() {
        if (this.transition != null) {
            return this.transition.getDestination();
        }
        return null;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public TraceElement getPrevious() {
        return this.previous;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        if (this.transition == null) {
            return this.currentState.getId();
        }
        return this.transition.toString();
    }
}

