/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import de.prob.cli.ConsoleListener;
import de.prob.cli.OsSpecificInfo;
import de.prob.cli.ProBConnection;
import de.prob.exception.CliError;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProBInstance {
    private final Thread thread;
    private volatile boolean shutingDown = false;
    final Logger logger = LoggerFactory.getLogger(ProBInstance.class);
    private final Process process;
    private final ProBConnection connection;
    private String[] interruptCommand;
    private AtomicInteger processCounter;

    @Inject
    public ProBInstance(Process process, BufferedReader stream, Long userInterruptReference, ProBConnection connection, String home, OsSpecificInfo osInfo, AtomicInteger processCounter) {
        this.process = process;
        this.connection = connection;
        this.processCounter = processCounter;
        String command = home + osInfo.getUserInterruptCmd();
        this.interruptCommand = new String[]{command, Long.toString(userInterruptReference)};
        this.thread = this.makeOutputPublisher(stream);
        this.thread.start();
    }

    private Thread makeOutputPublisher(BufferedReader stream) {
        return new Thread(new ConsoleListener(this, stream, this.logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.shutingDown) {
            this.processCounter.decrementAndGet();
        }
        this.shutingDown = true;
        try {
            if (this.thread.isAlive()) {
                this.thread.interrupt();
            }
            this.connection.disconnect();
        }
        finally {
            this.process.destroy();
        }
    }

    public void sendInterrupt() {
        try {
            if (this.connection.isBusy()) {
                this.logger.info("sending interrupt signal");
                Runtime.getRuntime().exec(this.interruptCommand);
            } else {
                this.logger.info("ignoring interrupt signal because the connection is not busy");
            }
        }
        catch (IOException e) {
            this.logger.warn("calling the send_user_interrupt command failed", (Throwable)e);
        }
    }

    public String send(String term) {
        try {
            return this.connection.send(term);
        }
        catch (IOException e) {
            throw new CliError("Error during communicating with Prolog core.", e);
        }
    }

    public boolean isShuttingDown() {
        return this.shutingDown;
    }

    public String toString() {
        return MoreObjects.toStringHelper(ProBInstance.class).addValue((Object)this.connection).toString();
    }
}

