/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.HashSet;
import java.util.Set;
import org.eventb.core.ast.extension.CycleError;
import org.eventb.internal.core.parser.operators.Closure;
import org.eventb.internal.core.parser.operators.Relation;

public class OperatorGroup {
    private final Set<Integer> allOperators = new HashSet<Integer>();
    private final Relation<Integer> compatibilityRelation = new Relation();
    private final Closure<Integer> operatorPriority = new Closure();
    private final Set<Integer> associativeOperators = new HashSet<Integer>();
    private final Set<Integer> spacedOperators = new HashSet<Integer>();
    private final String id;

    public OperatorGroup(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Set<Integer> getAllOperators() {
        return this.allOperators;
    }

    public Relation<Integer> getCompatibilityRelation() {
        return this.compatibilityRelation;
    }

    public Closure<Integer> getOperatorPriority() {
        return this.operatorPriority;
    }

    public Set<Integer> getAssociativeOperators() {
        return this.associativeOperators;
    }

    public Set<Integer> getSpacedOperators() {
        return this.spacedOperators;
    }

    public void add(Integer a) {
        this.allOperators.add(a);
    }

    private void checkKnown(Integer ... ops) {
        for (Integer op : ops) {
            if (this.allOperators.contains(op)) continue;
            throw new IllegalArgumentException("unknown operator " + op);
        }
    }

    public void addCompatibility(Integer a, Integer b) {
        this.checkKnown(a, b);
        this.compatibilityRelation.add(a, b);
    }

    public void addAssociativity(Integer a) {
        this.checkKnown(a);
        this.compatibilityRelation.add(a, a);
        this.associativeOperators.add(a);
    }

    public void addPriority(Integer a, Integer b) throws CycleError {
        this.checkKnown(a, b);
        this.operatorPriority.add(a, b);
    }

    public String toString() {
        return this.id;
    }

    public void setSpaced(Integer kind) {
        this.checkKnown(kind);
        this.spacedOperators.add(kind);
    }
}

