/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IDestructorExtension;
import org.eventb.core.ast.extension.ICompatibilityMediator;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IPriorityMediator;
import org.eventb.core.ast.extension.ITypeCheckMediator;
import org.eventb.core.ast.extension.ITypeMediator;
import org.eventb.core.ast.extension.IWDMediator;
import org.eventb.internal.core.ast.datatype.ConstructorArgument;
import org.eventb.internal.core.ast.datatype.ConstructorExtension;
import org.eventb.internal.core.ast.datatype.ConstructorPredicateBuilder;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DatatypeHelper;
import org.eventb.internal.core.ast.datatype.TypeSubstitution;

public class DestructorExtension
extends ConstructorArgument
implements IDestructorExtension {
    private final String name;
    private final String id;
    private final IExtensionKind kind;
    private final String groupId;

    public DestructorExtension(Datatype origin, ConstructorExtension constructor, String name, Type type) {
        super(constructor, type);
        this.name = name;
        this.id = DatatypeHelper.computeId(name);
        int nbArgs = 1;
        this.kind = DatatypeHelper.computeKind(nbArgs);
        this.groupId = DatatypeHelper.computeGroup(nbArgs);
    }

    @Override
    public boolean isDestructor() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean conjoinChildrenWD() {
        return true;
    }

    @Override
    public Predicate getWDPredicate(IExtendedFormula formula, IWDMediator wdMediator) {
        if (((Datatype)this.getOrigin()).hasSingleConstructor()) {
            return wdMediator.makeTrueWD();
        }
        Expression dtValue = formula.getChildExpressions()[0];
        return ConstructorPredicateBuilder.makeInConstructorDomain(dtValue, this.constructor);
    }

    @Override
    public String getSyntaxSymbol() {
        return this.name;
    }

    @Override
    public IExtensionKind getKind() {
        return this.kind;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void addPriorities(IPriorityMediator mediator) {
    }

    @Override
    public void addCompatibilities(ICompatibilityMediator mediator) {
    }

    @Override
    public Type synthesizeType(Expression[] childExprs, Predicate[] childPreds, ITypeMediator mediator) {
        Type childType = childExprs[0].getType();
        TypeSubstitution subst = TypeSubstitution.makeSubstitution((Datatype)this.getOrigin(), childType);
        if (subst == null) {
            return null;
        }
        return this.getType(subst);
    }

    @Override
    public boolean verifyType(Type proposedType, Expression[] childExprs, Predicate[] childPreds) {
        assert (childExprs.length == 1);
        assert (childPreds.length == 0);
        Type childType = childExprs[0].getType();
        TypeSubstitution subst = TypeSubstitution.makeSubstitution((Datatype)this.getOrigin(), childType);
        if (subst == null) {
            return false;
        }
        Type expected = this.getType(subst);
        return expected.equals(proposedType);
    }

    @Override
    public Type typeCheck(ExtendedExpression expression, ITypeCheckMediator tcMediator) {
        Type childType = expression.getChildExpressions()[0].getType();
        TypeSubstitution subst = TypeSubstitution.makeSubstitution((Datatype)this.getOrigin(), tcMediator);
        tcMediator.sameType(childType, subst.getInstanceType());
        return this.getType(subst);
    }

    @Override
    public boolean isATypeConstructor() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 * this.formalType.hashCode() + this.name.hashCode();
    }

    @Override
    public boolean isSimilarTo(ConstructorArgument other) {
        return super.isSimilarTo(other) && this.name.equals(other.asDestructor().name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.name);
        sb.append(": ");
        super.toString(sb);
    }
}

