/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.HashMap;
import java.util.Map;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ISpecialization;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.internal.core.ast.Substitute;
import org.eventb.internal.core.ast.Substitution;
import org.eventb.internal.core.ast.TypeRewriter;
import org.eventb.internal.core.typecheck.TypeEnvironment;

public class Specialization
extends Substitution
implements ISpecialization {
    private final Map<GivenType, Type> typeSubst;
    private final Map<FreeIdentifier, Substitute> identSubst;
    private final TypeRewriter speTypeRewriter;

    public Specialization(FormulaFactory ff) {
        super(ff);
        this.typeSubst = new HashMap<GivenType, Type>();
        this.identSubst = new HashMap<FreeIdentifier, Substitute>();
        this.speTypeRewriter = new TypeRewriter(ff){

            @Override
            public void visit(GivenType type) {
                Type rewritten = Specialization.this.getOrSetDefault(type);
                if (type.equals(rewritten)) {
                    super.visit(type);
                } else {
                    this.result = rewritten;
                }
            }
        };
    }

    public Specialization(Specialization other) {
        super(other.ff);
        this.typeSubst = new HashMap<GivenType, Type>(other.typeSubst);
        this.identSubst = new HashMap<FreeIdentifier, Substitute>(other.identSubst);
        this.speTypeRewriter = other.speTypeRewriter;
    }

    @Override
    public ISpecialization clone() {
        return new Specialization(this);
    }

    @Override
    public void put(GivenType type, Type value) {
        if (type == null) {
            throw new NullPointerException("Null given type");
        }
        if (value == null) {
            throw new NullPointerException("Null type");
        }
        if (this.ff != value.getFactory()) {
            throw new IllegalArgumentException("Wrong factory for value: " + value.getFactory() + ", should be " + this.ff);
        }
        Type oldValue = this.typeSubst.put(type, value);
        if (oldValue != null && !oldValue.equals(value)) {
            this.typeSubst.put(type, oldValue);
            throw new IllegalArgumentException("Type substitution for " + type + " already registered");
        }
        Substitute subst = Substitute.makeSubstitute(value.toExpression());
        this.identSubst.put(type.toExpression(), subst);
    }

    @Override
    public Type get(GivenType key) {
        return this.typeSubst.get(key);
    }

    public Type getOrSetDefault(GivenType key) {
        Type value = this.get(key);
        if (value == null) {
            value = key.translate(this.ff);
            this.put(key, value);
        }
        return value;
    }

    @Override
    public void put(FreeIdentifier ident, Expression value) {
        if (ident == null) {
            throw new NullPointerException("Null identifier");
        }
        if (!ident.isTypeChecked()) {
            throw new IllegalArgumentException("Untyped identifier");
        }
        if (value == null) {
            throw new NullPointerException("Null value");
        }
        if (this.ff != value.getFactory()) {
            throw new IllegalArgumentException("Wrong factory for value: " + value.getFactory() + ", should be " + this.ff);
        }
        if (!value.isTypeChecked()) {
            throw new IllegalArgumentException("Untyped value");
        }
        this.verify(ident, value);
        Substitute subst = Substitute.makeSubstitute(value);
        Substitute oldSubst = this.identSubst.put(ident, subst);
        if (oldSubst != null && !oldSubst.equals(subst)) {
            this.identSubst.put(ident, oldSubst);
            throw new IllegalArgumentException("Identifier substitution for " + ident + " already registered");
        }
    }

    private void verify(FreeIdentifier ident, Expression value) {
        Type identType = ident.getType();
        Type newType = identType.specialize(this);
        if (!value.getType().equals(newType)) {
            throw new IllegalArgumentException("Incompatible types for " + ident);
        }
    }

    public Type specialize(Type type) {
        return this.speTypeRewriter.rewrite(type);
    }

    public ITypeEnvironmentBuilder specialize(TypeEnvironment typenv) {
        ITypeEnvironmentBuilder result = this.ff.makeTypeEnvironment();
        ITypeEnvironment.IIterator iter = typenv.getIterator();
        while (iter.hasNext()) {
            iter.advance();
            FreeIdentifier ident = iter.asFreeIdentifier();
            Expression expr = this.getOrSetDefault(ident);
            for (FreeIdentifier free : expr.getFreeIdentifiers()) {
                result.add(free);
            }
        }
        return result;
    }

    @Override
    public Expression get(FreeIdentifier ident) {
        Substitute subst = this.identSubst.get(ident);
        return subst == null ? null : subst.getSubstitute(ident, 0);
    }

    private Expression getOrSetDefault(FreeIdentifier ident) {
        Substitute subst = this.identSubst.get(ident);
        if (subst != null) {
            return subst.getSubstitute(ident, this.getBindingDepth());
        }
        Type type = ident.getType();
        Type newType = type.specialize(this);
        Expression result = newType == type ? super.rewrite(ident) : this.ff.makeFreeIdentifier(ident.getName(), ident.getSourceLocation(), newType);
        this.identSubst.put(ident, Substitute.makeSubstitute(result));
        return result;
    }

    @Override
    public Expression rewrite(FreeIdentifier identifier) {
        Expression newIdent = this.getOrSetDefault(identifier);
        if (newIdent.equals(identifier)) {
            return super.rewrite(identifier);
        }
        return newIdent;
    }

    @Override
    public BoundIdentDecl rewrite(BoundIdentDecl decl) {
        Type type = decl.getType();
        Type newType = type.specialize(this);
        if (newType == type) {
            return super.rewrite(decl);
        }
        String name = decl.getName();
        SourceLocation sloc = decl.getSourceLocation();
        return this.ff.makeBoundIdentDecl(name, sloc, newType);
    }

    @Override
    public Expression rewrite(BoundIdentifier identifier) {
        Type type = identifier.getType();
        Type newType = type.specialize(this);
        if (newType == type) {
            return super.rewrite(identifier);
        }
        return this.ff.makeBoundIdentifier(identifier.getBoundIndex(), identifier.getSourceLocation(), newType);
    }

    @Override
    public Expression rewrite(AtomicExpression expression) {
        Type type = expression.getType();
        Type newType = type.specialize(this);
        if (newType == type) {
            return super.rewrite(expression);
        }
        SourceLocation loc = expression.getSourceLocation();
        return this.ff.makeAtomicExpression(expression.getTag(), loc, newType);
    }

    @Override
    public Expression rewrite(ExtendedExpression expr, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
        Type type = expr.getType();
        Type newType = type.specialize(this);
        if (!changed && newType == type) {
            return super.rewrite(expr, changed, newChildExprs, newChildPreds);
        }
        IExpressionExtension extension = expr.getExtension();
        SourceLocation loc = expr.getSourceLocation();
        return this.ff.makeExtendedExpression(extension, newChildExprs, newChildPreds, loc, newType);
    }

    @Override
    public Expression rewrite(SetExtension src, SetExtension expr) {
        if (expr.getChildCount() != 0) {
            return expr;
        }
        Type type = expr.getType();
        Type newType = type.specialize(this);
        if (newType == type) {
            return super.rewrite(src, expr);
        }
        return this.ff.makeEmptySetExtension(newType, expr.getSourceLocation());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Map.Entry<GivenType, Type> entry : this.typeSubst.entrySet()) {
            sb.append(sep);
            sep = " || ";
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.identSubst.entrySet()) {
            sb.append(sep);
            sep = " || ";
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }
}

