/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.eventb.core.ast.IPosition;
import org.eventb.internal.core.ast.IntStack;

public final class Position
implements IPosition {
    private static final int[] NO_INTS = new int[0];
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    public final int[] indexes;

    public static IPosition getRoot() {
        return new Position();
    }

    private Position() {
        this.indexes = NO_INTS;
    }

    private Position(int[] indexes) {
        this.indexes = indexes;
    }

    public Position(IntStack stack) {
        this.indexes = stack.toArray();
    }

    public Position(String image) {
        if (image.length() == 0) {
            this.indexes = NO_INTS;
        } else {
            String[] components = DOT_PATTERN.split(image, -1);
            int length = components.length;
            this.indexes = new int[length];
            for (int i = 0; i < length; ++i) {
                try {
                    int idx = Integer.parseInt(components[i]);
                    if (idx < 0) {
                        throw new IllegalArgumentException("Negative index in position: " + image);
                    }
                    this.indexes[i] = idx;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid position: " + image);
                }
            }
        }
    }

    @Override
    public int compareTo(IPosition position) {
        Position other = (Position)position;
        int leftLen = this.indexes.length;
        int rightLen = other.indexes.length;
        int minLen = Math.min(leftLen, rightLen);
        for (int i = 0; i < minLen; ++i) {
            int diff = this.indexes[i] - other.indexes[i];
            if (diff == 0) continue;
            return diff;
        }
        return leftLen - rightLen;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        return Arrays.equals(this.indexes, other.indexes);
    }

    @Override
    public IPosition getParent() {
        int parentLength = this.indexes.length - 1;
        if (parentLength < 0) {
            throw new IllegalStateException("Root position has no parent");
        }
        int[] parentIndexes = new int[parentLength];
        System.arraycopy(this.indexes, 0, parentIndexes, 0, parentLength);
        return new Position(parentIndexes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.indexes);
    }

    @Override
    public boolean isRoot() {
        return this.indexes.length == 0;
    }

    @Override
    public String toString() {
        int length = this.indexes.length;
        if (length == 0) {
            return "";
        }
        if (length == 1) {
            return Integer.toString(this.indexes[0]);
        }
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (int index : this.indexes) {
            result.append(sep);
            sep = ".";
            result.append(index);
        }
        return result.toString();
    }

    @Override
    public Position getFirstChild() {
        return this.getChildAtIndex(0);
    }

    @Override
    public Position getNextSibling() {
        int lastIdx = this.indexes.length - 1;
        if (lastIdx < 0) {
            throw new IllegalStateException("Root position is not a sibling");
        }
        int[] newIndexes = (int[])this.indexes.clone();
        int n = lastIdx;
        newIndexes[n] = newIndexes[n] + 1;
        return new Position(newIndexes);
    }

    @Override
    public Position getPreviousSibling() {
        int lastIdx = this.indexes.length - 1;
        if (lastIdx < 0) {
            throw new IllegalStateException("Root position is not a sibling");
        }
        int[] newIndexes = (int[])this.indexes.clone();
        int n = lastIdx;
        newIndexes[n] = newIndexes[n] - 1;
        if (newIndexes[lastIdx] < 0) {
            throw new IllegalStateException("First child position has no previous sibling");
        }
        return new Position(newIndexes);
    }

    @Override
    public boolean isFirstChild() {
        int lastIdx = this.indexes.length - 1;
        if (lastIdx < 0) {
            return false;
        }
        return this.indexes[lastIdx] == 0;
    }

    @Override
    public Position getChildAtIndex(int n) {
        if (n < 0) {
            throw new IllegalStateException("Negative child index " + n);
        }
        int length = this.indexes.length;
        int[] childIndexes = new int[length + 1];
        System.arraycopy(this.indexes, 0, childIndexes, 0, length);
        childIndexes[length] = n;
        return new Position(childIndexes);
    }

    @Override
    public int getChildIndex() {
        int lastIdx = this.indexes.length - 1;
        if (lastIdx < 0) {
            throw new IllegalStateException("Root position has no child index");
        }
        return this.indexes[lastIdx];
    }
}

