/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ITypeEnvironment;

public class FreshNameSolver {
    private final FormulaFactory factory;
    private final ITypeEnvironment typeEnvironment;
    private final Set<String> usedNames;

    public FreshNameSolver(ITypeEnvironment typeEnvironment) {
        this.factory = typeEnvironment.getFormulaFactory();
        this.typeEnvironment = typeEnvironment;
        this.usedNames = null;
    }

    public FreshNameSolver(Set<String> usedNames, FormulaFactory factory) {
        this.factory = factory;
        this.usedNames = usedNames;
        this.typeEnvironment = null;
    }

    public String solve(String name) {
        String newName;
        if (this.isValid(name)) {
            return name;
        }
        StructuredName sname = new StructuredName(name);
        do {
            sname.increment();
        } while (!this.isValid(newName = sname.toString()));
        return newName;
    }

    public String solveAndAdd(String name) {
        if (this.typeEnvironment != null) {
            throw new UnsupportedOperationException("The context of name solving is ambiguous.");
        }
        String solvedName = this.solve(name);
        this.usedNames.add(solvedName);
        return solvedName;
    }

    private boolean isValid(String name) {
        if (!this.factory.isValidIdentifierName(name)) {
            return false;
        }
        if (this.typeEnvironment != null) {
            return !this.typeEnvironment.contains(name);
        }
        return !this.usedNames.contains(name);
    }

    private static class StructuredName {
        private final String prefix;
        private int suffix;
        private final String quotes;
        static Pattern suffixExtractor = Pattern.compile("^(.*[^\\d'])(\\d*)('*)$", 32);

        StructuredName(String name) {
            Matcher matcher = suffixExtractor.matcher(name);
            boolean result = matcher.matches();
            assert (result);
            this.prefix = matcher.group(1);
            String digits = matcher.group(2);
            this.suffix = digits.length() != 0 ? Integer.valueOf(digits) : -1;
            this.quotes = matcher.group(3);
        }

        public void increment() {
            ++this.suffix;
        }

        public String toString() {
            if (this.suffix < 0) {
                return this.prefix + this.quotes;
            }
            return this.prefix + this.suffix + this.quotes;
        }
    }
}

