/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.Collections;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.DefaultTypeCheckingRewriter;
import org.eventb.internal.core.ast.FreshNameSolver;

public class FormulaTranslator
extends DefaultTypeCheckingRewriter {
    private static final Set<String> NO_NAMES = Collections.emptySet();
    private final FreshNameSolver solver;

    public FormulaTranslator(FormulaFactory target) {
        super(target);
        this.solver = new FreshNameSolver(NO_NAMES, this.ff);
    }

    @Override
    public BoundIdentDecl rewrite(BoundIdentDecl src) {
        if (this.ff == src.getFactory()) {
            return src;
        }
        String name = this.solver.solve(src.getName());
        Type type = this.typeRewriter.rewrite(src.getType());
        SourceLocation sloc = src.getSourceLocation();
        return this.ff.makeBoundIdentDecl(name, sloc, type);
    }
}

