/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class IntegerLiteral
extends Expression {
    private final BigInteger literal;

    public static void init(AbstractGrammar grammar) {
        grammar.addReservedSubParser(AbstractGrammar.DefaultToken.INT_LIT, SubParsers.INTLIT_SUBPARSER);
    }

    protected IntegerLiteral(BigInteger literal, SourceLocation location, FormulaFactory ff) {
        super(4, ff, location, literal.hashCode());
        this.literal = literal;
        this.setPredicateVariableCache(new Formula[0]);
        this.synthesizeType(null);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        this.freeIdents = NO_FREE_IDENT;
        this.boundIdents = NO_BOUND_IDENT;
        this.setFinalType(this.getFactory().makeIntegerType(), givenType);
    }

    public BigInteger getValue() {
        return this.literal;
    }

    @Override
    protected void isLegible(LegibilityResult result) {
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        IntegerLiteral other = (IntegerLiteral)expr;
        return this.literal.equals(other.literal);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        this.setTemporaryType(result.makeIntegerType(), result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
    }

    @Override
    protected final void toString(IToStringMediator mediator) {
        SubParsers.INTLIT_SUBPARSER.toString(mediator, this);
    }

    @Override
    protected final int getKind(KindMediator mediator) {
        if (this.literal.signum() == -1) {
            return mediator.getNEGLIT();
        }
        return mediator.getINTLIT();
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String typeName = this.getType() != null ? " [type: " + this.getType().toString() + "]" : "";
        return tabs + this.getClass().getSimpleName() + " [literal: " + this.literal + "]" + typeName + "\n";
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visitINTLIT(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitIntegerLiteral(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        return rewriter.rewrite(this);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
    }

    @Override
    public Formula<?> getChild(int index) {
        throw IntegerLiteral.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        throw new IllegalArgumentException("Position is outside the formula");
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

