/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class BinaryPredicate
extends Predicate {
    private static final int FIRST_TAG = 251;
    private static final String LIMP_ID = "Logical Implication";
    private static final String LEQV_ID = "Equivalent";
    private final Predicate left;
    private final Predicate right;
    public static final int TAGS_LENGTH = Operators.values().length;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected BinaryPredicate(Predicate left, Predicate right, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, BinaryPredicate.combineHashCodes(left.hashCode(), right.hashCode()));
        this.left = left;
        this.right = right;
        FormulaChecks.ensureTagInRange(tag, 251, TAGS_LENGTH);
        this.ensureSameFactory(this.left, this.right);
        this.setPredicateVariableCache(this.left, this.right);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        IdentListMerger freeIdentMerger = IdentListMerger.makeMerger((Identifier[])this.left.freeIdents, (Identifier[])this.right.freeIdents);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = IdentListMerger.makeMerger((Identifier[])this.left.boundIdents, (Identifier[])this.right.boundIdents);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        if (this.left.isTypeChecked() && this.right.isTypeChecked()) {
            this.typeChecked = true;
        }
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 251];
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        BinaryPredicate other = (BinaryPredicate)formula;
        return this.left.equals(other.left) && this.right.equals(other.right);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        this.left.typeCheck(result, quantifiedIdentifiers);
        this.right.typeCheck(result, quantifiedIdentifiers);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        this.left.solveType(unifier);
        this.right.solveType(unifier);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]\n" + this.left.getSyntaxTree(boundNames, tabs + "\t") + this.right.getSyntaxTree(boundNames, tabs + "\t");
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        this.left.isLegible(result);
        this.right.isLegible(result);
    }

    public Predicate getLeft() {
        return this.left;
    }

    public Predicate getRight() {
        return this.right;
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        this.left.collectFreeIdentifiers(freeIdentSet);
        this.right.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        this.left.collectNamesAbove(names, boundNames, offset);
        this.right.collectNamesAbove(names, boundNames, offset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 251: {
                goOn = visitor.enterLIMP(this);
                break;
            }
            case 252: {
                goOn = visitor.enterLEQV(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (goOn) {
            goOn = this.left.accept(visitor);
        }
        if (goOn) {
            switch (this.getTag()) {
                case 251: {
                    goOn = visitor.continueLIMP(this);
                    break;
                }
                case 252: {
                    goOn = visitor.continueLEQV(this);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (goOn) {
            goOn = this.right.accept(visitor);
        }
        switch (this.getTag()) {
            case 251: {
                return visitor.exitLIMP(this);
            }
            case 252: {
                return visitor.exitLEQV(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBinaryPredicate(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        Predicate newLeft = (Predicate)this.left.rewrite(rewriter);
        Predicate newRight = (Predicate)this.right.rewrite(rewriter);
        BinaryPredicate before = newLeft == this.left && newRight == this.right ? this : rewriter.getFactory().makeBinaryPredicate(this.getTag(), newLeft, newRight, this.getSourceLocation());
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        this.left.inspect(acc);
        if (acc.allSkipped()) {
            return;
        }
        acc.nextChild();
        this.right.inspect(acc);
        acc.leaveChildren();
    }

    public Predicate getChild(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw BinaryPredicate.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        IPosition pos = this.left.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.incrementTop();
        pos = this.right.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        Predicate newLeft = this.left;
        Predicate newRight = this.right;
        switch (index) {
            case 0: {
                newLeft = rewriter.rewrite(this.left);
                break;
            }
            case 1: {
                newRight = rewriter.rewrite(this.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Position is outside the formula");
            }
        }
        return this.getFactory().makeBinaryPredicate(this.getTag(), newLeft, newRight, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return this.getTag() == 252;
    }

    private static enum Operators implements IOperatorInfo<BinaryPredicate>
    {
        OP_LIMP("\u21d2", "Logical Implication", StandardGroup.INFIX_PRED, 251),
        OP_LEQV("\u21d4", "Equivalent", StandardGroup.INFIX_PRED, 252);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<BinaryPredicate> makeParser(int kind) {
            return new SubParsers.BinaryPredicateParser(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

