/*
 * Decompiled with CFR 0.152.
 */
package de.prob.visualization;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Transformer {
    public static final List<String> STYLES = Arrays.asList("fill", "font", "stroke", "stroke-dasharray", "stroke-width");
    public String selector;
    public final List<Attribute> attributes;
    public final List<Style> styles;

    public Transformer(String selector) {
        this.selector = selector;
        this.attributes = new ArrayList<Attribute>();
        this.styles = new ArrayList<Style>();
    }

    private Transformer attr(String name, String value) {
        this.attributes.add(new Attribute(name, value));
        return this;
    }

    private Transformer style(String name, String value) {
        this.styles.add(new Style(name, value));
        return this;
    }

    public Transformer set(String name, String value) {
        if (STYLES.contains(name)) {
            return this.style(name, value);
        }
        return this.attr(name, value);
    }

    public String toString() {
        Gson g = new Gson();
        return g.toJson((Object)this);
    }

    public Transformer updateSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Style> getStyles() {
        return this.styles;
    }

    class Style {
        public final String name;
        public final String value;

        public Style(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    class Attribute {
        public final String name;
        public final String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

