/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.ActionItemList;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.CallStack;
import tlc2.tool.ContextEnumerator;
import tlc2.tool.EvalControl;
import tlc2.tool.EvalException;
import tlc2.tool.Spec;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateFun;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCStateMut;
import tlc2.tool.TLCStateMutSource;
import tlc2.tool.ToolGlobals;
import tlc2.tool.TraceApp;
import tlc2.util.Context;
import tlc2.util.Vect;
import tlc2.value.Applicable;
import tlc2.value.BoolValue;
import tlc2.value.Enumerable;
import tlc2.value.FcnLambdaValue;
import tlc2.value.FcnParams;
import tlc2.value.FcnRcdValue;
import tlc2.value.LazyValue;
import tlc2.value.MVPerm;
import tlc2.value.MethodValue;
import tlc2.value.OpLambdaValue;
import tlc2.value.OpValue;
import tlc2.value.RecordValue;
import tlc2.value.Reducible;
import tlc2.value.SetCapValue;
import tlc2.value.SetCupValue;
import tlc2.value.SetDiffValue;
import tlc2.value.SetEnumValue;
import tlc2.value.SetOfFcnsValue;
import tlc2.value.SetOfRcdsValue;
import tlc2.value.SetOfTuplesValue;
import tlc2.value.SetPredValue;
import tlc2.value.StringValue;
import tlc2.value.SubsetValue;
import tlc2.value.TupleValue;
import tlc2.value.UnionValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import tlc2.value.ValueVec;
import util.Assert;
import util.FilenameToStream;
import util.UniqueString;

public class Tool
extends Spec
implements ValueConstants,
ToolGlobals,
TraceApp {
    protected Action[] actions = null;
    private CallStack callStack = null;
    private Vect actionVec = new Vect(10);

    public Tool(String specDir, String specFile, String configFile, FilenameToStream resolver) {
        super(specDir, specFile, configFile, resolver);
    }

    public final SpecObj init(boolean preprocess, SpecObj spec) {
        SpecObj processSpec = super.processSpec(spec);
        if (TLCGlobals.coverageInterval >= 0) {
            TLCStateMutSource.init(this);
        } else {
            TLCStateMut.init(this);
        }
        if (preprocess) {
            this.processConstantDefns();
        }
        super.processConfig();
        return processSpec;
    }

    public final void setCallStack() {
        this.callStack = new CallStack();
    }

    public final CallStack getCallStack() {
        return this.callStack;
    }

    public final Action[] getActions() {
        if (this.actions == null) {
            Action next = this.getNextStateSpec();
            if (next == null) {
                this.actions = new Action[0];
            } else {
                this.getActions(next.pred, next.con);
                int sz = this.actionVec.size();
                this.actions = new Action[sz];
                for (int i = 0; i < sz; ++i) {
                    this.actions[i] = (Action)this.actionVec.elementAt(i);
                }
            }
        }
        return this.actions;
    }

    private final void getActions(SemanticNode next, Context con) {
        switch (next.getKind()) {
            case 9: {
                OpApplNode next1 = (OpApplNode)next;
                this.getActionsAppl(next1, con);
                return;
            }
            case 10: {
                LetInNode next1 = (LetInNode)next;
                this.getActions(next1.getBody(), con);
                return;
            }
            case 13: {
                SubstInNode next1 = (SubstInNode)next;
                Subst[] substs = next1.getSubsts();
                if (substs.length == 0) {
                    this.getActions(next1.getBody(), con);
                } else {
                    Action action = new Action(next1, con);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 30: {
                APSubstInNode next1 = (APSubstInNode)next;
                Subst[] substs = next1.getSubsts();
                if (substs.length == 0) {
                    this.getActions(next1.getBody(), con);
                } else {
                    Action action = new Action(next1, con);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 29: {
                LabelNode next1 = (LabelNode)next;
                this.getActions(next1.getBody(), con);
                return;
            }
        }
        Assert.fail("The next state relation is not a boolean expression.\n" + next);
    }

    private final void getActionsAppl(OpApplNode next, Context con) {
        ExprOrOpArgNode[] args = next.getArgs();
        SymbolNode opNode = next.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            OpDefNode opDef;
            Object val = this.lookup(opNode, con, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                try {
                    FormalParamNode[] formals = opDef.getParams();
                    int alen = args.length;
                    int argLevel = 0;
                    for (int i = 0; i < alen && (argLevel = args[i].getLevel()) == 0; ++i) {
                    }
                    if (argLevel == 0) {
                        Context con1 = con;
                        for (int i = 0; i < alen; ++i) {
                            Value aval = this.eval(args[i], con, TLCState.Empty);
                            con1 = con1.cons(formals[i], aval);
                        }
                        this.getActions(opDef.getBody(), con1);
                        return;
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (opcode == 0) {
                Action action = new Action(next, con);
                this.actionVec.addElement(action);
                return;
            }
        }
        switch (opcode) {
            case 2: {
                int cnt = this.actionVec.size();
                try {
                    Context econ;
                    ContextEnumerator Enum2 = this.contexts(next, con, TLCState.Empty, TLCState.Empty, 0);
                    while ((econ = Enum2.nextElement()) != null) {
                        this.getActions(args[0], econ);
                    }
                }
                catch (Throwable e) {
                    Action action = new Action(next, con);
                    this.actionVec.removeAll(cnt);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 7: 
            case 37: {
                for (int i = 0; i < args.length; ++i) {
                    this.getActions(args[i], con);
                }
                return;
            }
        }
        Action action = new Action(next, con);
        this.actionVec.addElement(action);
    }

    public final StateVec getInitStates() {
        Vect init = this.getInitStateSpec();
        ActionItemList acts = ActionItemList.Empty;
        StateVec initStates = new StateVec(0);
        for (int i = 1; i < init.size(); ++i) {
            Action elem = (Action)init.elementAt(i);
            acts = acts.cons(elem.pred, elem.con, -1);
        }
        if (init.size() != 0) {
            Action elem = (Action)init.elementAt(0);
            TLCState ps = TLCState.Empty.createEmpty();
            this.getInitStates(elem.pred, acts, elem.con, ps, initStates);
        }
        return initStates;
    }

    public final TLCState makeState(SemanticNode pred) {
        TLCState state;
        ActionItemList acts = ActionItemList.Empty;
        TLCState ps = TLCState.Empty.createEmpty();
        StateVec states = new StateVec(0);
        this.getInitStates(pred, acts, Context.Empty, ps, states);
        if (states.size() != 1) {
            Assert.fail("The predicate does not specify a unique state." + pred);
        }
        if (!this.isGoodState(state = states.elementAt(0))) {
            Assert.fail("The state specified by the predicate is not complete." + pred);
        }
        return state;
    }

    private final void getInitStates(SemanticNode init, ActionItemList acts, Context c, TLCState ps, StateVec states) {
        switch (init.getKind()) {
            case 9: {
                OpApplNode init1 = (OpApplNode)init;
                this.getInitStatesAppl(init1, acts, c, ps, states);
                return;
            }
            case 10: {
                LetInNode init1 = (LetInNode)init;
                this.getInitStates(init1.getBody(), acts, c, ps, states);
                return;
            }
            case 13: {
                SubstInNode init1 = (SubstInNode)init;
                Subst[] subs = init1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false));
                }
                this.getInitStates(init1.getBody(), acts, c1, ps, states);
                return;
            }
            case 30: {
                APSubstInNode init1 = (APSubstInNode)init;
                Subst[] subs = init1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false));
                }
                this.getInitStates(init1.getBody(), acts, c1, ps, states);
                return;
            }
            case 29: {
                LabelNode init1 = (LabelNode)init;
                this.getInitStates(init1.getBody(), acts, c, ps, states);
                return;
            }
        }
        Assert.fail("The init state relation is not a boolean expression.\n" + init);
    }

    private final void getInitStates(ActionItemList acts, TLCState ps, StateVec states) {
        if (acts.isEmpty()) {
            states.addElement(ps.copy());
        } else {
            ActionItemList acts1 = acts.cdr();
            this.getInitStates(acts.carPred(), acts1, acts.carContext(), ps, states);
        }
    }

    private final void getInitStatesAppl(OpApplNode init, ActionItemList acts, Context c, TLCState ps, StateVec states) {
        Object bval;
        ExprOrOpArgNode[] args = init.getArgs();
        int alen = args.length;
        SymbolNode opNode = init.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, ps, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true);
                this.getInitStates(((OpDefNode)opDef).getBody(), acts, c1, ps, states);
                return;
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                this.getInitStates(((ThmOrAssumpDefNode)opDef).getBody(), acts, c1, ps, states);
                return;
            }
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                if (lv.val == null || lv.val == ValUndef) {
                    this.getInitStates(lv.expr, acts, lv.con, ps, states);
                    return;
                }
                val = lv.val;
            }
            bval = val;
            if (alen == 0) {
                if (val instanceof MethodValue) {
                    bval = ((MethodValue)val).apply(EmptyArgs, 0);
                }
            } else if (val instanceof OpValue) {
                Applicable opVal = (Applicable)val;
                Value[] argVals = new Value[alen];
                for (int i = 0; i < alen; ++i) {
                    argVals[i] = this.eval(args[i], c, ps);
                }
                bval = opVal.apply(argVals, 0);
            }
            if (opcode == 0) {
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"initial states", "boolean", bval.toString(), init.toString()});
                }
                if (((BoolValue)bval).val) {
                    this.getInitStates(acts, ps, states);
                }
                return;
            }
        }
        switch (opcode) {
            case 7: 
            case 37: {
                for (int i = 0; i < alen; ++i) {
                    this.getInitStates(args[i], acts, c, ps, states);
                }
                return;
            }
            case 6: 
            case 36: {
                for (int i = alen - 1; i > 0; --i) {
                    acts = acts.cons(args[i], c, i);
                }
                this.getInitStates(args[0], acts, c, ps, states);
                return;
            }
            case 2: {
                Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(init, c, ps, TLCState.Empty, 0);
                while ((c1 = Enum2.nextElement()) != null) {
                    this.getInitStates(body, acts, c1, ps, states);
                }
                return;
            }
            case 3: {
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(init, c, ps, TLCState.Empty, 0);
                Context c1 = Enum2.nextElement();
                if (c1 == null) {
                    this.getInitStates(acts, ps, states);
                } else {
                    Context c2;
                    ActionItemList acts1 = acts;
                    while ((c2 = Enum2.nextElement()) != null) {
                        acts1 = acts1.cons(body, c2, -1);
                    }
                    this.getInitStates(body, acts1, c1, ps, states);
                }
                return;
            }
            case 11: {
                Value guard = this.eval(args[0], c, ps);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing initial states, a non-boolean expression (" + guard.getKindString() + ") was used as the condition " + "of an IF.\n" + init);
                }
                int idx = ((BoolValue)guard).val ? 1 : 2;
                this.getInitStates(args[idx], acts, c, ps, states);
                return;
            }
            case 4: {
                ExprOrOpArgNode other = null;
                for (int i = 0; i < alen; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        continue;
                    }
                    Value bval2 = this.eval(pairArgs[0], c, ps);
                    if (!(bval2 instanceof BoolValue)) {
                        Assert.fail("In computing initial states, a non-boolean expression (" + bval2.getKindString() + ") was used as a guard condition" + " of a CASE.\n" + pairArgs[1]);
                    }
                    if (!((BoolValue)bval2).val) continue;
                    this.getInitStates(pairArgs[1], acts, c, ps, states);
                    return;
                }
                if (other == null) {
                    Assert.fail("In computing initial states, TLC encountered a CASE with no conditions true.\n" + init);
                }
                this.getInitStates(other, acts, c, ps, states);
                return;
            }
            case 9: {
                Applicable fcn;
                Context c1;
                Value fval = this.eval(args[0], c, ps);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        c1 = this.getFcnContext((FcnLambdaValue)fcn, args, c, ps, TLCState.Empty, 0);
                        this.getInitStates(((FcnLambdaValue)fcn).body, acts, c1, ps, states);
                        return;
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                } else if (!(fval instanceof Applicable)) {
                    Assert.fail("In computing initial states, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + init);
                }
                fcn = (Applicable)((Object)fval);
                Value argVal = this.eval(args[1], c, ps);
                Value bval3 = fcn.apply(argVal, 0);
                if (!(bval3 instanceof BoolValue)) {
                    Assert.fail(2248, new String[]{"initial states", "boolean", init.toString()});
                }
                if (((BoolValue)bval3).val) {
                    this.getInitStates(acts, ps, states);
                }
                return;
            }
            case 35: {
                Value rval;
                Value lval;
                UniqueString varName;
                SymbolNode var = this.getVar(args[0], c, false);
                if (var == null || var.getName().getVarLoc() < 0) {
                    bval = this.eval(init, c, ps);
                    if (!((BoolValue)bval).val) {
                        return;
                    }
                } else {
                    varName = var.getName();
                    lval = ps.lookup(varName);
                    rval = this.eval(args[1], c, ps);
                    if (lval == null) {
                        ps = ps.bind(varName, rval, (SemanticNode)init);
                        this.getInitStates(acts, ps, states);
                        ps.unbind(varName);
                        return;
                    }
                    if (!lval.equals(rval)) {
                        return;
                    }
                }
                this.getInitStates(acts, ps, states);
                return;
            }
            case 42: {
                Value rval;
                Value lval;
                UniqueString varName;
                SymbolNode var = this.getVar(args[0], c, false);
                if (var == null || var.getName().getVarLoc() < 0) {
                    bval = this.eval(init, c, ps);
                    if (!((BoolValue)bval).val) {
                        return;
                    }
                } else {
                    varName = var.getName();
                    lval = ps.lookup(varName);
                    rval = this.eval(args[1], c, ps);
                    if (lval == null) {
                        Value elem;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("In computing initial states, the right side of \\IN is not enumerable.\n" + init);
                        }
                        ValueEnumeration Enum3 = ((Enumerable)((Object)rval)).elements();
                        while ((elem = Enum3.nextElement()) != null) {
                            ps.bind(varName, elem, (SemanticNode)init);
                            this.getInitStates(acts, ps, states);
                            ps.unbind(varName);
                        }
                        return;
                    }
                    if (!rval.member(lval)) {
                        return;
                    }
                }
                this.getInitStates(acts, ps, states);
                return;
            }
            case 38: {
                Value lval = this.eval(args[0], c, ps);
                if (!(lval instanceof BoolValue)) {
                    Assert.fail("In computing initial states of a predicate of form P => Q, P was " + lval.getKindString() + "\n." + init);
                }
                if (((BoolValue)lval).val) {
                    this.getInitStates(args[1], acts, c, ps, states);
                } else {
                    this.getInitStates(acts, ps, states);
                }
                return;
            }
            case 46: {
                this.getInitStates(args[0], acts, c, ps, states);
                return;
            }
        }
        Value bval4 = this.eval(init, c, ps);
        if (!(bval4 instanceof BoolValue)) {
            Assert.fail("In computing initial states, TLC expected a boolean expression,\nbut instead found " + bval4 + ".\n" + init);
        }
        if (((BoolValue)bval4).val) {
            this.getInitStates(acts, ps, states);
        }
    }

    public final StateVec getNextStates(Action action, TLCState state) {
        ActionItemList acts = ActionItemList.Empty;
        TLCState s1 = TLCState.Empty.createEmpty();
        StateVec nss = new StateVec(0);
        this.getNextStates(action.pred, acts, action.con, state, s1, nss);
        return nss;
    }

    private final TLCState getNextStates(SemanticNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, StateVec nss) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                return this.getNextStatesAppl(pred1, acts, c, s0, s1, nss);
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                return this.getNextStates(pred1.getBody(), acts, c, s0, s1, nss);
            }
            case 13: {
                SubstInNode pred1 = (SubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false));
                }
                return this.getNextStates(pred1.getBody(), acts, c1, s0, s1, nss);
            }
            case 30: {
                APSubstInNode pred1 = (APSubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false));
                }
                return this.getNextStates(pred1.getBody(), acts, c1, s0, s1, nss);
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                return this.getNextStates(pred1.getBody(), acts, c, s0, s1, nss);
            }
        }
        Assert.fail("The next state relation is not a boolean expression.\n" + pred);
        return s1;
    }

    private final TLCState getNextStates(ActionItemList acts, TLCState s0, TLCState s1, StateVec nss) {
        TLCState resState = s1;
        if (acts.isEmpty()) {
            nss.addElement(s1);
            resState = s1.copy();
        } else {
            int kind = acts.carKind();
            SemanticNode pred = acts.carPred();
            Context c = acts.carContext();
            ActionItemList acts1 = acts.cdr();
            if (kind > 0) {
                if (this.callStack != null) {
                    this.callStack.push(pred);
                }
                resState = this.getNextStates(pred, acts1, c, s0, s1, nss);
                if (this.callStack != null) {
                    this.callStack.pop();
                }
            } else if (kind == -1) {
                resState = this.getNextStates(pred, acts1, c, s0, s1, nss);
            } else if (kind == -2) {
                resState = this.processUnchanged(pred, acts1, c, s0, s1, nss);
            } else {
                Value v2;
                Value v1 = this.eval(pred, c, s0);
                if (!v1.equals(v2 = this.eval(pred, c, s1))) {
                    resState = this.getNextStates(acts1, s0, s1, nss);
                }
            }
        }
        return resState;
    }

    private final TLCState getNextStatesAppl(OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, StateVec nss) {
        Object bval;
        ExprOrOpArgNode[] args = pred.getArgs();
        int alen = args.length;
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, s0, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true);
                return this.getNextStates(((OpDefNode)opDef).getBody(), acts, c1, s0, s1, nss);
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                return this.getNextStates(((ThmOrAssumpDefNode)opDef).getBody(), acts, c1, s0, s1, nss);
            }
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                if (lv.val == null || lv.val == ValUndef) {
                    return this.getNextStates(lv.expr, acts, lv.con, s0, s1, nss);
                }
                val = lv.val;
            }
            bval = val;
            if (alen == 0) {
                if (val instanceof MethodValue) {
                    bval = ((MethodValue)val).apply(EmptyArgs, 0);
                }
            } else if (val instanceof OpValue) {
                Applicable opVal = (Applicable)val;
                Value[] argVals = new Value[alen];
                for (int i = 0; i < alen; ++i) {
                    argVals[i] = this.eval(args[i], c, s0, s1, 0);
                }
                bval = opVal.apply(argVals, 0);
            }
            if (opcode == 0) {
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"next states", "boolean", bval.toString(), pred.toString()});
                }
                if (((BoolValue)bval).val) {
                    return this.getNextStates(acts, s0, s1, nss);
                }
                return s1;
            }
        }
        TLCState resState = s1;
        switch (opcode) {
            case 6: 
            case 36: {
                ActionItemList acts1 = acts;
                for (int i = alen - 1; i > 0; --i) {
                    acts1 = acts1.cons(args[i], c, i);
                }
                if (this.callStack != null) {
                    this.callStack.push(args[0]);
                }
                resState = this.getNextStates(args[0], acts1, c, s0, s1, nss);
                if (this.callStack != null) {
                    this.callStack.pop();
                }
                return resState;
            }
            case 7: 
            case 37: {
                for (int i = 0; i < alen; ++i) {
                    if (this.callStack != null) {
                        this.callStack.push(args[i]);
                    }
                    resState = this.getNextStates(args[i], acts, c, s0, resState, nss);
                    if (this.callStack == null) continue;
                    this.callStack.pop();
                }
                return resState;
            }
            case 2: {
                Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 0);
                while ((c1 = Enum2.nextElement()) != null) {
                    resState = this.getNextStates(body, acts, c1, s0, resState, nss);
                }
                return resState;
            }
            case 3: {
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 0);
                Context c1 = Enum2.nextElement();
                if (c1 == null) {
                    resState = this.getNextStates(acts, s0, s1, nss);
                } else {
                    Context c2;
                    ActionItemList acts1 = acts;
                    while ((c2 = Enum2.nextElement()) != null) {
                        acts1 = acts1.cons(body, c2, -1);
                    }
                    resState = this.getNextStates(body, acts1, c1, s0, s1, nss);
                }
                return resState;
            }
            case 9: {
                Value argVal;
                Value bval2;
                Applicable fcn;
                Context c1;
                Value fval = this.eval(args[0], c, s0, s1, 1);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        c1 = this.getFcnContext((FcnLambdaValue)fcn, args, c, s0, s1, 0);
                        return this.getNextStates(((FcnLambdaValue)fcn).body, acts, c1, s0, s1, nss);
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                }
                if (!(fval instanceof Applicable)) {
                    Assert.fail("In computing next states, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + pred);
                }
                if (!((bval2 = (fcn = (Applicable)((Object)fval)).apply(argVal = this.eval(args[1], c, s0, s1, 0), 0)) instanceof BoolValue)) {
                    Assert.fail(2248, new String[]{"next states", "boolean", pred.toString()});
                }
                if (((BoolValue)bval2).val) {
                    return this.getNextStates(acts, s0, s1, nss);
                }
                return resState;
            }
            case 50: {
                ActionItemList acts1 = acts.cons(args[1], c, -3);
                return this.getNextStates(args[0], acts1, c, s0, s1, nss);
            }
            case 51: {
                resState = this.getNextStates(args[0], acts, c, s0, resState, nss);
                return this.processUnchanged(args[1], acts, c, s0, resState, nss);
            }
            case 11: {
                Value guard = this.eval(args[0], c, s0, s1, 0);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing next states, a non-boolean expression (" + guard.getKindString() + ") was used as the condition of" + " an IF." + pred);
                }
                if (((BoolValue)guard).val) {
                    return this.getNextStates(args[1], acts, c, s0, s1, nss);
                }
                return this.getNextStates(args[2], acts, c, s0, s1, nss);
            }
            case 4: {
                ExprOrOpArgNode other = null;
                for (int i = 0; i < alen; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        continue;
                    }
                    Value bval3 = this.eval(pairArgs[0], c, s0, s1, 0);
                    if (!(bval3 instanceof BoolValue)) {
                        Assert.fail("In computing next states, a non-boolean expression (" + bval3.getKindString() + ") was used as a guard condition" + " of a CASE.\n" + pairArgs[1]);
                    }
                    if (!((BoolValue)bval3).val) continue;
                    return this.getNextStates(pairArgs[1], acts, c, s0, s1, nss);
                }
                if (other == null) {
                    Assert.fail("In computing next states, TLC encountered a CASE with no conditions true.\n" + pred);
                }
                return this.getNextStates(other, acts, c, s0, s1, nss);
            }
            case 35: {
                Value lval;
                UniqueString varName;
                Value bval4;
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null) {
                    bval4 = this.eval(pred, c, s0, s1, 0);
                    if (!((BoolValue)bval4).val) {
                        return resState;
                    }
                } else {
                    varName = var.getName();
                    lval = s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 0);
                    if (lval == null) {
                        resState.bind(varName, rval, (SemanticNode)pred);
                        resState = this.getNextStates(acts, s0, resState, nss);
                        resState.unbind(varName);
                        return resState;
                    }
                    if (!lval.equals(rval)) {
                        return resState;
                    }
                }
                return this.getNextStates(acts, s0, s1, nss);
            }
            case 42: {
                Value lval;
                UniqueString varName;
                Value bval4;
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null) {
                    bval4 = this.eval(pred, c, s0, s1, 0);
                    if (!((BoolValue)bval4).val) {
                        return resState;
                    }
                } else {
                    varName = var.getName();
                    lval = s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 0);
                    if (lval == null) {
                        Value elem;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("In computing next states, the right side of \\IN is not enumerable.\n" + pred);
                        }
                        ValueEnumeration Enum3 = ((Enumerable)((Object)rval)).elements();
                        while ((elem = Enum3.nextElement()) != null) {
                            resState.bind(varName, elem, (SemanticNode)pred);
                            resState = this.getNextStates(acts, s0, resState, nss);
                            resState.unbind(varName);
                        }
                        return resState;
                    }
                    if (!rval.member(lval)) {
                        return resState;
                    }
                }
                return this.getNextStates(acts, s0, s1, nss);
            }
            case 38: {
                bval = this.eval(args[0], c, s0, s1, 0);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("In computing next states of a predicate of the form P => Q, P was\n" + ((Value)bval).getKindString() + ".\n" + pred);
                }
                if (((BoolValue)bval).val) {
                    return this.getNextStates(args[1], acts, c, s0, s1, nss);
                }
                return this.getNextStates(acts, s0, s1, nss);
            }
            case 49: {
                return this.processUnchanged(args[0], acts, c, s0, s1, nss);
            }
            case 52: {
                Assert.fail("The current version of TLC does not support action composition.");
                return s1;
            }
            case 46: {
                return this.getNextStates(args[0], acts, c, s0, s1, nss);
            }
        }
        bval = this.eval(pred, c, s0, s1, 0);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"next states", "boolean", ((Value)bval).toString(), pred.toString()});
        }
        if (((BoolValue)bval).val) {
            resState = this.getNextStates(acts, s0, s1, nss);
        }
        return resState;
    }

    private final TLCState processUnchanged(SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, StateVec nss) {
        Value v1;
        Value v0;
        SymbolNode var = this.getVar(expr, c, false);
        TLCState resState = s1;
        if (var != null) {
            UniqueString varName = var.getName();
            Value val0 = s0.lookup(varName);
            Value val1 = s1.lookup(varName);
            if (val1 == null) {
                resState.bind(varName, val0, expr);
                resState = this.getNextStates(acts, s0, resState, nss);
                resState.unbind(varName);
            } else if (val0.equals(val1)) {
                resState = this.getNextStates(acts, s0, s1, nss);
            } else {
                MP.printWarning(2143, new String[]{varName.toString(), expr.toString()});
            }
            return resState;
        }
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            ExprOrOpArgNode[] args = expr1.getArgs();
            int alen = args.length;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opcode == 23) {
                if (alen != 0) {
                    ActionItemList acts1 = acts;
                    for (int i = alen - 1; i > 0; --i) {
                        acts1 = acts1.cons(args[i], c, -2);
                    }
                    return this.processUnchanged(args[0], acts1, c, s0, s1, nss);
                }
                return this.getNextStates(acts, s0, s1, nss);
            }
            if (opcode == 0 && alen == 0) {
                Object val = this.lookup(opNode, c, false);
                if (val instanceof OpDefNode) {
                    return this.processUnchanged(((OpDefNode)val).getBody(), acts, c, s0, s1, nss);
                }
                if (val instanceof LazyValue) {
                    LazyValue lv = (LazyValue)val;
                    return this.processUnchanged(lv.expr, acts, lv.con, s0, s1, nss);
                }
                Assert.fail("In computing next states, TLC found the identifier\n" + opName + " undefined in an UNCHANGED expression at\n" + expr);
                return this.getNextStates(acts, s0, s1, nss);
            }
        }
        if ((v0 = this.eval(expr, c, s0)).equals(v1 = this.eval(expr, c, s1, null, 0))) {
            resState = this.getNextStates(acts, s0, s1, nss);
        }
        return resState;
    }

    public final Value eval(SemanticNode expr, Context c, TLCState s0) {
        return this.eval(expr, c, s0, TLCState.Empty, 0);
    }

    public final Value eval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control) {
        switch (expr.getKind()) {
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                return this.eval(expr1.getBody(), c, s0, s1, control);
            }
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                return this.evalAppl(expr1, c, s0, s1, control);
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                OpDefNode[] letDefs = expr1.getLets();
                int letLen = letDefs.length;
                Context c1 = c;
                for (int i = 0; i < letLen; ++i) {
                    OpDefNode opDef = letDefs[i];
                    if (opDef.getArity() != 0) continue;
                    LazyValue rhs = new LazyValue(opDef.getBody(), c1);
                    c1 = c1.cons(opDef, rhs);
                }
                return this.eval(expr1.getBody(), c1, s0, s1, control);
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true));
                }
                return this.eval(expr1.getBody(), c1, s0, s1, control);
            }
            case 30: {
                APSubstInNode expr1 = (APSubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true));
                }
                return this.eval(expr1.getBody(), c1, s0, s1, control);
            }
            case 16: 
            case 17: 
            case 18: {
                return Value.getValue(expr);
            }
            case 19: {
                return (Value)c.lookup(EXCEPT_AT);
            }
            case 8: {
                OpArgNode expr1 = (OpArgNode)expr;
                SymbolNode opNode = expr1.getOp();
                Object val = this.lookup(opNode, c, false);
                if (val instanceof OpDefNode) {
                    return new OpLambdaValue((OpDefNode)val, this, c, s0, s1);
                }
                return (Value)val;
            }
        }
        Assert.fail("Attempted to evaluate an expression that cannot be evaluated.\n" + expr);
        return null;
    }

    public final Value evalAppl(OpApplNode expr, Context c, TLCState s0, TLCState s1, int control) {
        int i;
        Context c1;
        ExprOrOpArgNode[] args = expr.getArgs();
        SymbolNode opNode = expr.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            Object val;
            if (this.callStack != null) {
                this.callStack.push(expr);
            }
            if ((val = this.lookup(opNode, c, s0, EvalControl.isPrimed(control))) instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                if (s1 == null || lv.val == ValUndef || EvalControl.isEnabled(control)) {
                    val = this.eval(lv.expr, lv.con, s0, s1, control);
                } else {
                    if (lv.val == null) {
                        lv.val = this.eval(lv.expr, lv.con, s0, s1, control);
                    }
                    val = lv.val;
                }
            }
            Value res = null;
            if (val instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                if (opcode == 0) {
                    c1 = this.getOpContext(opDef, args, c, true);
                    res = this.eval(opDef.getBody(), c1, s0, s1, control);
                }
            } else if (val instanceof Value) {
                res = (Value)val;
                int alen = args.length;
                if (alen == 0) {
                    if (val instanceof MethodValue) {
                        res = ((MethodValue)val).apply(EmptyArgs, 0);
                    }
                } else if (val instanceof OpValue) {
                    Applicable opVal = (Applicable)val;
                    Value[] argVals = new Value[alen];
                    for (i = 0; i < alen; ++i) {
                        argVals[i] = this.eval(args[i], c, s0, s1, control);
                    }
                    res = opVal.apply(argVals, control);
                }
            } else {
                if (val instanceof ThmOrAssumpDefNode) {
                    ThmOrAssumpDefNode opDef = (ThmOrAssumpDefNode)val;
                    Context c12 = this.getOpContext(opDef, args, c, true);
                    return this.eval(opDef.getBody(), c12, s0, s1, control);
                }
                Assert.fail("In evaluation, the identifier " + opNode.getName() + " is either" + " undefined or not an operator.\n" + expr);
            }
            if (this.callStack != null) {
                this.callStack.pop();
            }
            if (opcode == 0) {
                return res;
            }
        }
        switch (opcode) {
            case 1: {
                SetEnumValue convertedVal;
                ExprOrOpArgNode pred = args[0];
                ExprNode inExpr = expr.getBdedQuantBounds()[0];
                Value inVal = this.eval(inExpr, c, s0, s1, control);
                if (!(inVal instanceof Enumerable)) {
                    Assert.fail("Attempted to compute the value of an expression of\nform CHOOSE x \\in S: P, but S was not enumerable.\n" + expr);
                }
                if ((convertedVal = SetEnumValue.convert(inVal)) != null) {
                    inVal = convertedVal;
                } else {
                    inVal.normalize();
                }
                ValueEnumeration enumSet = ((Enumerable)((Object)inVal)).elements();
                FormalParamNode[] bvars = expr.getBdedQuantSymbolLists()[0];
                boolean isTuple = expr.isBdedQuantATuple()[0];
                if (isTuple) {
                    Value val;
                    int cnt = bvars.length;
                    while ((val = enumSet.nextElement()) != null) {
                        TupleValue tv = TupleValue.convert(val);
                        if (tv == null || tv.size() != cnt) {
                            Assert.fail("Attempted to compute the value of an expression of form\nCHOOSE <<x1, ... , xN>> \\in S: P, but S was not a set\nof N-tuples.\n" + expr);
                        }
                        Context c13 = c;
                        for (int i2 = 0; i2 < cnt; ++i2) {
                            c13 = c13.cons(bvars[i2], tv.elems[i2]);
                        }
                        Value bval = this.eval(pred, c13, s0, s1, control);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail(2215, new String[]{"boolean", expr.toString()});
                        }
                        if (!((BoolValue)bval).val) continue;
                        return val;
                    }
                } else {
                    Value val;
                    FormalParamNode name = bvars[0];
                    while ((val = enumSet.nextElement()) != null) {
                        Context c14 = c.cons(name, val);
                        Value bval = this.eval(pred, c14, s0, s1, control);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail(2215, new String[]{"boolean", expr.toString()});
                        }
                        if (!((BoolValue)bval).val) continue;
                        return val;
                    }
                }
                Assert.fail("Attempted to compute the value of an expression of form\nCHOOSE x \\in S: P, but no element of S satisfied P.\n" + expr);
                return null;
            }
            case 2: {
                Value bval;
                Context c15;
                ContextEnumerator Enum2 = this.contexts(expr, c, s0, s1, control);
                ExprOrOpArgNode body = args[0];
                while ((c15 = Enum2.nextElement()) != null) {
                    bval = this.eval(body, c15, s0, s1, control);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail(2215, new String[]{"boolean", expr.toString()});
                    }
                    if (!((BoolValue)bval).val) continue;
                    return ValTrue;
                }
                return ValFalse;
            }
            case 3: {
                Value bval;
                Context c15;
                ContextEnumerator Enum2 = this.contexts(expr, c, s0, s1, control);
                ExprOrOpArgNode body = args[0];
                while ((c15 = Enum2.nextElement()) != null) {
                    bval = this.eval(body, c15, s0, s1, control);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail(2215, new String[]{"boolean", expr.toString()});
                    }
                    if (((BoolValue)bval).val) continue;
                    return ValFalse;
                }
                return ValTrue;
            }
            case 4: {
                ExprOrOpArgNode[] pairArgs;
                OpApplNode pairNode;
                int alen = args.length;
                ExprOrOpArgNode other = null;
                for (int i3 = 0; i3 < alen; ++i3) {
                    pairNode = (OpApplNode)args[i3];
                    pairArgs = pairNode.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        continue;
                    }
                    Value bval = this.eval(pairArgs[0], c, s0, s1, control);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a condition of a CASE. " + pairArgs[0]);
                    }
                    if (!((BoolValue)bval).val) continue;
                    return this.eval(pairArgs[1], c, s0, s1, control);
                }
                if (other == null) {
                    Assert.fail("Attempted to evaluate a CASE with no conditions true.\n" + expr);
                }
                return this.eval(other, c, s0, s1, control);
            }
            case 5: {
                int alen = args.length;
                Value[] sets = new Value[alen];
                for (int i4 = 0; i4 < alen; ++i4) {
                    sets[i4] = this.eval(args[i4], c, s0, s1, control);
                }
                return new SetOfTuplesValue(sets);
            }
            case 6: {
                Value bval;
                int alen = args.length;
                for (int i5 = 0; i5 < alen; ++i5) {
                    if (this.callStack != null) {
                        this.callStack.push(args[i5]);
                    }
                    if (!((bval = this.eval(args[i5], c, s0, s1, control)) instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a formula in a conjunction.\n" + args[i5]);
                    }
                    if (this.callStack != null) {
                        this.callStack.pop();
                    }
                    if (((BoolValue)bval).val) continue;
                    return ValFalse;
                }
                return ValTrue;
            }
            case 7: {
                Value bval;
                int alen = args.length;
                for (int i6 = 0; i6 < alen; ++i6) {
                    if (this.callStack != null) {
                        this.callStack.push(args[i6]);
                    }
                    if (!((bval = this.eval(args[i6], c, s0, s1, control)) instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a formula in a disjunction.\n" + args[i6]);
                    }
                    if (this.callStack != null) {
                        this.callStack.pop();
                    }
                    if (!((BoolValue)bval).val) continue;
                    return ValTrue;
                }
                return ValFalse;
            }
            case 8: {
                ExprOrOpArgNode[] pairArgs;
                OpApplNode pairNode;
                int alen = args.length;
                Value result = this.eval(args[0], c, s0, s1, control);
                for (int i7 = 1; i7 < alen; ++i7) {
                    pairNode = (OpApplNode)args[i7];
                    pairArgs = pairNode.getArgs();
                    ExprOrOpArgNode[] cmpts = ((OpApplNode)pairArgs[0]).getArgs();
                    Value[] lhs = new Value[cmpts.length];
                    for (int j = 0; j < lhs.length; ++j) {
                        lhs[j] = this.eval(cmpts[j], c, s0, s1, control);
                    }
                    Value atVal = result.select(lhs);
                    if (atVal == null) {
                        MP.printWarning(2144, new String[]{args[0].toString()});
                        continue;
                    }
                    Context c16 = c.cons(EXCEPT_AT, atVal);
                    Value rhs = this.eval(pairArgs[1], c16, s0, s1, control);
                    ValueExcept vex = new ValueExcept(lhs, rhs);
                    result = result.takeExcept(vex);
                }
                return result;
            }
            case 9: {
                Applicable fcn;
                Value fval;
                Value result = null;
                if (this.callStack != null) {
                    this.callStack.push(expr);
                }
                if ((fval = this.eval(args[0], c, s0, s1, EvalControl.setKeepLazy(control))) instanceof FcnRcdValue || fval instanceof FcnLambdaValue) {
                    fcn = (Applicable)((Object)fval);
                    Value argVal = this.eval(args[1], c, s0, s1, control);
                    result = fcn.apply(argVal, control);
                } else if (fval instanceof TupleValue || fval instanceof RecordValue) {
                    fcn = (Applicable)((Object)fval);
                    if (args.length != 2) {
                        Assert.fail("Attempted to evaluate an expression of form f[e1, ... , eN]\nwith f a tuple or record and N > 1.\n" + expr);
                    }
                    Value aval = this.eval(args[1], c, s0, s1, control);
                    result = fcn.apply(aval, control);
                } else {
                    Assert.fail("A non-function (" + fval.getKindString() + ") was applied" + " as a function.\n" + expr);
                }
                if (this.callStack != null) {
                    this.callStack.pop();
                }
                return result;
            }
            case 10: 
            case 12: 
            case 16: {
                FormalParamNode[][] formals = expr.getBdedQuantSymbolLists();
                boolean[] isTuples = expr.isBdedQuantATuple();
                ExprNode[] domains = expr.getBdedQuantBounds();
                Value[] dvals = new Value[domains.length];
                boolean isFcnRcd = true;
                for (i = 0; i < dvals.length; ++i) {
                    dvals[i] = this.eval(domains[i], c, s0, s1, control);
                    isFcnRcd = isFcnRcd && dvals[i] instanceof Reducible;
                }
                FcnParams params = new FcnParams(formals, isTuples, dvals);
                ExprOrOpArgNode fbody = args[0];
                FcnLambdaValue fval = new FcnLambdaValue(params, fbody, this, c, s0, s1, control);
                if (opcode == 16) {
                    FormalParamNode fname = expr.getUnbdedQuantSymbols()[0];
                    fval.makeRecursive(fname);
                    isFcnRcd = false;
                }
                if (isFcnRcd && !EvalControl.isKeepLazy(control)) {
                    return fval.toFcnRcd();
                }
                return fval;
            }
            case 11: {
                Value bval = this.eval(args[0], c, s0, s1, control);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as the condition of an IF.\n" + expr);
                }
                if (((BoolValue)bval).val) {
                    return this.eval(args[1], c, s0, s1, control);
                }
                return this.eval(args[2], c, s0, s1, control);
            }
            case 14: {
                OpApplNode pairNode;
                int alen = args.length;
                UniqueString[] names = new UniqueString[alen];
                Value[] vals = new Value[alen];
                for (int i8 = 0; i8 < alen; ++i8) {
                    pairNode = (OpApplNode)args[i8];
                    ExprOrOpArgNode[] pair2 = pairNode.getArgs();
                    names[i8] = ((StringValue)Value.getValue(pair2[0])).getVal();
                    vals[i8] = this.eval(pair2[1], c, s0, s1, control);
                }
                return new RecordValue(names, vals, false);
            }
            case 15: {
                Value rval = this.eval(args[0], c, s0, s1, control);
                Value sval = Value.getValue(args[1]);
                if (rval instanceof RecordValue) {
                    Value result = ((RecordValue)rval).select(sval);
                    if (result == null) {
                        Assert.fail("Attempted to select nonexistent field " + sval + " from the" + " record\n" + Value.ppr(rval.toString()) + "\n" + expr);
                    }
                    return result;
                }
                Applicable fcn = FcnRcdValue.convert(rval);
                if (fcn == null) {
                    Assert.fail("Attempted to select field " + sval + " from a non-record" + " value " + Value.ppr(rval.toString()) + "\n" + expr);
                }
                return ((FcnRcdValue)fcn).apply(sval, control);
            }
            case 18: {
                int alen = args.length;
                Value[] vals = new ValueVec(alen);
                for (int i9 = 0; i9 < alen; ++i9) {
                    vals.addElement(this.eval(args[i9], c, s0, s1, control));
                }
                return new SetEnumValue((ValueVec)vals, false);
            }
            case 19: {
                ValueVec vals = new ValueVec();
                ContextEnumerator Enum3 = this.contexts(expr, c, s0, s1, control);
                ExprOrOpArgNode body = args[0];
                while ((c1 = Enum3.nextElement()) != null) {
                    Value val = this.eval(body, c1, s0, s1, control);
                    vals.addElement(val);
                }
                return new SetEnumValue(vals, false);
            }
            case 20: {
                OpApplNode pairNode;
                int alen = args.length;
                UniqueString[] names = new UniqueString[alen];
                Value[] vals = new Value[alen];
                for (int i10 = 0; i10 < alen; ++i10) {
                    pairNode = (OpApplNode)args[i10];
                    ExprOrOpArgNode[] pair3 = pairNode.getArgs();
                    names[i10] = ((StringValue)Value.getValue(pair3[0])).getVal();
                    vals[i10] = this.eval(pair3[1], c, s0, s1, control);
                }
                return new SetOfRcdsValue(names, vals, false);
            }
            case 21: {
                Value lhs = this.eval(args[0], c, s0, s1, control);
                Value rhs = this.eval(args[1], c, s0, s1, control);
                return new SetOfFcnsValue(lhs, rhs);
            }
            case 22: {
                ExprOrOpArgNode pred = args[0];
                ExprNode inExpr = expr.getBdedQuantBounds()[0];
                Value inVal = this.eval(inExpr, c, s0, s1, control);
                boolean isTuple = expr.isBdedQuantATuple()[0];
                FormalParamNode[] bvars = expr.getBdedQuantSymbolLists()[0];
                if (inVal instanceof Reducible) {
                    ValueVec vals = new ValueVec();
                    ValueEnumeration enumSet = ((Enumerable)((Object)inVal)).elements();
                    if (isTuple) {
                        Value elem;
                        while ((elem = enumSet.nextElement()) != null) {
                            Context c17 = c;
                            Value[] tuple = ((TupleValue)elem).elems;
                            for (int i11 = 0; i11 < bvars.length; ++i11) {
                                c17 = c17.cons(bvars[i11], tuple[i11]);
                            }
                            Value bval = this.eval(pred, c17, s0, s1, control);
                            if (!(bval instanceof BoolValue)) {
                                Assert.fail("Attempted to evaluate an expression of form {x \\in S : P(x)} when P was " + bval.getKindString() + ".\n" + pred);
                            }
                            if (!((BoolValue)bval).val) continue;
                            vals.addElement(elem);
                        }
                    } else {
                        Value elem;
                        FormalParamNode idName = bvars[0];
                        while ((elem = enumSet.nextElement()) != null) {
                            Context c18 = c.cons(idName, elem);
                            Value bval = this.eval(pred, c18, s0, s1, control);
                            if (!(bval instanceof BoolValue)) {
                                Assert.fail("Attempted to evaluate an expression of form {x \\in S : P(x)} when P was " + bval.getKindString() + ".\n" + pred);
                            }
                            if (!((BoolValue)bval).val) continue;
                            vals.addElement(elem);
                        }
                    }
                    return new SetEnumValue(vals, inVal.isNormalized());
                }
                if (isTuple) {
                    return new SetPredValue(bvars, inVal, pred, this, c, s0, s1, control);
                }
                return new SetPredValue(bvars[0], inVal, pred, this, c, s0, s1, control);
            }
            case 23: {
                int alen = args.length;
                Value[] vals = new Value[alen];
                for (int i12 = 0; i12 < alen; ++i12) {
                    vals[i12] = this.eval(args[i12], c, s0, s1, control);
                }
                return new TupleValue(vals);
            }
            case 24: {
                Assert.fail("TLC attempted to evaluate an unbounded CHOOSE.\nMake sure that the expression is of form CHOOSE x \\in S: P(x).\n" + expr);
                return null;
            }
            case 25: {
                Assert.fail("TLC attempted to evaluate an unbounded \\E.\nMake sure that the expression is of form \\E x \\in S: P(x).\n" + expr);
                return null;
            }
            case 26: {
                Assert.fail("TLC attempted to evaluate an unbounded \\A.\nMake sure that the expression is of form \\A x \\in S: P(x).\n" + expr);
                return null;
            }
            case 27: {
                Value arg = this.eval(args[0], c, s0, s1, control);
                if (!(arg instanceof BoolValue)) {
                    Assert.fail("Attempted to apply the operator ~ to a non-boolean\n(" + arg.getKindString() + ")\n" + expr);
                }
                return ((BoolValue)arg).val ? ValFalse : ValTrue;
            }
            case 29: {
                Value arg = this.eval(args[0], c, s0, s1, control);
                return new SubsetValue(arg);
            }
            case 30: {
                Value arg = this.eval(args[0], c, s0, s1, control);
                return UnionValue.union(arg);
            }
            case 31: {
                Value arg = this.eval(args[0], c, s0, s1, control);
                if (!(arg instanceof Applicable)) {
                    Assert.fail("Attempted to apply the operator DOMAIN to a non-function\n(" + arg.getKindString() + ")\n" + expr);
                }
                return ((Applicable)((Object)arg)).getDomain();
            }
            case 34: {
                TLCState sfun = TLCStateFun.Empty;
                Context c19 = Context.branch(c);
                sfun = this.enabled(args[0], ActionItemList.Empty, c19, s0, sfun);
                return sfun != null ? ValTrue : ValFalse;
            }
            case 35: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                return arg1.equals(arg2) ? ValTrue : ValFalse;
            }
            case 36: {
                Value arg2;
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P /\\ Q when P was\n" + arg1.getKindString() + ".\n" + expr);
                }
                if (((BoolValue)arg1).val) {
                    arg2 = this.eval(args[1], c, s0, s1, control);
                    if (!(arg2 instanceof BoolValue)) {
                        Assert.fail("Attempted to evaluate an expression of form P /\\ Q when Q was\n" + arg2.getKindString() + ".\n" + expr);
                    }
                    return arg2;
                }
                return ValFalse;
            }
            case 37: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P \\/ Q when P was\n" + arg1.getKindString() + ".\n" + expr);
                }
                if (((BoolValue)arg1).val) {
                    return ValTrue;
                }
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                if (!(arg2 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P \\/ Q when Q was\n" + arg2.getKindString() + ".\n" + expr);
                }
                return arg2;
            }
            case 38: {
                Value arg2;
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P => Q when P was\n" + arg1.getKindString() + ".\n" + expr);
                }
                if (((BoolValue)arg1).val) {
                    arg2 = this.eval(args[1], c, s0, s1, control);
                    if (!(arg2 instanceof BoolValue)) {
                        Assert.fail("Attempted to evaluate an expression of form P => Q when Q was\n" + arg2.getKindString() + ".\n" + expr);
                    }
                    return arg2;
                }
                return ValTrue;
            }
            case 39: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                if (!(arg1 instanceof BoolValue) || !(arg2 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P <=> Q when P or Q was not a boolean.\n" + expr);
                }
                BoolValue bval1 = (BoolValue)arg1;
                BoolValue bval2 = (BoolValue)arg2;
                return bval1.val == bval2.val ? ValTrue : ValFalse;
            }
            case 40: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                return arg1.equals(arg2) ? ValFalse : ValTrue;
            }
            case 41: {
                Value elem;
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                if (!(arg1 instanceof Enumerable)) {
                    Assert.fail("Attempted to evaluate an expression of form S \\subseteq T, but S was not enumerable.\n" + expr);
                }
                ValueEnumeration Enum4 = ((Enumerable)((Object)arg1)).elements();
                while ((elem = Enum4.nextElement()) != null) {
                    if (arg2.member(elem)) continue;
                    return ValFalse;
                }
                return ValTrue;
            }
            case 42: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                return arg2.member(arg1) ? ValTrue : ValFalse;
            }
            case 43: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                return arg2.member(arg1) ? ValFalse : ValTrue;
            }
            case 44: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                if (arg1 instanceof Reducible) {
                    return ((Reducible)((Object)arg1)).diff(arg2);
                }
                return new SetDiffValue(arg1, arg2);
            }
            case 45: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                if (arg1 instanceof Reducible) {
                    return ((Reducible)((Object)arg1)).cap(arg2);
                }
                if (arg2 instanceof Reducible) {
                    return ((Reducible)((Object)arg2)).cap(arg1);
                }
                return new SetCapValue(arg1, arg2);
            }
            case 46: {
                return this.eval(args[0], c, s0, s1, control);
            }
            case 47: {
                Value arg1 = this.eval(args[0], c, s0, s1, control);
                Value arg2 = this.eval(args[1], c, s0, s1, control);
                if (arg1 instanceof Reducible) {
                    return ((Reducible)((Object)arg1)).cup(arg2);
                }
                if (arg2 instanceof Reducible) {
                    return ((Reducible)((Object)arg2)).cup(arg1);
                }
                return new SetCupValue(arg1, arg2);
            }
            case 48: {
                if (EvalControl.isEnabled(control)) {
                    return this.eval(args[0], c, s1, null, EvalControl.setPrimed(control));
                }
                return this.eval(args[0], c, s1, null, control);
            }
            case 49: {
                Value v1;
                Value v0 = this.eval(args[0], c, s0, TLCState.Empty, control);
                if (EvalControl.isEnabled(control)) {
                    control = EvalControl.setPrimed(control);
                }
                return v0.equals(v1 = this.eval(args[0], c, s1, null, control)) ? ValTrue : ValFalse;
            }
            case 50: {
                Value v1;
                Value res = this.eval(args[0], c, s0, s1, control);
                if (!(res instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form <A>_e, but A was not a boolean.\n" + expr);
                }
                if (!((BoolValue)res).val) {
                    return ValFalse;
                }
                Value v0 = this.eval(args[1], c, s0, TLCState.Empty, control);
                if (EvalControl.isEnabled(control)) {
                    control = EvalControl.setPrimed(control);
                }
                return v0.equals(v1 = this.eval(args[1], c, s1, null, control)) ? ValFalse : ValTrue;
            }
            case 51: {
                Value v1;
                Value res = this.eval(args[0], c, s0, s1, control);
                if (!(res instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form [A]_e, but A was not a boolean.\n" + expr);
                }
                if (((BoolValue)res).val) {
                    return ValTrue;
                }
                Value v0 = this.eval(args[1], c, s0, TLCState.Empty, control);
                if (EvalControl.isEnabled(control)) {
                    control = EvalControl.setPrimed(control);
                }
                return v0.equals(v1 = this.eval(args[1], c, s1, null, control)) ? ValTrue : ValFalse;
            }
            case 52: {
                Assert.fail("The current version of TLC does not support action composition.");
                return null;
            }
            case 53: {
                Assert.fail(2261, new String[]{"SF", expr.toString()});
                return null;
            }
            case 54: {
                Assert.fail(2261, new String[]{"WF", expr.toString()});
                return null;
            }
            case 55: {
                Assert.fail(2261, new String[]{"\\EE", expr.toString()});
                return null;
            }
            case 56: {
                Assert.fail(2261, new String[]{"\\AA", expr.toString()});
                return null;
            }
            case 57: {
                Assert.fail(2261, new String[]{"a ~> b", expr.toString()});
                return null;
            }
            case 58: {
                Assert.fail(2261, new String[]{"a -+-> formula", expr.toString()});
                return null;
            }
            case 59: {
                Assert.fail(2261, new String[]{"[]A", expr.toString()});
                return null;
            }
            case 60: {
                Assert.fail(2261, new String[]{"<>A", expr.toString()});
                return null;
            }
        }
        Assert.fail("TLC BUG: could not evaluate this expression.\n" + expr);
        return null;
    }

    public final boolean isGoodState(TLCState state) {
        return state.allAssigned();
    }

    public final boolean isInModel(TLCState state) throws EvalException {
        ExprNode[] constrs = this.getModelConstraints();
        for (int i = 0; i < constrs.length; ++i) {
            Value bval = this.eval(constrs[i], Context.Empty, state);
            if (!(bval instanceof BoolValue)) {
                Assert.fail(2215, new String[]{"boolean", constrs[i].toString()});
            }
            if (((BoolValue)bval).val) continue;
            return false;
        }
        return true;
    }

    public final boolean isInActions(TLCState s1, TLCState s2) throws EvalException {
        ExprNode[] constrs = this.getActionConstraints();
        for (int i = 0; i < constrs.length; ++i) {
            Value bval = this.eval(constrs[i], Context.Empty, s1, s2, 0);
            if (!(bval instanceof BoolValue)) {
                Assert.fail(2215, new String[]{"boolean", constrs[i].toString()});
            }
            if (((BoolValue)bval).val) continue;
            return false;
        }
        return true;
    }

    public final TLCState enabled(SemanticNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                return this.enabledAppl(pred1, acts, c, s0, s1);
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                OpDefNode[] letDefs = pred1.getLets();
                Context c1 = c;
                for (int i = 0; i < letDefs.length; ++i) {
                    OpDefNode opDef = letDefs[i];
                    if (opDef.getArity() != 0) continue;
                    LazyValue rhs = new LazyValue(opDef.getBody(), c1);
                    c1 = c1.cons(opDef, rhs);
                }
                return this.enabled(pred1.getBody(), acts, c1, s0, s1);
            }
            case 13: {
                SubstInNode pred1 = (SubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false));
                }
                return this.enabled(pred1.getBody(), acts, c1, s0, s1);
            }
            case 30: {
                APSubstInNode pred1 = (APSubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false));
                }
                return this.enabled(pred1.getBody(), acts, c1, s0, s1);
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                return this.enabled(pred1.getBody(), acts, c, s0, s1);
            }
        }
        Assert.fail("Attempted to compute ENABLED on a non-boolean expression.\n" + pred);
        return null;
    }

    private final TLCState enabled(ActionItemList acts, TLCState s0, TLCState s1) {
        Value v2;
        if (acts.isEmpty()) {
            return s1;
        }
        int kind = acts.carKind();
        SemanticNode pred = acts.carPred();
        Context c = acts.carContext();
        ActionItemList acts1 = acts.cdr();
        if (kind > 0) {
            if (this.callStack != null) {
                this.callStack.push(acts.carPred());
            }
            TLCState res = this.enabled(pred, acts1, c, s0, s1);
            if (this.callStack != null) {
                this.callStack.pop();
            }
            return res;
        }
        if (kind == -1) {
            return this.enabled(pred, acts1, c, s0, s1);
        }
        if (kind == -2) {
            return this.enabledUnchanged(pred, acts1, c, s0, s1);
        }
        Value v1 = this.eval(pred, c, s0, TLCState.Empty, 4);
        if (v1.equals(v2 = this.eval(pred, c, s1, null, 2))) {
            return null;
        }
        return this.enabled(acts1, s0, s1);
    }

    private final TLCState enabledAppl(OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1) {
        Value bval;
        Object bval2;
        ExprOrOpArgNode[] args = pred.getArgs();
        int alen = args.length;
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, s0, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true);
                return this.enabled(((OpDefNode)opDef).getBody(), acts, c1, s0, s1);
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                return this.enabled(((ThmOrAssumpDefNode)opDef).getBody(), acts, c1, s0, s1);
            }
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                return this.enabled(lv.expr, acts, lv.con, s0, s1);
            }
            bval2 = val;
            if (alen == 0) {
                if (val instanceof MethodValue) {
                    bval2 = ((MethodValue)val).apply(EmptyArgs, 0);
                }
            } else if (val instanceof OpValue) {
                Applicable op = (Applicable)val;
                Value[] argVals = new Value[alen];
                for (int i = 0; i < alen; ++i) {
                    argVals[i] = this.eval(args[i], c, s0, s1, 4);
                }
                bval2 = op.apply(argVals, 4);
            }
            if (opcode == 0) {
                if (!(bval2 instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"ENABLED", "boolean", bval2.toString(), pred.toString()});
                }
                if (((BoolValue)bval2).val) {
                    return this.enabled(acts, s0, s1);
                }
                return null;
            }
        }
        switch (opcode) {
            case 50: {
                ActionItemList acts1 = acts.cons(args[1], c, -3);
                return this.enabled(args[0], acts1, c, s0, s1);
            }
            case 2: {
                Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 4);
                while ((c1 = Enum2.nextElement()) != null) {
                    TLCState s2 = this.enabled(body, acts, c1, s0, s1);
                    if (s2 == null) continue;
                    return s2;
                }
                return null;
            }
            case 3: {
                Context c2;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 4);
                Context c1 = Enum2.nextElement();
                if (c1 == null) {
                    return this.enabled(acts, s0, s1);
                }
                ActionItemList acts1 = acts;
                while ((c2 = Enum2.nextElement()) != null) {
                    acts1 = acts1.cons(body, c2, -1);
                }
                return this.enabled(body, acts1, c1, s0, s1);
            }
            case 4: {
                ExprOrOpArgNode other = null;
                for (int i = 0; i < alen; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        continue;
                    }
                    Value bval3 = this.eval(pairArgs[0], c, s0, s1, 4);
                    if (!(bval3 instanceof BoolValue)) {
                        Assert.fail("In computing ENABLED, a non-boolean expression(" + bval3.getKindString() + ") was used as a guard condition" + " of a CASE.\n" + pairArgs[1]);
                    }
                    if (!((BoolValue)bval3).val) continue;
                    return this.enabled(pairArgs[1], acts, c, s0, s1);
                }
                if (other == null) {
                    Assert.fail("In computing ENABLED, TLC encountered a CASE with no conditions true.\n" + pred);
                }
                return this.enabled(other, acts, c, s0, s1);
            }
            case 6: 
            case 36: {
                ActionItemList acts1 = acts;
                for (int i = alen - 1; i > 0; --i) {
                    acts1 = acts1.cons(args[i], c, i);
                }
                if (this.callStack != null) {
                    this.callStack.push(args[0]);
                }
                TLCState res = this.enabled(args[0], acts1, c, s0, s1);
                if (this.callStack != null) {
                    this.callStack.pop();
                }
                return res;
            }
            case 7: 
            case 37: {
                for (int i = 0; i < alen; ++i) {
                    if (this.callStack != null) {
                        this.callStack.push(args[i]);
                    }
                    TLCState s2 = this.enabled(args[i], acts, c, s0, s1);
                    if (this.callStack != null) {
                        this.callStack.pop();
                    }
                    if (s2 == null) continue;
                    return s2;
                }
                return null;
            }
            case 9: {
                Applicable fcn;
                Context c1;
                Value fval = this.eval(args[0], c, s0, s1, EvalControl.setKeepLazy(4));
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        c1 = this.getFcnContext((FcnLambdaValue)fcn, args, c, s0, s1, 4);
                        return this.enabled(((FcnLambdaValue)fcn).body, acts, c1, s0, s1);
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                }
                if (fval instanceof Applicable) {
                    fcn = (Applicable)((Object)fval);
                    Value argVal = this.eval(args[1], c, s0, s1, 4);
                    Value bval4 = fcn.apply(argVal, 4);
                    if (!(bval4 instanceof BoolValue)) {
                        Assert.fail(2248, new String[]{"ENABLED", "boolean", pred.toString()});
                    }
                    if (!((BoolValue)bval4).val) {
                        return null;
                    }
                } else {
                    Assert.fail("In computing ENABLED, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + pred);
                }
                return this.enabled(acts, s0, s1);
            }
            case 11: {
                Value guard = this.eval(args[0], c, s0, s1, 4);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing ENABLED, a non-boolean expression(" + guard.getKindString() + ") was used as the guard condition" + " of an IF.\n" + pred);
                }
                int idx = ((BoolValue)guard).val ? 1 : 2;
                return this.enabled(args[idx], acts, c, s0, s1);
            }
            case 51: {
                TLCState s2 = this.enabled(args[0], acts, c, s0, s1);
                if (s2 != null) {
                    return s2;
                }
                return this.enabledUnchanged(args[1], acts, c, s0, s1);
            }
            case 55: 
            case 56: {
                Assert.fail("In computing ENABLED, TLC encountered temporal quantifier.\n" + pred);
                return null;
            }
            case 24: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded CHOOSE. Make sure that the expression is of form CHOOSE x \\in S: P(x).\n" + pred);
                return null;
            }
            case 25: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded quantifier. Make sure that the expression is of form \\E x \\in S: P(x).\n" + pred);
                return null;
            }
            case 26: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded quantifier. Make sure that the expression is of form \\A x \\in S: P(x).\n" + pred);
                return null;
            }
            case 53: {
                Assert.fail(2260, new String[]{"SF", pred.toString()});
                return null;
            }
            case 54: {
                Assert.fail(2260, new String[]{"WF", pred.toString()});
                return null;
            }
            case 59: {
                Assert.fail(2260, new String[]{"[]", pred.toString()});
                return null;
            }
            case 60: {
                Assert.fail(2260, new String[]{"<>", pred.toString()});
                return null;
            }
            case 49: {
                return this.enabledUnchanged(args[0], acts, c, s0, s1);
            }
            case 35: {
                Value rval;
                Value lval;
                UniqueString varName;
                SymbolNode var = this.getPrimedVar(args[0], c, true);
                if (var == null) {
                    bval2 = this.eval(pred, c, s0, s1, 4);
                    if (!((BoolValue)bval2).val) {
                        return null;
                    }
                } else {
                    varName = var.getName();
                    lval = s1.lookup(varName);
                    rval = this.eval(args[1], c, s0, s1, 4);
                    if (lval == null) {
                        TLCState s2 = s1.bind(var, rval, (SemanticNode)pred);
                        return this.enabled(acts, s0, s2);
                    }
                    if (!lval.equals(rval)) {
                        return null;
                    }
                }
                return this.enabled(acts, s0, s1);
            }
            case 38: {
                bval = this.eval(args[0], c, s0, s1, 4);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("While computing ENABLED of an expression of the form P => Q, P was " + bval.getKindString() + ".\n" + pred);
                }
                if (((BoolValue)bval).val) {
                    return this.enabled(args[1], acts, c, s0, s1);
                }
                return this.enabled(acts, s0, s1);
            }
            case 52: {
                Assert.fail("The current version of TLC does not support action composition.");
                return null;
            }
            case 57: {
                Assert.fail("In computing ENABLED, TLC encountered a temporal formula (a ~> b).\n" + pred);
                return null;
            }
            case 58: {
                Assert.fail("In computing ENABLED, TLC encountered a temporal formula (a -+-> formula).\n" + pred);
                return null;
            }
            case 42: {
                Value rval;
                Value lval;
                UniqueString varName;
                SymbolNode var = this.getPrimedVar(args[0], c, true);
                if (var == null) {
                    bval2 = this.eval(pred, c, s0, s1, 4);
                    if (!((BoolValue)bval2).val) {
                        return null;
                    }
                } else {
                    varName = var.getName();
                    lval = s1.lookup(varName);
                    rval = this.eval(args[1], c, s0, s1, 4);
                    if (lval == null) {
                        Value val;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("The right side of \\IN is not enumerable.\n" + pred);
                        }
                        ValueEnumeration Enum3 = ((Enumerable)((Object)rval)).elements();
                        while ((val = Enum3.nextElement()) != null) {
                            TLCState s2 = s1.bind(var, val, (SemanticNode)pred);
                            if ((s2 = this.enabled(acts, s0, s2)) == null) continue;
                            return s2;
                        }
                        return null;
                    }
                    if (!rval.member(lval)) {
                        return null;
                    }
                }
                return this.enabled(acts, s0, s1);
            }
            case 46: {
                return this.enabled(args[0], acts, c, s0, s1);
            }
        }
        bval = this.eval(pred, c, s0, s1, 4);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"ENABLED", "boolean", bval.toString(), pred.toString()});
        }
        if (((BoolValue)bval).val) {
            return this.enabled(acts, s0, s1);
        }
        return null;
    }

    private final TLCState enabledUnchanged(SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1) {
        Value v1;
        Value v0;
        SymbolNode var = this.getVar(expr, c, true);
        if (var != null) {
            UniqueString varName = var.getName();
            Value v02 = this.eval(expr, c, s0, s1, 4);
            Value v12 = s1.lookup(varName);
            if (v12 == null) {
                s1 = s1.bind(var, v02, expr);
                return this.enabled(acts, s0, s1);
            }
            if (v12.equals(v02)) {
                return this.enabled(acts, s0, s1);
            }
            MP.printWarning(2143, new String[]{varName.toString(), expr.toString()});
            return null;
        }
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            ExprOrOpArgNode[] args = expr1.getArgs();
            int alen = args.length;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opcode == 23) {
                if (alen != 0) {
                    ActionItemList acts1 = acts;
                    for (int i = 1; i < alen; ++i) {
                        acts1 = acts1.cons(args[i], c, -2);
                    }
                    return this.enabledUnchanged(args[0], acts1, c, s0, s1);
                }
                return this.enabled(acts, s0, s1);
            }
            if (opcode == 0 && alen == 0) {
                Object val = this.lookup(opNode, c, false);
                if (val instanceof LazyValue) {
                    LazyValue lv = (LazyValue)val;
                    return this.enabledUnchanged(lv.expr, acts, lv.con, s0, s1);
                }
                if (val instanceof OpDefNode) {
                    return this.enabledUnchanged(((OpDefNode)val).getBody(), acts, c, s0, s1);
                }
                if (val == null) {
                    Assert.fail("In computing ENABLED, TLC found the undefined identifier\n" + opName + " in an UNCHANGED expression at\n" + expr);
                }
                return this.enabled(acts, s0, s1);
            }
        }
        if (!(v0 = this.eval(expr, c, s0, TLCState.Empty, 4)).equals(v1 = this.eval(expr, c, s1, TLCState.Empty, 2))) {
            return null;
        }
        return this.enabled(acts, s0, s1);
    }

    public final boolean isValid(Action act, TLCState s0, TLCState s1) {
        Value val = this.eval(act.pred, act.con, s0, s1, 0);
        if (!(val instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", act.pred.toString()});
        }
        return ((BoolValue)val).val;
    }

    public final boolean isValid(Action act, TLCState state) {
        return this.isValid(act, state, TLCState.Empty);
    }

    public final boolean isValid(Action act) {
        return this.isValid(act, TLCState.Empty, TLCState.Empty);
    }

    public final boolean isValid(ExprNode expr) {
        Value val = this.eval(expr, Context.Empty, TLCState.Empty);
        if (!(val instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", expr.toString()});
        }
        return ((BoolValue)val).val;
    }

    @Override
    public final TLCStateInfo getState(long fp) {
        StateVec initStates = this.getInitStates();
        for (int i = 0; i < initStates.size(); ++i) {
            TLCState state = initStates.elementAt(i);
            long nfp = state.fingerPrint();
            if (fp != nfp) continue;
            String info = "<Initial predicate>";
            return new TLCStateInfo(state, info);
        }
        return null;
    }

    @Override
    public final TLCStateInfo getState(long fp, TLCState s) {
        for (int i = 0; i < this.actions.length; ++i) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.getNextStates(curAction, s);
            for (int j = 0; j < nextStates.size(); ++j) {
                TLCState state = nextStates.elementAt(j);
                long nfp = state.fingerPrint();
                if (fp != nfp) continue;
                return new TLCStateInfo(state, curAction.getLocation());
            }
        }
        return null;
    }

    @Override
    public final TLCStateInfo getState(TLCState s1, TLCState s) {
        for (int i = 0; i < this.actions.length; ++i) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.getNextStates(curAction, s);
            for (int j = 0; j < nextStates.size(); ++j) {
                TLCState state = nextStates.elementAt(j);
                if (!s1.equals(state)) continue;
                return new TLCStateInfo(state, curAction.getLocation());
            }
        }
        return null;
    }

    public final MVPerm[] getSymmetryPerms() {
        Value fcns;
        String name = this.config.getSymmetry();
        if (name.length() == 0) {
            return null;
        }
        Object symm = this.defns.get(name);
        if (symm == null) {
            Assert.fail(2229, new String[]{"symmetry function", name});
        }
        if (!(symm instanceof OpDefNode)) {
            Assert.fail("The symmetry function " + name + " must specify a set of permutations.");
        }
        if (!((fcns = this.eval(((OpDefNode)symm).getBody(), Context.Empty, TLCState.Empty)) instanceof Enumerable)) {
            Assert.fail("The symmetry operator must specify a set of functions.");
        }
        ValueEnumeration Enum2 = ((Enumerable)((Object)fcns)).elements();
        return MVPerm.permutationSubgroup(Enum2);
    }

    public final Context getFcnContext(FcnLambdaValue fcn, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control) {
        Context fcon = fcn.con;
        int plen = fcn.params.length();
        FormalParamNode[][] formals = fcn.params.formals;
        Value[] domains = fcn.params.domains;
        boolean[] isTuples = fcn.params.isTuples;
        Value argVal = this.eval(args[1], c, s0, s1, control);
        if (plen == 1) {
            if (!domains[0].member(argVal)) {
                Assert.fail("In applying the function\n" + Value.ppr(fcn.toString()) + ",\nthe first argument is:\n" + Value.ppr(argVal.toString()) + "which is not in its domain.\n" + args[0]);
            }
            if (isTuples[0]) {
                FormalParamNode[] ids = formals[0];
                TupleValue tv = TupleValue.convert(argVal);
                if (tv == null || argVal.size() != ids.length) {
                    Assert.fail("In applying the function\n" + Value.ppr(this.toString()) + ",\nthe argument is:\n" + Value.ppr(argVal.toString()) + "which does not match its formal parameter.\n" + args[0]);
                }
                Value[] elems = tv.elems;
                for (int i = 0; i < ids.length; ++i) {
                    fcon = fcon.cons(ids[i], elems[i]);
                }
            } else {
                fcon = fcon.cons(formals[0][0], argVal);
            }
        } else {
            TupleValue tv = TupleValue.convert(argVal);
            if (tv == null) {
                Assert.fail("Attempted to apply a function to an argument not in its domain.\n" + args[0]);
            }
            int argn = 0;
            Value[] elems = tv.elems;
            for (int i = 0; i < formals.length; ++i) {
                FormalParamNode[] ids = formals[i];
                Value domain = domains[i];
                if (isTuples[i]) {
                    TupleValue tv1;
                    if (!domain.member(elems[argn])) {
                        Assert.fail("In applying the function\n" + Value.ppr(fcn.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Value.ppr(elems[argn].toString()) + "\nwhich is not in its domain.\n" + args[0]);
                    }
                    if ((tv1 = TupleValue.convert(elems[argn++])) == null || tv1.size() != ids.length) {
                        Assert.fail("In applying the function\n" + Value.ppr(fcn.toString()) + ",\nthe argument number " + argn + " is:\n" + Value.ppr(elems[argn - 1].toString()) + "which does not match its formal parameter.\n" + args[0]);
                    }
                    Value[] avals = tv1.elems;
                    for (int j = 0; j < ids.length; ++j) {
                        fcon = fcon.cons(ids[j], avals[j]);
                    }
                    continue;
                }
                for (int j = 0; j < ids.length; ++j) {
                    if (!domain.member(elems[argn])) {
                        Assert.fail("In applying the function\n" + Value.ppr(fcn.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Value.ppr(elems[argn].toString()) + "which is not in its domain.\n" + args[0]);
                    }
                    fcon = fcon.cons(ids[j], elems[argn++]);
                }
            }
        }
        return fcon;
    }

    public final ContextEnumerator contexts(OpApplNode appl, Context c, TLCState s0, TLCState s1, int control) {
        FormalParamNode[][] formals = appl.getBdedQuantSymbolLists();
        boolean[] isTuples = appl.isBdedQuantATuple();
        ExprNode[] domains = appl.getBdedQuantBounds();
        int flen = formals.length;
        int alen = 0;
        for (int i = 0; i < flen; ++i) {
            alen += isTuples[i] ? 1 : formals[i].length;
        }
        Object[] vars = new Object[alen];
        ValueEnumeration[] enums = new ValueEnumeration[alen];
        int idx = 0;
        for (int i = 0; i < flen; ++i) {
            Value boundSet = this.eval(domains[i], c, s0, s1, control);
            if (!(boundSet instanceof Enumerable)) {
                Assert.fail("TLC encountered a non-enumerable quantifier bound\n" + Value.ppr(boundSet.toString()) + ".\n" + domains[i]);
            }
            FormalParamNode[] farg = formals[i];
            if (isTuples[i]) {
                vars[idx] = farg;
                enums[idx++] = ((Enumerable)((Object)boundSet)).elements();
                continue;
            }
            for (int j = 0; j < farg.length; ++j) {
                vars[idx] = farg[j];
                enums[idx++] = ((Enumerable)((Object)boundSet)).elements();
            }
        }
        return new ContextEnumerator(vars, enums, c);
    }

    private void processConstantDefns() {
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        for (int i = 0; i < mods.length; ++i) {
            if (mods[i].isInstantiated() && (mods[i].getConstantDecls().length != 0 || mods[i].getVariableDecls().length != 0)) continue;
            this.processConstantDefns(mods[i]);
        }
    }

    private void processConstantDefns(ModuleNode mod) {
        OpDefNode opDef;
        OpDeclNode[] consts = mod.getConstantDecls();
        for (int i = 0; i < consts.length; ++i) {
            Object val = consts[i].getToolObject(TLCGlobals.ToolId);
            if (val != null && val instanceof Value) {
                ((Value)val).deepNormalize();
                continue;
            }
            if (val == null || !(val instanceof OpDefNode)) continue;
            opDef = (OpDefNode)val;
            Assert.check(opDef.getArity() == consts[i].getArity(), 2225, new String[]{consts[i].getName().toString(), opDef.getName().toString()});
            if (opDef.getArity() != 0) continue;
            Value defVal = this.eval(opDef.getBody(), Context.Empty, TLCState.Empty);
            defVal.deepNormalize();
            consts[i].setToolObject(TLCGlobals.ToolId, defVal);
        }
        OpDefNode[] opDefs = mod.getOpDefs();
        for (int i = 0; i < opDefs.length; ++i) {
            Object realDef;
            boolean evaluate;
            opDef = opDefs[i];
            ModuleNode moduleNode = opDef.getOriginallyDefinedInModuleNode();
            boolean bl = evaluate = moduleNode == null || !moduleNode.isInstantiated() || moduleNode.getConstantDecls().length == 0 && moduleNode.getVariableDecls().length == 0;
            if (!evaluate || opDef.getArity() != 0 || !((realDef = this.lookup(opDef, Context.Empty, false)) instanceof OpDefNode) || this.getLevelBound((opDef = (OpDefNode)realDef).getBody(), Context.Empty) != 0) continue;
            try {
                UniqueString opName = opDef.getName();
                Value val = this.eval(opDef.getBody(), Context.Empty, TLCState.Empty);
                val.deepNormalize();
                opDef.setToolObject(TLCGlobals.ToolId, val);
                Object def = this.defns.get(opName);
                if (def != opDef) continue;
                this.defns.put(opName, (Object)val);
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        ModuleNode[] imods = mod.getInnerModules();
        for (int i = 0; i < imods.length; ++i) {
            this.processConstantDefns(imods[i]);
        }
    }
}

