/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicLong;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.OutputCollector;
import tlc2.tool.Action;
import tlc2.tool.Cancelable;
import tlc2.tool.EvalException;
import tlc2.tool.IWorker;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.liveness.Liveness;
import tlc2.tool.liveness.NoOpLiveCheck;
import tlc2.util.IdThread;
import tlc2.util.ObjLongTable;
import tlc2.util.StateWriter;
import tlc2.util.statistics.BucketStatistics;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;
import util.DebugPrinter;
import util.FileUtil;
import util.FilenameToStream;

public abstract class AbstractChecker
implements Cancelable {
    protected static final boolean LIVENESS_STATS = Boolean.getBoolean(Liveness.class.getPackage().getName() + ".statistics");
    protected AtomicLong numOfGenStates;
    protected TLCState predErrState;
    protected TLCState errState;
    protected boolean done;
    protected boolean keepCallStack;
    protected boolean checkDeadlock;
    protected boolean checkLiveness;
    protected String fromChkpt;
    public String metadir;
    public Tool tool;
    public final SpecObj specObj;
    public Action[] invariants;
    public Action[] impliedActions;
    public Action[] impliedInits;
    public Action[] actions;
    protected StateWriter allStateWriter;
    protected boolean cancellationFlag = false;
    protected final ILiveCheck liveCheck;

    public AbstractChecker(String specFile, String configFile, String dumpFile, boolean deadlock, String fromChkpt, boolean preprocess, FilenameToStream resolver, SpecObj spec) throws EvalException, IOException {
        this.checkDeadlock = deadlock;
        int lastSep = specFile.lastIndexOf(FileUtil.separatorChar);
        String specDir = lastSep == -1 ? "" : specFile.substring(0, lastSep + 1);
        specFile = specFile.substring(lastSep + 1);
        this.tool = new Tool(specDir, specFile, configFile, resolver);
        this.specObj = this.tool.init(preprocess, spec);
        this.checkLiveness = !this.tool.livenessIsTrue();
        OutputCollector.setModuleNode(this.tool.rootModule);
        this.metadir = FileUtil.makeMetaDir(specDir, fromChkpt);
        this.numOfGenStates = new AtomicLong(0L);
        this.errState = null;
        this.predErrState = null;
        this.done = false;
        this.keepCallStack = false;
        this.fromChkpt = fromChkpt;
        if (dumpFile != null) {
            this.allStateWriter = new StateWriter(dumpFile);
        }
        this.impliedInits = this.tool.getImpliedInits();
        this.invariants = this.tool.getInvariants();
        this.impliedActions = this.tool.getImpliedActions();
        this.actions = this.tool.getActions();
        if (this.checkLiveness) {
            this.report("initializing liveness checking");
            IBucketStatistics stats = new DummyBucketStatistics();
            if (LIVENESS_STATS) {
                stats = new BucketStatistics("Histogram vertex out-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsOutDegree");
            }
            this.liveCheck = new LiveCheck(this.tool, this.actions, this.metadir, stats);
            this.report("liveness checking initialized");
        } else {
            this.liveCheck = new NoOpLiveCheck(this.tool, this.metadir);
        }
    }

    public final void setDone() {
        this.done = true;
    }

    protected final void incNumOfGenStates(int n) {
        this.numOfGenStates.getAndAdd(n);
    }

    public boolean setErrState(TLCState curState, TLCState succState, boolean keep) {
        if (!TLCGlobals.continuation && this.done) {
            return false;
        }
        this.predErrState = curState;
        this.errState = succState == null ? curState : succState;
        this.done = true;
        this.keepCallStack = keep;
        return true;
    }

    protected void reportCoverage(IWorker[] workers) {
        if (TLCGlobals.coverageInterval >= 0) {
            MP.printMessage(2201);
            ObjLongTable counts = this.tool.getPrimedLocs();
            OutputCollector.setModuleNode(this.tool.rootModule);
            Hashtable<String, Location> locationTable = new Hashtable<String, Location>();
            for (int i = 0; i < workers.length; ++i) {
                Object key;
                ObjLongTable counts1 = workers[i].getCounts();
                ObjLongTable.Enumerator keys = counts1.keys();
                while ((key = keys.nextElement()) != null) {
                    String loc = ((SemanticNode)key).getLocation().toString();
                    counts.add(loc, counts1.get(key));
                    locationTable.put(loc, ((SemanticNode)key).getLocation());
                }
            }
            String[] skeys = counts.sortStringKeys();
            for (int i = 0; i < skeys.length; ++i) {
                long val = counts.get(skeys[i]);
                Location location = (Location)locationTable.get(skeys[i]);
                if (location == null) continue;
                OutputCollector.putLineCount(location, val);
            }
            MP.printMessage(2202);
        }
    }

    public abstract boolean doInit(boolean var1) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean runTLC(int depth) throws Exception {
        if (this.cancellationFlag) {
            return false;
        }
        if (depth < 2) {
            return true;
        }
        IdThread[] workers = this.startWorkers(this, depth);
        int count = TLCGlobals.coverageInterval / 60000;
        this.runTLCPreLoop();
        AbstractChecker abstractChecker = this;
        synchronized (abstractChecker) {
            if (!this.done) {
                this.wait(3000L);
            }
        }
        while (!this.cancellationFlag) {
            if (!this.doPeriodicWork()) {
                return false;
            }
            abstractChecker = this;
            synchronized (abstractChecker) {
                if (!this.done) {
                    this.runTLCContinueDoing(count, depth);
                    count = count == 0 ? TLCGlobals.coverageInterval / 60000 : --count;
                }
                if (this.done) {
                    break;
                }
            }
        }
        for (int i = 0; i < workers.length; ++i) {
            workers[i].join();
        }
        return true;
    }

    @Override
    public void setCancelFlag(boolean flag) {
        this.cancellationFlag = flag;
    }

    protected void report(String message) {
        DebugPrinter.print(message);
    }

    protected abstract IdThread[] startWorkers(AbstractChecker var1, int var2);

    protected void runTLCPreLoop() {
    }

    public abstract boolean doPeriodicWork() throws Exception;

    protected abstract void runTLCContinueDoing(int var1, int var2) throws Exception;

    public abstract void modelCheck() throws Exception;
}

