/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.InternalSpockError;
import spock.lang.IgnoreIf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreIfExtension
extends AbstractAnnotationDrivenExtension<IgnoreIf> {
    private static final Pattern JAVA_VERSION = Pattern.compile("(\\d+\\.\\d+).*");
    private static final Object DELEGATE = new Object(){

        public Map<String, String> getEnv() {
            return System.getenv();
        }

        public Properties getProperties() {
            return System.getProperties();
        }

        public BigDecimal getJavaVersion() {
            String versionString = System.getProperty("java.version");
            Matcher matcher = JAVA_VERSION.matcher(versionString);
            if (matcher.matches()) {
                return new BigDecimal(matcher.group(1));
            }
            throw new InternalSpockError(versionString);
        }
    };

    @Override
    public void visitSpecAnnotation(IgnoreIf annotation, SpecInfo spec) {
        this.doVisit(annotation, spec);
    }

    @Override
    public void visitFeatureAnnotation(IgnoreIf annotation, FeatureInfo feature) {
        this.doVisit(annotation, feature);
    }

    private void doVisit(IgnoreIf annotation, ISkippable skippable) {
        Closure condition = this.createCondition(annotation.value());
        Object result = this.evaluateCondition(condition);
        skippable.setSkipped(GroovyRuntimeUtil.isTruthy(result));
    }

    private Closure createCondition(Class<? extends Closure> clazz) {
        try {
            return clazz.getConstructor(Object.class, Object.class).newInstance(null, null);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate @IgnoreIf condition", e);
        }
    }

    private Object evaluateCondition(Closure condition) {
        condition.setDelegate(DELEGATE);
        condition.setResolveStrategy(3);
        try {
            return condition.call();
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to evaluate @IgnoreIf condition", e);
        }
    }
}

