/*
 * Decompiled with CFR 0.152.
 */
package de.prob.webconsole;

import com.google.gson.Gson;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@Singleton
public class OutputBuffer {
    private static final String SORRY = " lines were droped because they were not retrieved on time. Most likely this is a bug in the display code. Sorry.";
    private static final long GC_STORE_TRIGGER = 500L;
    private static final long GC_TIME_TRIGGER = 10000L;
    private final long lastGC = 0L;
    private int minLine = 0;
    private int maxLine = 0;
    private int lastHighestNumber = 0;
    private final Queue<Entry> buffer = new ConcurrentLinkedQueue<Entry>();

    public void append(String s) {
        this.buffer.add(new Entry(++this.maxLine, s + "\n", "output"));
    }

    public void error(String s) {
        this.buffer.add(new Entry(++this.maxLine, s + "\n", "error"));
    }

    public void error(String s, List<String> trace) {
        this.buffer.add(new Entry(++this.maxLine, s + "\n", "trace", trace));
    }

    public void add(String content, String msgtype) {
        this.buffer.add(new Entry(++this.maxLine, content + "\n", msgtype));
        if (this.gcNecessary()) {
            this.gc();
        }
    }

    private void gc() {
        while (!this.buffer.peek().isNewer(this.lastHighestNumber)) {
            this.buffer.poll();
        }
        this.minLine = this.buffer.peek().getNr();
    }

    private boolean gcNecessary() {
        return System.currentTimeMillis() - 0L > 10000L && (long)(this.maxLine - this.minLine) > 500L;
    }

    public String getTextAsJSon(int pos) {
        ArrayList<Entry> res = new ArrayList<Entry>();
        if (pos < this.minLine) {
            String content = this.minLine - pos + SORRY;
            res.add(new Entry(pos, content, "error"));
        }
        for (Entry e : this.buffer) {
            if (!e.isNewer(pos)) continue;
            res.add(e);
        }
        if (!res.isEmpty()) {
            this.lastHighestNumber = ((Entry)res.get(res.size() - 1)).getNr();
        }
        return new Gson().toJson(res);
    }

    public void newline() {
        this.append("\n");
    }

    private static class Entry {
        private final int nr;
        private final String content;
        private final List<String> extra;
        private final String msgtype;

        public Entry(int nr, String content, String msgtype, List<String> extra) {
            this.nr = nr;
            this.content = content;
            this.extra = extra;
            this.msgtype = msgtype;
        }

        public Entry(int nr, String content, String msgtype) {
            this(nr, content, msgtype, null);
        }

        public int getNr() {
            return this.nr;
        }

        public boolean isNewer(int pos) {
            return this.nr > pos;
        }
    }
}

