/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.APersistentTrie;
import com.github.krukow.clj_lang.EmptyIterator;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IPersistentSet;
import com.github.krukow.clj_lang.IPersistentTrie;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.MapEntry;
import com.github.krukow.clj_lang.PersistentTreeMap;
import com.github.krukow.clj_lang.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentHATTrie<T>
extends APersistentTrie<T>
implements IObj {
    private static final long serialVersionUID = -7068824281866890730L;
    final IPersistentMap meta;
    final HATTrieNode<T> root;
    final int count;
    public static final PersistentHATTrie EMPTY = new PersistentHATTrie(null, null, 0);

    public PersistentHATTrie(HATTrieNode root, IPersistentMap meta, int count) {
        this.root = root;
        this.meta = meta;
        this.count = count;
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public T getMember(String s) {
        if (this.root == null || s == null) {
            return null;
        }
        return this.root.get(s, 0);
    }

    @Override
    public IPersistentTrie<T> addMember(String s, T t) {
        if (this.root == null) {
            return new PersistentHATTrie<T>(new ContainerNode(PersistentTreeMap.EMPTY.assoc(s, t)), null, 1);
        }
        HATTrieNode<T> newRoot = this.root.add(s, 0, t);
        if (this.root == newRoot) {
            return this;
        }
        return new PersistentHATTrie<T>(newRoot, this.meta, this.count + 1);
    }

    public IPersistentSet disjoin(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object key) {
        return key instanceof String && this.getMember((String)key) != null;
    }

    public Boolean get(Object key) {
        return this.contains(key);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public IPersistentCollection cons(Object o) {
        if (!(o instanceof Map.Entry)) {
            throw new IllegalArgumentException("Only adding strings is supported");
        }
        Map.Entry e = (Map.Entry)o;
        return (IPersistentCollection)((Object)this.addMember((String)e.getKey(), e.getValue()));
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY;
    }

    @Override
    public Iterator<Map.Entry<String, T>> iterator() {
        return this.root != null ? this.root.nodeIt("") : new EmptyIterator();
    }

    @Override
    public ISeq<String> seq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IObj withMeta(IPersistentMap meta) {
        return new PersistentHATTrie<T>(this.root, meta, this.count);
    }

    public String toString() {
        if (this.root == null) {
            return "{}";
        }
        return this.root.toString();
    }

    @Override
    public boolean add(Map.Entry<String, T> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<String, T>> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContainerNode<T>
    implements HATTrieNode<T>,
    ToStringWithPrefix {
        private PersistentTreeMap<String, T> strings;

        public ContainerNode(PersistentTreeMap<String, T> strings) {
            this.strings = strings;
        }

        public String toString() {
            return this.strings.toString();
        }

        @Override
        public HATTrieNode<T> add(String s, int i, T t) {
            String ss = s.substring(i);
            Object et = this.strings.get(ss);
            if (Util.equiv(et, t)) {
                return this;
            }
            if (this.shouldBurst()) {
                return this.burst(s, i, t);
            }
            return new ContainerNode<T>(this.strings.assoc((Object)s.substring(i), t));
        }

        @Override
        public T get(String s, int i) {
            return (T)this.strings.get(s.substring(i));
        }

        private HATTrieNode burst(String s, int i, T t) {
            HATTrieNode[] children = new HATTrieNode[256];
            Object empty = s.length() == i ? t : null;
            for (Map.Entry entry : this.strings) {
                String old = (String)entry.getKey();
                Object value = entry.getValue();
                if (empty == null && "".equals(old)) {
                    empty = value;
                    continue;
                }
                char f = old.charAt(0);
                children[f] = ContainerNode.addToNode(children[f], old, value, 1);
            }
            if (empty != t) {
                char f = s.charAt(i);
                children[f] = ContainerNode.addToNode(children[f], s, t, i + 1);
            }
            return new AccessNode<T>(children, empty);
        }

        private static final <T> HATTrieNode addToNode(HATTrieNode hatTrieNode, String s, T v, int i) {
            if (hatTrieNode == null) {
                return new ContainerNode<T>(PersistentTreeMap.EMPTY.assoc(s.substring(i), v));
            }
            return hatTrieNode.add(s, i, v);
        }

        private boolean shouldBurst() {
            return this.strings.count() == 4;
        }

        @Override
        public Iterator<Map.Entry<String, T>> nodeIt(final String prefix) {
            return new Iterator<Map.Entry<String, T>>(){
                Iterator<Map.Entry<String, T>> it;
                {
                    this.it = ContainerNode.this.strings.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<String, T> next() {
                    Map.Entry next = this.it.next();
                    return new MapEntry(prefix + next.getKey(), next.getValue());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public String toStringWithPrefix(String prefix) {
            return prefix + this.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AccessNode<T>
    implements HATTrieNode<T>,
    ToStringWithPrefix {
        private final HATTrieNode<T>[] children;
        private final T emptyPtr;

        public AccessNode(HATTrieNode[] children, T emptyPtr) {
            this.children = children;
            this.emptyPtr = emptyPtr;
        }

        public String toString() {
            return this.toStringWithPrefix("");
        }

        @Override
        public String toStringWithPrefix(String prefix) {
            StringBuilder sb = new StringBuilder();
            String nestedPrefix = prefix + "  ";
            sb.append(prefix);
            sb.append("(access-node\n").append(nestedPrefix);
            for (int i = 0; i < this.children.length; ++i) {
                HATTrieNode<T> node = this.children[i];
                if (node == null) continue;
                sb.append((char)i).append(" -> ").append(((ToStringWithPrefix)((Object)node)).toStringWithPrefix(nestedPrefix)).append(";\n").append(nestedPrefix);
            }
            if (this.emptyPtr != null) {
                sb.append("\n").append(prefix).append("**");
            }
            sb.append(prefix).append(")");
            return sb.toString();
        }

        @Override
        public HATTrieNode<T> add(String s, int i, T t) {
            int length = s.length();
            if (i < length) {
                char ichar = s.charAt(i);
                HATTrieNode<T> hatTrieNode = this.children[ichar];
                if (hatTrieNode != null) {
                    HATTrieNode<T> newNode = hatTrieNode.add(s, i + 1, t);
                    if (newNode == hatTrieNode) {
                        return this;
                    }
                    HATTrieNode[] newArr = new HATTrieNode[this.children.length];
                    System.arraycopy(this.children, 0, newArr, 0, this.children.length);
                    newArr[ichar] = newNode;
                    return new AccessNode<T>(newArr, this.emptyPtr);
                }
                ContainerNode c = new ContainerNode(PersistentTreeMap.EMPTY.assoc(s.substring(i + 1), t));
                HATTrieNode[] newArr = new HATTrieNode[this.children.length];
                System.arraycopy(this.children, 0, newArr, 0, this.children.length);
                newArr[ichar] = c;
                return new AccessNode<T>(newArr, this.emptyPtr);
            }
            if (i == length && this.emptyPtr == null) {
                return new AccessNode<String>(this.children, s);
            }
            return this;
        }

        @Override
        public T get(String s, int i) {
            if (i == s.length()) {
                return this.emptyPtr;
            }
            HATTrieNode<T> c = this.children[s.charAt(i)];
            if (c == null) {
                return null;
            }
            return c.get(s, i + 1);
        }

        @Override
        public Iterator<Map.Entry<String, T>> nodeIt(String prefix) {
            return new AccessNodeIterator(this, prefix);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class AccessNodeIterator<T>
        implements Iterator<MapEntry<String, T>> {
            private final HATTrieNode[] children;
            private final T emptyPtr;
            private int index = -1;
            private final String prefix;
            Iterator<MapEntry<String, T>> current = null;

            AccessNodeIterator(AccessNode<T> node, String prefix) {
                this.children = ((AccessNode)node).children;
                this.emptyPtr = ((AccessNode)node).emptyPtr;
                this.prefix = prefix;
                this.moveCurIfNeeded();
            }

            private void moveCurIfNeeded() {
                if (this.index == -1) {
                    if (this.emptyPtr == null) {
                        this.index = 0;
                    } else {
                        return;
                    }
                }
                if (this.current != null && this.current.hasNext()) {
                    return;
                }
                while (this.index < this.children.length && this.children[this.index] == null) {
                    ++this.index;
                }
                if (this.index == this.children.length) {
                    this.current = null;
                } else {
                    String prefix = this.prefix + (char)this.index;
                    this.current = this.children[this.index++].nodeIt(prefix);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.index == -1 && this.emptyPtr != null) {
                    return true;
                }
                while (this.current != null && !this.current.hasNext()) {
                    this.moveCurIfNeeded();
                }
                return this.current != null && this.current.hasNext();
            }

            @Override
            public MapEntry<String, T> next() {
                if (this.index == -1 && this.emptyPtr != null) {
                    this.index = 0;
                    this.moveCurIfNeeded();
                    return new MapEntry<String, T>(this.prefix, this.emptyPtr);
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static interface ToStringWithPrefix {
        public String toStringWithPrefix(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface HATTrieNode<T> {
        public HATTrieNode<T> add(String var1, int var2, T var3);

        public T get(String var1, int var2);

        public Iterator<Map.Entry<String, T>> nodeIt(String var1);
    }
}

