/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.IChunk;
import com.github.krukow.clj_lang.IFn;
import com.github.krukow.clj_lang.RT;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayChunk<T>
implements IChunk<T>,
Serializable {
    final Object[] array;
    final int off;
    final int end;

    public ArrayChunk(Object[] array) {
        this(array, 0, array.length);
    }

    public ArrayChunk(Object[] array, int off) {
        this(array, off, array.length);
    }

    public ArrayChunk(Object[] array, int off, int end) {
        this.array = array;
        this.off = off;
        this.end = end;
    }

    @Override
    public T nth(int i) {
        return (T)this.array[this.off + i];
    }

    @Override
    public T nth(int i, T notFound) {
        if (i >= 0 && i < this.count()) {
            return this.nth(i);
        }
        return notFound;
    }

    @Override
    public int count() {
        return this.end - this.off;
    }

    @Override
    public IChunk<T> dropFirst() {
        if (this.off == this.end) {
            throw new IllegalStateException("dropFirst of empty chunk");
        }
        return new ArrayChunk<T>(this.array, this.off + 1, this.end);
    }

    @Override
    public Object reduce(IFn f, Object start) {
        Object ret = f.invoke(start, this.array[this.off]);
        if (RT.isReduced(ret)) {
            return ret;
        }
        for (int x = this.off + 1; x < this.end; ++x) {
            if (!RT.isReduced(ret = f.invoke(ret, this.array[x]))) continue;
            return ret;
        }
        return ret;
    }
}

