/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.AFn;
import com.github.krukow.clj_lang.IHashEq;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IPersistentSet;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.SeqIterator;
import com.github.krukow.clj_lang.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APersistentSet<T>
extends AFn
implements IPersistentSet<T>,
Collection<T>,
Set<T>,
Serializable,
IHashEq {
    int _hash = -1;
    int _hasheq = -1;
    final IPersistentMap impl;

    protected APersistentSet(IPersistentMap<T, Boolean> impl) {
        this.impl = impl;
    }

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public boolean contains(Object key) {
        return this.impl.containsKey(key);
    }

    @Override
    public Boolean get(T key) {
        return (Boolean)this.impl.valAt(key);
    }

    @Override
    public int count() {
        return this.impl.count();
    }

    @Override
    public ISeq<T> seq() {
        return RT.keys(this.impl);
    }

    @Override
    public Object invoke(Object arg1) {
        return this.get(arg1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set m = (Set)obj;
        if (m.size() != this.count()) {
            return false;
        }
        for (Object aM : m) {
            if (this.contains(aM)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equiv(Object o) {
        return this.equals(o);
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (ISeq<T> s = this.seq(); s != null; s = s.next()) {
                T e = s.first();
                hash += Util.hash(e);
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == -1) {
            int hash = 0;
            for (ISeq<T> s = this.seq(); s != null; s = s.next()) {
                T e = s.first();
                hash += Util.hasheq(e);
            }
            this._hasheq = hash;
        }
        return this._hasheq;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new SeqIterator<T>(this.seq());
    }
}

