/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.annotation.Annotation;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuleExtension
implements IGlobalExtension {
    protected static Class<? extends Annotation> ruleClass = ReflectionUtil.loadClassIfAvailable("org.junit.Rule");
    protected static Class<? extends Annotation> classRuleClass = ReflectionUtil.loadClassIfAvailable("org.junit.ClassRule");
    protected static Class<?> methodRuleClass = ReflectionUtil.loadClassIfAvailable("org.junit.rules.MethodRule");
    protected static Class<?> testRuleClass = ReflectionUtil.loadClassIfAvailable("org.junit.rules.TestRule");

    protected void checkIsInstanceField(FieldInfo field) {
        if (field.isShared() || field.isStatic()) {
            throw new InvalidSpecException("@Rule fields cannot be @Shared. Either do not make '%s' @Shared, or use @ClassRule.").withArgs(field.getName());
        }
    }

    protected void checkIsSharedField(FieldInfo field) {
        if (!field.isShared()) {
            throw new InvalidSpecException("@ClassRule fields must be @Shared. Either make '%s' @Shared, or use @Rule.").withArgs(field.getName());
        }
    }

    protected boolean hasFieldType(FieldInfo field, Class<?> ruleClass) {
        return ruleClass != null && ruleClass.isAssignableFrom(field.getType());
    }

    protected void invalidFieldType(FieldInfo field) {
        if (field.getType() == Object.class) {
            throw new InvalidSpecException("@Rule field '%s' does not have a declared type. Please add a type declaration.").withArgs(field.getName());
        }
        throw new InvalidSpecException("The declared type of @Rule field '%s' does not appear to be a rule type.").withArgs(field.getName());
    }
}

